/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.ut;

import java.math.BigInteger;
import java.net.URL;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.systest.ws.ut.server.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Test;
import wssec.ut.DoubleItPortType;
import wssec.ut.DoubleItService;

public class UsernameTokenTest
extends AbstractBusClientServerTestBase {
    static final String PORT = UsernameTokenTest.allocatePort(Server.class);

    @BeforeClass
    public static void startServers() throws Exception {
        UsernameTokenTest.assertTrue((String)"Server failed to launch", (boolean)UsernameTokenTest.launchServer(Server.class, (boolean)true));
    }

    @Test
    public void testPlaintext() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = UsernameTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        DoubleItService service = new DoubleItService();
        DoubleItPortType utPort = service.getDoubleItPlaintextPort();
        this.updateAddressPort(utPort, PORT);
        utPort.doubleIt(BigInteger.valueOf(25L));
    }

    @Test
    public void testPlaintextCreated() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = UsernameTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        DoubleItService service = new DoubleItService();
        DoubleItPortType utPort = service.getDoubleItPlaintextCreatedPort();
        this.updateAddressPort(utPort, PORT);
        utPort.doubleIt(BigInteger.valueOf(25L));
    }

    @Test
    public void testPasswordHashed() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = UsernameTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        DoubleItService service = new DoubleItService();
        DoubleItPortType utPort = service.getDoubleItHashedPort();
        this.updateAddressPort(utPort, PORT);
        utPort.doubleIt(BigInteger.valueOf(25L));
    }

    @Test
    public void testNoPassword() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = UsernameTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        DoubleItService service = new DoubleItService();
        DoubleItPortType utPort = service.getDoubleItNoPasswordPort();
        this.updateAddressPort(utPort, PORT);
        utPort.doubleIt(BigInteger.valueOf(25L));
    }

    @Test
    public void testSignedEndorsing() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = UsernameTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        DoubleItService service = new DoubleItService();
        DoubleItPortType utPort = service.getDoubleItSignedEndorsingPort();
        this.updateAddressPort(utPort, PORT);
        utPort.doubleIt(BigInteger.valueOf(25L));
    }

    @Test
    public void testSignedEncrypted() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = UsernameTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        DoubleItService service = new DoubleItService();
        DoubleItPortType utPort = service.getDoubleItSignedEncryptedPort();
        this.updateAddressPort(utPort, PORT);
        utPort.doubleIt(BigInteger.valueOf(25L));
    }

    @Test
    public void testEncrypted() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = UsernameTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        DoubleItService service = new DoubleItService();
        DoubleItPortType utPort = service.getDoubleItEncryptedPort();
        this.updateAddressPort(utPort, PORT);
        utPort.doubleIt(BigInteger.valueOf(25L));
    }
}

