/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.x509;

import java.math.BigInteger;
import java.net.URL;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.systest.ws.x509.server.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Test;
import wssec.x509.DoubleItPortType;
import wssec.x509.DoubleItService;

public class X509TokenTest
extends AbstractBusClientServerTestBase {
    static final String PORT = X509TokenTest.allocatePort(Server.class);
    static final String PORT2 = X509TokenTest.allocatePort(Server.class, (int)2);
    private boolean unrestrictedPoliciesInstalled = this.checkUnrestrictedPoliciesInstalled();

    @BeforeClass
    public static void startServers() throws Exception {
        X509TokenTest.assertTrue((String)"Server failed to launch", (boolean)X509TokenTest.launchServer(Server.class, (boolean)true));
    }

    @Test
    public void testKeyIdentifier() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        DoubleItService service = new DoubleItService();
        DoubleItPortType x509Port = service.getDoubleItKeyIdentifierPort();
        this.updateAddressPort(x509Port, PORT);
        x509Port.doubleIt(BigInteger.valueOf(25L));
    }

    @Test
    public void testIssuerSerial() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        DoubleItService service = new DoubleItService();
        DoubleItPortType x509Port = service.getDoubleItIssuerSerialPort();
        this.updateAddressPort(x509Port, PORT);
        x509Port.doubleIt(BigInteger.valueOf(25L));
    }

    @Test
    public void testThumbprint() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        DoubleItService service = new DoubleItService();
        DoubleItPortType x509Port = service.getDoubleItThumbprintPort();
        this.updateAddressPort(x509Port, PORT);
        x509Port.doubleIt(BigInteger.valueOf(25L));
    }

    @Test
    public void testAsymmetricIssuerSerial() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        DoubleItService service = new DoubleItService();
        DoubleItPortType x509Port = service.getDoubleItAsymmetricIssuerSerialPort();
        this.updateAddressPort(x509Port, PORT);
        x509Port.doubleIt(BigInteger.valueOf(25L));
    }

    @Test
    public void testAsymmetricProtectTokens() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        DoubleItService service = new DoubleItService();
        DoubleItPortType x509Port = service.getDoubleItAsymmetricProtectTokensPort();
        this.updateAddressPort(x509Port, PORT);
        x509Port.doubleIt(BigInteger.valueOf(25L));
    }

    @Test
    public void testSymmetricProtectTokens() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        DoubleItService service = new DoubleItService();
        DoubleItPortType x509Port = service.getDoubleItSymmetricProtectTokensPort();
        this.updateAddressPort(x509Port, PORT);
        x509Port.doubleIt(BigInteger.valueOf(25L));
    }

    @Test
    public void testTransportEndorsing() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        DoubleItService service = new DoubleItService();
        DoubleItPortType x509Port = service.getDoubleItTransportEndorsingPort();
        this.updateAddressPort(x509Port, PORT2);
        x509Port.doubleIt(BigInteger.valueOf(25L));
    }

    @Test
    public void testTransportSignedEndorsing() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        DoubleItService service = new DoubleItService();
        DoubleItPortType x509Port = service.getDoubleItTransportSignedEndorsingPort();
        this.updateAddressPort(x509Port, PORT2);
        x509Port.doubleIt(BigInteger.valueOf(25L));
    }

    @Test
    public void testTransportEndorsingEncrypted() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        DoubleItService service = new DoubleItService();
        DoubleItPortType x509Port = service.getDoubleItTransportEndorsingEncryptedPort();
        this.updateAddressPort(x509Port, PORT2);
        x509Port.doubleIt(BigInteger.valueOf(25L));
    }

    @Test
    public void testTransportSignedEndorsingEncrypted() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        DoubleItService service = new DoubleItService();
        DoubleItPortType x509Port = service.getDoubleItTransportSignedEndorsingEncryptedPort();
        this.updateAddressPort(x509Port, PORT2);
        x509Port.doubleIt(BigInteger.valueOf(25L));
    }

    private boolean checkUnrestrictedPoliciesInstalled() {
        try {
            byte[] data = new byte[]{0, 1, 2, 3, 4, 5, 6, 7};
            SecretKeySpec key192 = new SecretKeySpec(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23}, "AES");
            Cipher c = Cipher.getInstance("AES");
            c.init(1, key192);
            c.doFinal(data);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

