/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.security;

import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Endpoint;
import javax.xml.ws.Provider;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceProvider;
import javax.xml.xpath.XPathConstants;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.helpers.XPathUtils;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.systest.ws.common.DoubleItImpl;
import org.apache.cxf.systest.ws.security.KeystorePasswordCallback;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.ws.security.WSPasswordCallback;
import org.example.contract.doubleit.DoubleItPortType;
import org.example.contract.doubleit.DoubleItPortTypeHeader;
import org.example.schema.doubleit.DoubleIt;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SecurityPolicyTest
extends AbstractBusClientServerTestBase {
    public static final String PORT = SecurityPolicyTest.allocatePort(SecurityPolicyTest.class);
    public static final String SSL_PORT = SecurityPolicyTest.allocatePort(SecurityPolicyTest.class, (int)1);
    public static final String POLICY_ADDRESS = "http://localhost:" + PORT + "/SecPolTest";
    public static final String POLICY_HTTPS_ADDRESS = "https://localhost:" + SSL_PORT + "/SecPolTest";
    public static final String POLICY_ENCSIGN_ADDRESS = "http://localhost:" + PORT + "/SecPolTestEncryptThenSign";
    public static final String POLICY_SIGNENC_ADDRESS = "http://localhost:" + PORT + "/SecPolTestSignThenEncrypt";
    public static final String POLICY_SIGNENC_PROVIDER_ADDRESS = "http://localhost:" + PORT + "/SecPolTestSignThenEncryptProvider";
    public static final String POLICY_SIGN_ADDRESS = "http://localhost:" + PORT + "/SecPolTestSign";
    public static final String POLICY_XPATH_ADDRESS = "http://localhost:" + PORT + "/SecPolTestXPath";
    public static final String POLICY_SIGNONLY_ADDRESS = "http://localhost:" + PORT + "/SecPolTestSignedOnly";
    public static final String POLICY_CXF3041_ADDRESS = "http://localhost:" + PORT + "/SecPolTestCXF3041";
    public static final String POLICY_CXF3042_ADDRESS = "http://localhost:" + PORT + "/SecPolTestCXF3042";
    public static final String POLICY_CXF3452_ADDRESS = "http://localhost:" + PORT + "/SecPolTestCXF3452";
    private static final String NAMESPACE = "http://www.example.org/contract/DoubleIt";
    private static final QName SERVICE_QNAME = new QName("http://www.example.org/contract/DoubleIt", "DoubleItService");

    @BeforeClass
    public static void init() throws Exception {
        URL wsdl = SecurityPolicyTest.class.getResource("DoubleIt.wsdl");
        ((PolicyEngine)SecurityPolicyTest.createStaticBus((String)SecurityPolicyTest.class.getResource("https_config.xml").toString()).getExtension(PolicyEngine.class)).setEnabled(true);
        SecurityPolicyTest.getStaticBus().getOutInterceptors().add(new LoggingOutInterceptor());
        EndpointImpl ep = (EndpointImpl)Endpoint.create((Object)new DoubleItImpl());
        ep.setEndpointName(new QName(NAMESPACE, "DoubleItPortHttps"));
        ep.setWsdlLocation(wsdl.getPath());
        ep.setAddress(POLICY_HTTPS_ADDRESS);
        ep.publish();
        ep.getServer().getEndpoint().getEndpointInfo().setProperty("ws-security.callback-handler", (Object)new ServerPasswordCallback());
        Endpoint.publish((String)POLICY_ADDRESS, (Object)new DoubleItImpl());
        ep = (EndpointImpl)Endpoint.create((Object)new DoubleItImpl());
        ep.setEndpointName(new QName(NAMESPACE, "DoubleItPortEncryptThenSign"));
        ep.setWsdlLocation(wsdl.getPath());
        ep.setAddress(POLICY_ENCSIGN_ADDRESS);
        ep.publish();
        EndpointInfo ei = ep.getServer().getEndpoint().getEndpointInfo();
        SecurityPolicyTest.setCryptoProperties(ei, "bob.properties", "alice.properties");
        ep = (EndpointImpl)Endpoint.create((Object)new DoubleItImpl());
        ep.setEndpointName(new QName(NAMESPACE, "DoubleItPortSignThenEncrypt"));
        ep.setWsdlLocation(wsdl.getPath());
        ep.setAddress(POLICY_SIGNENC_ADDRESS);
        ep.publish();
        ei = ep.getServer().getEndpoint().getEndpointInfo();
        SecurityPolicyTest.setCryptoProperties(ei, "bob.properties", "alice.properties");
        ep = (EndpointImpl)Endpoint.create((Object)new DoubleItImpl());
        ep.setEndpointName(new QName(NAMESPACE, "DoubleItPortSign"));
        ep.setWsdlLocation(wsdl.getPath());
        ep.setAddress(POLICY_SIGN_ADDRESS);
        ep.publish();
        ei = ep.getServer().getEndpoint().getEndpointInfo();
        SecurityPolicyTest.setCryptoProperties(ei, "bob.properties", "alice.properties");
        ep = (EndpointImpl)Endpoint.create((Object)new DoubleItImpl());
        ep.setEndpointName(new QName(NAMESPACE, "DoubleItPortXPath"));
        ep.setWsdlLocation(wsdl.getPath());
        ep.setAddress(POLICY_XPATH_ADDRESS);
        ep.publish();
        ei = ep.getServer().getEndpoint().getEndpointInfo();
        SecurityPolicyTest.setCryptoProperties(ei, "alice.properties", "bob.properties");
        ep = (EndpointImpl)Endpoint.publish((String)POLICY_SIGNENC_PROVIDER_ADDRESS, (Object)new DoubleItProvider());
        ei = ep.getServer().getEndpoint().getEndpointInfo();
        SecurityPolicyTest.setCryptoProperties(ei, "bob.properties", "alice.properties");
        ep = (EndpointImpl)Endpoint.create((Object)new DoubleItImpl());
        ep.setEndpointName(new QName(NAMESPACE, "DoubleItPortSignedOnly"));
        ep.setWsdlLocation(wsdl.getPath());
        ep.setAddress(POLICY_SIGNONLY_ADDRESS);
        ep.publish();
        ei = ep.getServer().getEndpoint().getEndpointInfo();
        SecurityPolicyTest.setCryptoProperties(ei, "bob.properties", "alice.properties");
        ep = (EndpointImpl)Endpoint.create((Object)new DoubleItImpl());
        ep.setEndpointName(new QName(NAMESPACE, "DoubleItPortCXF3041"));
        ep.setWsdlLocation(wsdl.getPath());
        ep.setAddress(POLICY_CXF3041_ADDRESS);
        ep.publish();
        ei = ep.getServer().getEndpoint().getEndpointInfo();
        SecurityPolicyTest.setCryptoProperties(ei, "bob.properties", "alice.properties");
        ep = (EndpointImpl)Endpoint.create((Object)new DoubleItImpl());
        ep.setEndpointName(new QName(NAMESPACE, "DoubleItPortCXF3042"));
        ep.setWsdlLocation(wsdl.getPath());
        ep.setAddress(POLICY_CXF3042_ADDRESS);
        ep.publish();
        ei = ep.getServer().getEndpoint().getEndpointInfo();
        SecurityPolicyTest.setCryptoProperties(ei, "alice.properties", "alice.properties");
        ep = (EndpointImpl)Endpoint.create((Object)new DoubleItImpl());
        ep.setEndpointName(new QName(NAMESPACE, "DoubleItPortCXF3452"));
        ep.setWsdlLocation(wsdl.getPath());
        ep.setAddress(POLICY_CXF3452_ADDRESS);
        ep.publish();
        ei = ep.getServer().getEndpoint().getEndpointInfo();
        SecurityPolicyTest.setCryptoProperties(ei, "alice.properties", "alice.properties");
        ei.setProperty("schema-validation-enabled", (Object)Boolean.TRUE);
    }

    private static void setCryptoProperties(EndpointInfo ei, String sigProps, String encProps) {
        ei.setProperty("ws-security.callback-handler", (Object)new KeystorePasswordCallback());
        ei.setProperty("ws-security.signature.properties", (Object)SecurityPolicyTest.class.getResource(sigProps).toString());
        ei.setProperty("ws-security.encryption.properties", (Object)SecurityPolicyTest.class.getResource(encProps).toString());
    }

    @Test
    public void testPolicy() throws Exception {
        block5: {
            String msg;
            DoubleItPortType pt;
            QName portQName;
            Service service;
            block4: {
                SpringBusFactory bf = new SpringBusFactory();
                Bus bus = bf.createBus();
                SpringBusFactory.setDefaultBus((Bus)bus);
                SpringBusFactory.setThreadDefaultBus((Bus)bus);
                URL wsdl = SecurityPolicyTest.class.getResource("DoubleIt.wsdl");
                service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
                portQName = new QName(NAMESPACE, "DoubleItPortXPath");
                pt = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
                this.updateAddressPort(pt, PORT);
                ((BindingProvider)pt).getRequestContext().put("ws-security.callback-handler", new KeystorePasswordCallback());
                ((BindingProvider)pt).getRequestContext().put("ws-security.signature.properties", ((Object)((Object)this)).getClass().getResource("alice.properties"));
                ((BindingProvider)pt).getRequestContext().put("ws-security.encryption.properties", ((Object)((Object)this)).getClass().getResource("bob.properties"));
                SecurityPolicyTest.assertEquals((long)10L, (long)pt.doubleIt(5));
                portQName = new QName(NAMESPACE, "DoubleItPortEncryptThenSign");
                pt = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
                this.updateAddressPort(pt, PORT);
                ((BindingProvider)pt).getRequestContext().put("ws-security.callback-handler", new KeystorePasswordCallback());
                ((BindingProvider)pt).getRequestContext().put("ws-security.signature.properties", ((Object)((Object)this)).getClass().getResource("alice.properties"));
                ((BindingProvider)pt).getRequestContext().put("ws-security.encryption.properties", ((Object)((Object)this)).getClass().getResource("bob.properties"));
                pt.doubleIt(5);
                portQName = new QName(NAMESPACE, "DoubleItPortSign");
                pt = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
                this.updateAddressPort(pt, PORT);
                ((BindingProvider)pt).getRequestContext().put("ws-security.callback-handler", new KeystorePasswordCallback());
                ((BindingProvider)pt).getRequestContext().put("ws-security.signature.properties", ((Object)((Object)this)).getClass().getResource("alice.properties"));
                ((BindingProvider)pt).getRequestContext().put("ws-security.encryption.properties", ((Object)((Object)this)).getClass().getResource("bob.properties"));
                pt.doubleIt(5);
                portQName = new QName(NAMESPACE, "DoubleItPortSignThenEncrypt");
                pt = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
                this.updateAddressPort(pt, PORT);
                ((BindingProvider)pt).getRequestContext().put("ws-security.callback-handler", new KeystorePasswordCallback());
                ((BindingProvider)pt).getRequestContext().put("ws-security.signature.properties", ((Object)((Object)this)).getClass().getResource("alice.properties"));
                ((BindingProvider)pt).getRequestContext().put("ws-security.encryption.properties", ((Object)((Object)this)).getClass().getResource("bob.properties"));
                pt.doubleIt(5);
                ((BindingProvider)pt).getRequestContext().put("javax.xml.ws.service.endpoint.address", POLICY_SIGNENC_PROVIDER_ADDRESS);
                int x = pt.doubleIt(5);
                SecurityPolicyTest.assertEquals((long)10L, (long)x);
                portQName = new QName(NAMESPACE, "DoubleItPortHttps");
                pt = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
                this.updateAddressPort(pt, SSL_PORT);
                try {
                    pt.doubleIt(25);
                }
                catch (Exception ex) {
                    msg = ex.getMessage();
                    if (msg.contains("sername")) break block4;
                    throw ex;
                }
            }
            ((BindingProvider)pt).getRequestContext().put("ws-security.username", "bob");
            ((BindingProvider)pt).getRequestContext().put("ws-security.signature.username", "bob");
            ((BindingProvider)pt).getRequestContext().put("ws-security.password", "pwd");
            pt.doubleIt(25);
            try {
                portQName = new QName(NAMESPACE, "DoubleItPortHttp");
                pt = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
                this.updateAddressPort(pt, PORT);
                pt.doubleIt(25);
                SecurityPolicyTest.fail((String)"https policy should have triggered");
            }
            catch (Exception ex) {
                msg = ex.getMessage();
                if (msg.contains("HttpsToken")) break block5;
                throw ex;
            }
        }
    }

    @Test
    public void testSignedOnlyWithUnsignedMessage() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        Bus bus = bf.createBus();
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SecurityPolicyTest.class.getResource("DoubleIt.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItPortSignedOnly");
        DoubleItPortType pt = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(pt, PORT);
        ((BindingProvider)pt).getRequestContext().put("ws-security.callback-handler", new KeystorePasswordCallback());
        ((BindingProvider)pt).getRequestContext().put("ws-security.signature.properties", ((Object)((Object)this)).getClass().getResource("alice.properties"));
        ((BindingProvider)pt).getRequestContext().put("ws-security.encryption.properties", ((Object)((Object)this)).getClass().getResource("bob.properties"));
        SecurityPolicyTest.assertEquals((long)10L, (long)pt.doubleIt(5));
        portQName = new QName(NAMESPACE, "DoubleItPortTimestampOnly");
        pt = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        ((BindingProvider)pt).getRequestContext().put("javax.xml.ws.service.endpoint.address", POLICY_SIGNONLY_ADDRESS);
        try {
            pt.doubleIt(5);
            SecurityPolicyTest.fail((String)"should have had a security/policy exception as the body wasn't signed");
        }
        catch (Exception ex) {
            SecurityPolicyTest.assertTrue((boolean)ex.getMessage().contains("policy alternatives"));
        }
    }

    @Test
    public void testDispatchClient() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        Bus bus = bf.createBus();
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SecurityPolicyTest.class.getResource("DoubleIt.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItPortEncryptThenSign");
        Dispatch disp = service.createDispatch(portQName, Source.class, Service.Mode.PAYLOAD);
        disp.getRequestContext().put("ws-security.callback-handler", new KeystorePasswordCallback());
        disp.getRequestContext().put("ws-security.signature.properties", ((Object)((Object)this)).getClass().getResource("alice.properties"));
        disp.getRequestContext().put("ws-security.encryption.properties", ((Object)((Object)this)).getClass().getResource("bob.properties"));
        this.updateAddressPort(disp, PORT);
        String req = "<ns2:DoubleIt xmlns:ns2=\"http://www.example.org/schema/DoubleIt\"><numberToDouble>25</numberToDouble></ns2:DoubleIt>";
        Source source = new StreamSource(new StringReader(req));
        source = (Source)disp.invoke((Object)source);
        Node nd = XMLUtils.fromSource((Source)source);
        if (nd instanceof Document) {
            nd = ((Document)nd).getDocumentElement();
        }
        HashMap<String, String> ns = new HashMap<String, String>();
        ns.put("ns2", "http://www.example.org/schema/DoubleIt");
        XPathUtils xp = new XPathUtils(ns);
        Object o = xp.getValue("//ns2:DoubleItResponse/doubledNumber", nd, XPathConstants.STRING);
        SecurityPolicyTest.assertEquals((String)XMLUtils.toString((Node)nd), (Object)"50", (Object)o);
    }

    @Test
    public void testCXF3041() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        Bus bus = bf.createBus();
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SecurityPolicyTest.class.getResource("DoubleIt.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItPortCXF3041");
        DoubleItPortType pt = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(pt, PORT);
        ((BindingProvider)pt).getRequestContext().put("ws-security.callback-handler", new KeystorePasswordCallback());
        ((BindingProvider)pt).getRequestContext().put("ws-security.signature.properties", ((Object)((Object)this)).getClass().getResource("alice.properties"));
        ((BindingProvider)pt).getRequestContext().put("ws-security.encryption.properties", ((Object)((Object)this)).getClass().getResource("bob.properties"));
        SecurityPolicyTest.assertEquals((long)10L, (long)pt.doubleIt(5));
    }

    @Test
    public void testCXF3042() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        Bus bus = bf.createBus();
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SecurityPolicyTest.class.getResource("DoubleIt.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItPortCXF3042");
        DoubleItPortType pt = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(pt, PORT);
        ((BindingProvider)pt).getRequestContext().put("ws-security.callback-handler", new KeystorePasswordCallback());
        ((BindingProvider)pt).getRequestContext().put("ws-security.signature.properties", ((Object)((Object)this)).getClass().getResource("alice.properties"));
        ((BindingProvider)pt).getRequestContext().put("ws-security.encryption.properties", ((Object)((Object)this)).getClass().getResource("alice.properties"));
        SecurityPolicyTest.assertEquals((long)10L, (long)pt.doubleIt(5));
    }

    @Test
    public void testCXF3452() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        Bus bus = bf.createBus();
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SecurityPolicyTest.class.getResource("DoubleIt.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItPortCXF3452");
        DoubleItPortTypeHeader pt = (DoubleItPortTypeHeader)service.getPort(portQName, DoubleItPortTypeHeader.class);
        this.updateAddressPort(pt, PORT);
        ((BindingProvider)pt).getRequestContext().put("ws-security.callback-handler", new KeystorePasswordCallback());
        ((BindingProvider)pt).getRequestContext().put("ws-security.signature.properties", ((Object)((Object)this)).getClass().getResource("alice.properties"));
        ((BindingProvider)pt).getRequestContext().put("ws-security.encryption.properties", ((Object)((Object)this)).getClass().getResource("alice.properties"));
        DoubleIt di = new DoubleIt();
        di.setNumberToDouble(5);
        SecurityPolicyTest.assertEquals((long)10L, (long)pt.doubleIt(di, 1).getDoubledNumber());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @WebServiceProvider(targetNamespace="http://www.example.org/contract/DoubleIt", portName="DoubleItPortSignThenEncrypt", serviceName="DoubleItService", wsdlLocation="classpath:/org/apache/cxf/systest/ws/security/DoubleIt.wsdl")
    @ServiceMode(value=Service.Mode.PAYLOAD)
    public static class DoubleItProvider
    implements Provider<Source> {
        public Source invoke(Source obj) {
            Node el;
            try {
                el = XMLUtils.fromSource((Source)obj);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (el instanceof Document) {
                el = ((Document)el).getDocumentElement();
            }
            HashMap<String, String> ns = new HashMap<String, String>();
            ns.put("ns2", "http://www.example.org/schema/DoubleIt");
            XPathUtils xp = new XPathUtils(ns);
            String o = (String)xp.getValue("//ns2:DoubleIt/numberToDouble", el, XPathConstants.STRING);
            int i = Integer.parseInt(o);
            String req = "<ns2:DoubleItResponse xmlns:ns2=\"http://www.example.org/schema/DoubleIt\"><doubledNumber>" + Integer.toString(i * 2) + "</doubledNumber></ns2:DoubleItResponse>";
            return new StreamSource(new StringReader(req));
        }
    }

    public static class ServerPasswordCallback
    implements CallbackHandler {
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            WSPasswordCallback pc = (WSPasswordCallback)callbacks[0];
            if (pc.getIdentifier().equals("bob")) {
                pc.setPassword("pwd");
            }
        }
    }
}

