/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.wssec10;

import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.systest.ws.wssec10.server.AuthorizedServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Test;
import wssec.wssec10.IPingService;
import wssec.wssec10.PingService;

public class WSSecurity10UsernameAuthorizationTest
extends AbstractBusClientServerTestBase {
    static final String SSL_PORT = WSSecurity10UsernameAuthorizationTest.allocatePort(AuthorizedServer.class, (int)1);
    static final String PORT = WSSecurity10UsernameAuthorizationTest.allocatePort(AuthorizedServer.class);
    private static final String INPUT = "foo";

    @BeforeClass
    public static void startServers() throws Exception {
        WSSecurity10UsernameAuthorizationTest.assertTrue((String)"Server failed to launch", (boolean)WSSecurity10UsernameAuthorizationTest.launchServer(AuthorizedServer.class, (boolean)true));
    }

    @Test
    public void testClientServerUTOnlyAuthorized() {
        IPingService port = WSSecurity10UsernameAuthorizationTest.getUTOnlyPort("org/apache/cxf/systest/ws/wssec10/client/client_restricted.xml", false);
        String output = port.echo(INPUT);
        WSSecurity10UsernameAuthorizationTest.assertEquals((Object)INPUT, (Object)output);
    }

    @Test
    public void testClientServerUTOnlyUnauthorized() {
        IPingService port = WSSecurity10UsernameAuthorizationTest.getUTOnlyPort("org/apache/cxf/systest/ws/wssec10/client/client_restricted_unauthorized.xml", true);
        try {
            port.echo(INPUT);
            WSSecurity10UsernameAuthorizationTest.fail((String)"Frank is unauthorized");
        }
        catch (Exception ex) {
            WSSecurity10UsernameAuthorizationTest.assertEquals((Object)"Unauthorized", (Object)ex.getMessage());
        }
    }

    @Test
    public void testClientServerComplexPolicyAuthorized() {
        IPingService port = WSSecurity10UsernameAuthorizationTest.getComplexPolicyPort("org/apache/cxf/systest/ws/wssec10/client/client_restricted.xml");
        String output = port.echo(INPUT);
        WSSecurity10UsernameAuthorizationTest.assertEquals((Object)INPUT, (Object)output);
    }

    @Test
    public void testClientServerComplexPolicyUnauthorized() {
        IPingService port = WSSecurity10UsernameAuthorizationTest.getComplexPolicyPort("org/apache/cxf/systest/ws/wssec10/client/client_restricted_unauthorized.xml");
        try {
            port.echo(INPUT);
            WSSecurity10UsernameAuthorizationTest.fail((String)"Frank is unauthorized");
        }
        catch (Exception ex) {
            WSSecurity10UsernameAuthorizationTest.assertEquals((Object)"Unauthorized", (Object)ex.getMessage());
        }
    }

    private static IPingService getComplexPolicyPort(String configName) {
        Bus bus = new SpringBusFactory().createBus(configName);
        BusFactory.setDefaultBus((Bus)bus);
        BusFactory.setThreadDefaultBus((Bus)bus);
        PingService svc = new PingService(WSSecurity10UsernameAuthorizationTest.getWsdlLocation("UserNameOverTransport"));
        IPingService port = (IPingService)svc.getPort(new QName("http://WSSec/wssec10", "UserNameOverTransport_IPingService"), IPingService.class);
        return port;
    }

    private static IPingService getUTOnlyPort(String configName, boolean hashed) {
        Bus bus = new SpringBusFactory().createBus(configName);
        BusFactory.setDefaultBus((Bus)bus);
        BusFactory.setThreadDefaultBus((Bus)bus);
        PingService svc = new PingService(WSSecurity10UsernameAuthorizationTest.getWsdlLocation(hashed));
        IPingService port = (IPingService)svc.getPort(new QName("http://WSSec/wssec10", hashed ? "UserName_IPingService_hashed" : "UserName_IPingService"), IPingService.class);
        return port;
    }

    private static URL getWsdlLocation(boolean hashed) {
        try {
            return new URL("http://localhost:" + PORT + "/" + (hashed ? "HashedUserName" : "UserName") + "?wsdl");
        }
        catch (MalformedURLException mue) {
            return null;
        }
    }

    private static URL getWsdlLocation(String portPrefix) {
        try {
            if ("UserNameOverTransport".equals(portPrefix)) {
                return new URL("https://localhost:" + SSL_PORT + "/" + portPrefix + "?wsdl");
            }
            if ("MutualCertificate10SignEncrypt".equals(portPrefix)) {
                return new URL("http://localhost:" + PORT + "/" + portPrefix + "?wsdl");
            }
            if ("MutualCertificate10SignEncryptRsa15TripleDes".equals(portPrefix)) {
                return new URL("http://localhost:" + PORT + "/" + portPrefix + "?wsdl");
            }
        }
        catch (MalformedURLException mue) {
            return null;
        }
        return null;
    }
}

