/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.coverage_checker;

import java.net.URL;
import java.util.HashMap;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.systest.ws.coverage_checker.server.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;
import org.example.contract.doubleit.DoubleItPortType;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class DefaultCryptoCoverageCheckerTest
extends AbstractBusClientServerTestBase {
    public static final String PORT = DefaultCryptoCoverageCheckerTest.allocatePort(Server.class);
    private static final String NAMESPACE = "http://www.example.org/contract/DoubleIt";
    private static final QName SERVICE_QNAME = new QName("http://www.example.org/contract/DoubleIt", "DoubleItService");
    private boolean unrestrictedPoliciesInstalled = this.checkUnrestrictedPoliciesInstalled();

    @BeforeClass
    public static void startServers() throws Exception {
        DefaultCryptoCoverageCheckerTest.assertTrue((String)"Server failed to launch", (boolean)DefaultCryptoCoverageCheckerTest.launchServer(Server.class, (boolean)true));
    }

    @AfterClass
    public static void cleanup() throws Exception {
        DefaultCryptoCoverageCheckerTest.stopAllServers();
    }

    @Test
    public void testSignedBodyTimestamp() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = DefaultCryptoCoverageCheckerTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = DefaultCryptoCoverageCheckerTest.class.getResource("DoubleItCoverageChecker.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItBodyTimestampPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        HashMap<String, String> outProps = new HashMap<String, String>();
        outProps.put("action", "Timestamp Signature");
        outProps.put("signaturePropFile", "org/apache/cxf/systest/ws/wssec10/client/alice.properties");
        outProps.put("user", "alice");
        outProps.put("passwordCallbackClass", "org.apache.cxf.systest.ws.wssec10.client.KeystorePasswordCallback");
        outProps.put("signatureParts", "{}{http://schemas.xmlsoap.org/soap/envelope/}Body;{}{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd}Timestamp;");
        bus.getOutInterceptors().add(new WSS4JOutInterceptor(outProps));
        port.doubleIt(25);
        bus.shutdown(true);
    }

    @Test
    public void testSignedBodyOnly() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = DefaultCryptoCoverageCheckerTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = DefaultCryptoCoverageCheckerTest.class.getResource("DoubleItCoverageChecker.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItBodyTimestampPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        HashMap<String, String> outProps = new HashMap<String, String>();
        outProps.put("action", "Timestamp Signature");
        outProps.put("signaturePropFile", "org/apache/cxf/systest/ws/wssec10/client/alice.properties");
        outProps.put("user", "alice");
        outProps.put("passwordCallbackClass", "org.apache.cxf.systest.ws.wssec10.client.KeystorePasswordCallback");
        outProps.put("signatureParts", "{}{http://schemas.xmlsoap.org/soap/envelope/}Body;");
        bus.getOutInterceptors().add(new WSS4JOutInterceptor(outProps));
        try {
            port.doubleIt(25);
            DefaultCryptoCoverageCheckerTest.fail((String)"Failure expected on not signing the Timestamp");
        }
        catch (Exception ex) {
            // empty catch block
        }
        bus.shutdown(true);
    }

    @Test
    public void testSignedTimestampOnly() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = DefaultCryptoCoverageCheckerTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = DefaultCryptoCoverageCheckerTest.class.getResource("DoubleItCoverageChecker.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItBodyTimestampPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        HashMap<String, String> outProps = new HashMap<String, String>();
        outProps.put("action", "Timestamp Signature");
        outProps.put("signaturePropFile", "org/apache/cxf/systest/ws/wssec10/client/alice.properties");
        outProps.put("user", "alice");
        outProps.put("passwordCallbackClass", "org.apache.cxf.systest.ws.wssec10.client.KeystorePasswordCallback");
        outProps.put("signatureParts", "{}{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd}Timestamp;");
        bus.getOutInterceptors().add(new WSS4JOutInterceptor(outProps));
        try {
            port.doubleIt(25);
            DefaultCryptoCoverageCheckerTest.fail((String)"Failure expected on not signing the Timestamp");
        }
        catch (Exception ex) {
            // empty catch block
        }
        bus.shutdown(true);
    }

    @Test
    public void testSignedBodyTimestampSoap12() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = DefaultCryptoCoverageCheckerTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = DefaultCryptoCoverageCheckerTest.class.getResource("DoubleItCoverageChecker.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItBodyTimestampSoap12Port");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        HashMap<String, String> outProps = new HashMap<String, String>();
        outProps.put("action", "Timestamp Signature");
        outProps.put("signaturePropFile", "org/apache/cxf/systest/ws/wssec10/client/alice.properties");
        outProps.put("user", "alice");
        outProps.put("passwordCallbackClass", "org.apache.cxf.systest.ws.wssec10.client.KeystorePasswordCallback");
        outProps.put("signatureParts", "{}{http://www.w3.org/2003/05/soap-envelope}Body;{}{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd}Timestamp;");
        bus.getOutInterceptors().add(new WSS4JOutInterceptor(outProps));
        port.doubleIt(25);
        bus.shutdown(true);
    }

    @Test
    public void testSignedBodyOnlySoap12() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = DefaultCryptoCoverageCheckerTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = DefaultCryptoCoverageCheckerTest.class.getResource("DoubleItCoverageChecker.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItBodyTimestampSoap12Port");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        HashMap<String, String> outProps = new HashMap<String, String>();
        outProps.put("action", "Timestamp Signature");
        outProps.put("signaturePropFile", "org/apache/cxf/systest/ws/wssec10/client/alice.properties");
        outProps.put("user", "alice");
        outProps.put("passwordCallbackClass", "org.apache.cxf.systest.ws.wssec10.client.KeystorePasswordCallback");
        outProps.put("signatureParts", "{}{http://www.w3.org/2003/05/soap-envelope}Body;");
        bus.getOutInterceptors().add(new WSS4JOutInterceptor(outProps));
        try {
            port.doubleIt(25);
            DefaultCryptoCoverageCheckerTest.fail((String)"Failure expected on not signing the Timestamp");
        }
        catch (Exception ex) {
            // empty catch block
        }
        bus.shutdown(true);
    }

    @Test
    public void testSignedTimestampOnlySoap12() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = DefaultCryptoCoverageCheckerTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = DefaultCryptoCoverageCheckerTest.class.getResource("DoubleItCoverageChecker.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItBodyTimestampSoap12Port");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        HashMap<String, String> outProps = new HashMap<String, String>();
        outProps.put("action", "Timestamp Signature");
        outProps.put("signaturePropFile", "org/apache/cxf/systest/ws/wssec10/client/alice.properties");
        outProps.put("user", "alice");
        outProps.put("passwordCallbackClass", "org.apache.cxf.systest.ws.wssec10.client.KeystorePasswordCallback");
        outProps.put("signatureParts", "{}{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd}Timestamp;");
        bus.getOutInterceptors().add(new WSS4JOutInterceptor(outProps));
        try {
            port.doubleIt(25);
            DefaultCryptoCoverageCheckerTest.fail((String)"Failure expected on not signing the Timestamp");
        }
        catch (Exception ex) {
            // empty catch block
        }
        bus.shutdown(true);
    }

    @Test
    public void testSignedEncryptedBody() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = DefaultCryptoCoverageCheckerTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = DefaultCryptoCoverageCheckerTest.class.getResource("DoubleItCoverageChecker.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSignedEncryptedBodyPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        HashMap<String, String> outProps = new HashMap<String, String>();
        outProps.put("action", "Timestamp Signature Encrypt");
        outProps.put("signaturePropFile", "org/apache/cxf/systest/ws/wssec10/client/alice.properties");
        outProps.put("encryptionPropFile", "org/apache/cxf/systest/ws/wssec10/client/bob.properties");
        outProps.put("user", "alice");
        outProps.put("encryptionUser", "bob");
        outProps.put("passwordCallbackClass", "org.apache.cxf.systest.ws.wssec10.client.KeystorePasswordCallback");
        outProps.put("signatureParts", "{}{http://schemas.xmlsoap.org/soap/envelope/}Body;");
        outProps.put("encryptionParts", "{}{http://schemas.xmlsoap.org/soap/envelope/}Body;");
        bus.getOutInterceptors().add(new WSS4JOutInterceptor(outProps));
        port.doubleIt(25);
        bus.shutdown(true);
    }

    @Test
    public void testSignedNotEncryptedBody() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = DefaultCryptoCoverageCheckerTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = DefaultCryptoCoverageCheckerTest.class.getResource("DoubleItCoverageChecker.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSignedEncryptedBodyPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        HashMap<String, String> outProps = new HashMap<String, String>();
        outProps.put("action", "Timestamp Signature Encrypt");
        outProps.put("signaturePropFile", "org/apache/cxf/systest/ws/wssec10/client/alice.properties");
        outProps.put("encryptionPropFile", "org/apache/cxf/systest/ws/wssec10/client/bob.properties");
        outProps.put("user", "alice");
        outProps.put("encryptionUser", "bob");
        outProps.put("passwordCallbackClass", "org.apache.cxf.systest.ws.wssec10.client.KeystorePasswordCallback");
        outProps.put("signatureParts", "{}{http://schemas.xmlsoap.org/soap/envelope/}Body;");
        outProps.put("encryptionParts", "{}{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd}Timestamp;");
        bus.getOutInterceptors().add(new WSS4JOutInterceptor(outProps));
        try {
            port.doubleIt(25);
            DefaultCryptoCoverageCheckerTest.fail((String)"Failure expected on not encrypting the SOAP Body");
        }
        catch (Exception ex) {
            // empty catch block
        }
        bus.shutdown(true);
    }

    @Test
    public void testWSAddressing() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = DefaultCryptoCoverageCheckerTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = DefaultCryptoCoverageCheckerTest.class.getResource("DoubleItCoverageChecker.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItWSAPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        HashMap<String, String> outProps = new HashMap<String, String>();
        outProps.put("action", "Timestamp Signature");
        outProps.put("signaturePropFile", "org/apache/cxf/systest/ws/wssec10/client/alice.properties");
        outProps.put("user", "alice");
        outProps.put("passwordCallbackClass", "org.apache.cxf.systest.ws.wssec10.client.KeystorePasswordCallback");
        outProps.put("signatureParts", "{}{http://schemas.xmlsoap.org/soap/envelope/}Body;{}{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd}Timestamp;");
        WSS4JOutInterceptor wss4jOutInterceptor = new WSS4JOutInterceptor(outProps);
        bus.getOutInterceptors().add(wss4jOutInterceptor);
        try {
            port.doubleIt(25);
            DefaultCryptoCoverageCheckerTest.fail((String)"Failure expected on not signing the WS-Addressing headers");
        }
        catch (Exception ex) {
            // empty catch block
        }
        bus.getOutInterceptors().remove(wss4jOutInterceptor);
        outProps.put("signatureParts", "{}{http://schemas.xmlsoap.org/soap/envelope/}Body;{}{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd}Timestamp;{}{http://www.w3.org/2005/08/addressing}ReplyTo;");
        wss4jOutInterceptor = new WSS4JOutInterceptor(outProps);
        bus.getOutInterceptors().add(wss4jOutInterceptor);
        port.doubleIt(25);
        bus.shutdown(true);
    }

    private boolean checkUnrestrictedPoliciesInstalled() {
        try {
            byte[] data = new byte[]{0, 1, 2, 3, 4, 5, 6, 7};
            SecretKeySpec key192 = new SecretKeySpec(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23}, "AES");
            Cipher c = Cipher.getInstance("AES");
            c.init(1, key192);
            c.doFinal(data);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

