/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.gcm;

import java.net.URL;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.systest.ws.gcm.server.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.example.contract.doubleit.DoubleItPortType;
import org.junit.BeforeClass;
import org.junit.Test;

public class GCMTest
extends AbstractBusClientServerTestBase {
    static final String PORT = GCMTest.allocatePort(Server.class);
    private static final String NAMESPACE = "http://www.example.org/contract/DoubleIt";
    private static final QName SERVICE_QNAME = new QName("http://www.example.org/contract/DoubleIt", "DoubleItService");
    private boolean unrestrictedPoliciesInstalled = this.checkUnrestrictedPoliciesInstalled();

    @BeforeClass
    public static void startServers() throws Exception {
        GCMTest.assertTrue((String)"Server failed to launch", (boolean)GCMTest.launchServer(Server.class, (boolean)true));
    }

    @Test
    public void testAESGCM128() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = GCMTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = GCMTest.class.getResource("DoubleItGCM.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItGCM128Port");
        DoubleItPortType gcmPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(gcmPort, PORT);
        gcmPort.doubleIt(25);
    }

    @Test
    public void testAESGCM192() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = GCMTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = GCMTest.class.getResource("DoubleItGCM.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItGCM192Port");
        DoubleItPortType gcmPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(gcmPort, PORT);
        gcmPort.doubleIt(25);
    }

    @Test
    public void testAESGCM256() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = GCMTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = GCMTest.class.getResource("DoubleItGCM.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItGCM256Port");
        DoubleItPortType gcmPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(gcmPort, PORT);
        gcmPort.doubleIt(25);
    }

    private boolean checkUnrestrictedPoliciesInstalled() {
        try {
            byte[] data = new byte[]{0, 1, 2, 3, 4, 5, 6, 7};
            SecretKeySpec key192 = new SecretKeySpec(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23}, "AES");
            Cipher c = Cipher.getInstance("AES");
            c.init(1, key192);
            c.doFinal(data);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

