/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.saml;

import java.net.URL;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.systest.ws.saml.client.SamlCallbackHandler;
import org.apache.cxf.systest.ws.saml.server.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.ws.security.saml.ext.bean.KeyInfoBean;
import org.example.contract.doubleit.DoubleItPortType;
import org.junit.BeforeClass;
import org.junit.Test;

public class SamlTokenTest
extends AbstractBusClientServerTestBase {
    static final String PORT = SamlTokenTest.allocatePort(Server.class);
    static final String PORT2 = SamlTokenTest.allocatePort(Server.class, (int)2);
    private static final String NAMESPACE = "http://www.example.org/contract/DoubleIt";
    private static final QName SERVICE_QNAME = new QName("http://www.example.org/contract/DoubleIt", "DoubleItService");
    private boolean unrestrictedPoliciesInstalled = this.checkUnrestrictedPoliciesInstalled();

    @BeforeClass
    public static void startServers() throws Exception {
        SamlTokenTest.assertTrue((String)"Server failed to launch", (boolean)SamlTokenTest.launchServer(Server.class, (boolean)true));
    }

    @Test
    public void testSaml1OverTransport() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlTokenTest.class.getResource("DoubleItSaml.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml1TransportPort");
        DoubleItPortType saml1Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(saml1Port, PORT2);
        try {
            saml1Port.doubleIt(25);
            SamlTokenTest.fail((String)"Expected failure on an invocation with no SAML Assertion");
        }
        catch (SOAPFaultException ex) {
            SamlTokenTest.assertTrue((boolean)ex.getMessage().contains("No SAML CallbackHandler available"));
        }
        ((BindingProvider)saml1Port).getRequestContext().put("ws-security.saml-callback-handler", new SamlCallbackHandler());
        try {
            saml1Port.doubleIt(25);
            SamlTokenTest.fail((String)"Expected failure on an invocation with a SAML2 Assertion");
        }
        catch (SOAPFaultException ex) {
            SamlTokenTest.assertTrue((boolean)ex.getMessage().contains("Wrong SAML Version"));
        }
        ((BindingProvider)saml1Port).getRequestContext().put("ws-security.saml-callback-handler", new SamlCallbackHandler(false));
        int result = saml1Port.doubleIt(25);
        SamlTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
    }

    @Test
    public void testSaml2OverSymmetric() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlTokenTest.class.getResource("DoubleItSaml.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2SymmetricPort");
        DoubleItPortType saml2Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(saml2Port, PORT);
        try {
            saml2Port.doubleIt(25);
            SamlTokenTest.fail((String)"Expected failure on an invocation with no SAML Assertion");
        }
        catch (SOAPFaultException ex) {
            SamlTokenTest.assertTrue((boolean)ex.getMessage().contains("No SAML CallbackHandler available"));
        }
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", new SamlCallbackHandler(false));
        try {
            saml2Port.doubleIt(25);
            SamlTokenTest.fail((String)"Expected failure on an invocation with a SAML1 Assertion");
        }
        catch (SOAPFaultException ex) {
            SamlTokenTest.assertTrue((boolean)ex.getMessage().contains("Wrong SAML Version"));
        }
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", new SamlCallbackHandler());
        int result = saml2Port.doubleIt(25);
        SamlTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        try {
            SamlCallbackHandler callbackHandler = new SamlCallbackHandler();
            callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
            ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", callbackHandler);
            saml2Port.doubleIt(25);
            SamlTokenTest.fail((String)"Expected failure on an invocation with a invalid SAML2 Assertion");
        }
        catch (SOAPFaultException ex) {
            SamlTokenTest.assertTrue((boolean)ex.getMessage().contains("SAML token security failure"));
        }
    }

    @Test
    public void testSaml2OverSymmetricSupporting() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlTokenTest.class.getResource("DoubleItSaml.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2SymmetricSupportingPort");
        DoubleItPortType saml2Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(saml2Port, PORT);
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", new SamlCallbackHandler());
        try {
            saml2Port.doubleIt(25);
            SamlTokenTest.fail((String)"Expected failure on an invocation with an unsigned SAML SV Assertion");
        }
        catch (SOAPFaultException ex) {
            SamlTokenTest.assertTrue((boolean)ex.getMessage().contains("Assertion fails sender-vouches requirements"));
        }
    }

    @Test
    public void testSaml2OverAsymmetric() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlTokenTest.class.getResource("DoubleItSaml.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2AsymmetricPort");
        DoubleItPortType saml2Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(saml2Port, PORT);
        try {
            saml2Port.doubleIt(25);
            SamlTokenTest.fail((String)"Expected failure on an invocation with no SAML Assertion");
        }
        catch (SOAPFaultException ex) {
            SamlTokenTest.assertTrue((boolean)ex.getMessage().contains("No SAML CallbackHandler available"));
        }
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", new SamlCallbackHandler(false));
        try {
            saml2Port.doubleIt(25);
            SamlTokenTest.fail((String)"Expected failure on an invocation with a SAML1 Assertion");
        }
        catch (SOAPFaultException ex) {
            SamlTokenTest.assertTrue((boolean)ex.getMessage().contains("Wrong SAML Version"));
        }
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", new SamlCallbackHandler());
        int result = saml2Port.doubleIt(25);
        SamlTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
    }

    @Test
    public void testSaml1SelfSignedOverTransport() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlTokenTest.class.getResource("DoubleItSaml.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml1SelfSignedTransportPort");
        DoubleItPortType saml1Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(saml1Port, PORT2);
        ((BindingProvider)saml1Port).getRequestContext().put("ws-security.saml-callback-handler", new SamlCallbackHandler(false));
        int result = saml1Port.doubleIt(25);
        SamlTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
    }

    @Test
    public void testSaml1SelfSignedOverTransportSP11() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlTokenTest.class.getResource("DoubleItSaml.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml1SelfSignedTransportSP11Port");
        DoubleItPortType saml1Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(saml1Port, PORT2);
        ((BindingProvider)saml1Port).getRequestContext().put("ws-security.saml-callback-handler", new SamlCallbackHandler(false));
        int result = saml1Port.doubleIt(25);
        SamlTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        bus.shutdown(true);
    }

    @Test
    public void testAsymmetricSamlInitiator() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlTokenTest.class.getResource("DoubleItSaml.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItAsymmetricSamlInitiatorPort");
        DoubleItPortType saml2Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(saml2Port, PORT);
        SamlCallbackHandler callbackHandler = new SamlCallbackHandler();
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", callbackHandler);
        int result = saml2Port.doubleIt(25);
        SamlTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
    }

    @Test
    public void testSaml2OverSymmetricSignedElements() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlTokenTest.class.getResource("DoubleItSaml.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2SymmetricSignedElementsPort");
        DoubleItPortType saml2Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(saml2Port, PORT);
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", new SamlCallbackHandler());
        int result = saml2Port.doubleIt(25);
        SamlTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
    }

    @Test
    public void testSaml2EndorsingOverTransport() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlTokenTest.class.getResource("DoubleItSaml.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2EndorsingTransportPort");
        DoubleItPortType saml2Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(saml2Port, PORT2);
        SamlCallbackHandler callbackHandler = new SamlCallbackHandler();
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", callbackHandler);
        int result = saml2Port.doubleIt(25);
        SamlTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
    }

    @Test
    public void testSaml2EndorsingPKOverTransport() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlTokenTest.class.getResource("DoubleItSaml.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2EndorsingTransportPort");
        DoubleItPortType saml2Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(saml2Port, PORT2);
        SamlCallbackHandler callbackHandler = new SamlCallbackHandler();
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        callbackHandler.setKeyInfoIdentifier(KeyInfoBean.CERT_IDENTIFIER.KEY_VALUE);
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", callbackHandler);
        int result = saml2Port.doubleIt(25);
        SamlTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        bus.shutdown(true);
    }

    @Test
    public void testSaml2EndorsingOverTransportSP11() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlTokenTest.class.getResource("DoubleItSaml.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2EndorsingTransportSP11Port");
        DoubleItPortType saml2Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(saml2Port, PORT2);
        SamlCallbackHandler callbackHandler = new SamlCallbackHandler();
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", callbackHandler);
        int result = saml2Port.doubleIt(25);
        SamlTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        bus.shutdown(true);
    }

    @Test
    public void testSaml2OverAsymmetricSignedEncrypted() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlTokenTest.class.getResource("DoubleItSaml.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2AsymmetricSignedEncryptedPort");
        DoubleItPortType saml2Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(saml2Port, PORT);
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", new SamlCallbackHandler());
        int result = saml2Port.doubleIt(25);
        SamlTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
    }

    @Test
    public void testSaml2OverAsymmetricEncrypted() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlTokenTest.class.getResource("DoubleItSaml.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2AsymmetricEncryptedPort");
        DoubleItPortType saml2Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(saml2Port, PORT);
        SamlCallbackHandler callbackHandler = new SamlCallbackHandler();
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", callbackHandler);
        int result = saml2Port.doubleIt(25);
        SamlTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
    }

    @Test
    public void testSaml2EndorsingEncryptedOverTransport() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlTokenTest.class.getResource("DoubleItSaml.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2EndorsingEncryptedTransportPort");
        DoubleItPortType saml2Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(saml2Port, PORT2);
        SamlCallbackHandler callbackHandler = new SamlCallbackHandler();
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        ((BindingProvider)saml2Port).getRequestContext().put("ws-security.saml-callback-handler", callbackHandler);
        int result = saml2Port.doubleIt(25);
        SamlTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
    }

    @Test
    public void testNoSamlToken() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlTokenTest.class.getResource("DoubleItSaml.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItInlinePolicyPort");
        DoubleItPortType saml2Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(saml2Port, PORT2);
        try {
            saml2Port.doubleIt(25);
            SamlTokenTest.fail((String)"Failure expected on no SamlToken");
        }
        catch (SOAPFaultException ex) {
            String error = "The received token does not match the token inclusion requirement";
            SamlTokenTest.assertTrue((boolean)ex.getMessage().contains(error));
        }
    }

    private boolean checkUnrestrictedPoliciesInstalled() {
        try {
            byte[] data = new byte[]{0, 1, 2, 3, 4, 5, 6, 7};
            SecretKeySpec key192 = new SecretKeySpec(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23}, "AES");
            Cipher c = Cipher.getInstance("AES");
            c.init(1, key192);
            c.doFinal(data);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

