/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.kerberos;

import java.net.URL;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.kerberos.server.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.example.contract.doubleit.DoubleItPortType;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class KerberosTokenTest
extends AbstractBusClientServerTestBase {
    static final String PORT = KerberosTokenTest.allocatePort(Server.class);
    static final String PORT2 = KerberosTokenTest.allocatePort(Server.class, (int)2);
    private static final String NAMESPACE = "http://www.example.org/contract/DoubleIt";
    private static final QName SERVICE_QNAME = new QName("http://www.example.org/contract/DoubleIt", "DoubleItService");
    private boolean unrestrictedPoliciesInstalled = this.checkUnrestrictedPoliciesInstalled();

    @BeforeClass
    public static void startServers() throws Exception {
        KerberosTokenTest.assertTrue((String)"Server failed to launch", (boolean)KerberosTokenTest.launchServer(Server.class, (boolean)true));
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        KerberosTokenTest.stopAllServers();
    }

    @Test
    @Ignore
    public void testKerberosOverTransport() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = KerberosTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = KerberosTokenTest.class.getResource("DoubleItKerberos.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItKerberosTransportPort");
        DoubleItPortType kerberosPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(kerberosPort, PORT2);
        int result = kerberosPort.doubleIt(25);
        KerberosTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        bus.shutdown(true);
    }

    @Test
    @Ignore
    public void testKerberosOverSymmetric() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = KerberosTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = KerberosTokenTest.class.getResource("DoubleItKerberos.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItKerberosSymmetricPort");
        DoubleItPortType kerberosPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(kerberosPort, PORT);
        int result = kerberosPort.doubleIt(25);
        KerberosTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        bus.shutdown(true);
    }

    @Test
    @Ignore
    public void testKerberosOverSymmetricSupporting() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = KerberosTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = KerberosTokenTest.class.getResource("DoubleItKerberos.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItKerberosSymmetricSupportingPort");
        DoubleItPortType kerberosPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(kerberosPort, PORT);
        int result = kerberosPort.doubleIt(25);
        KerberosTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        bus.shutdown(true);
    }

    @Test
    @Ignore
    public void testKerberosOverAsymmetric() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = KerberosTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = KerberosTokenTest.class.getResource("DoubleItKerberos.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItKerberosAsymmetricPort");
        DoubleItPortType kerberosPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(kerberosPort, PORT);
        int result = kerberosPort.doubleIt(25);
        KerberosTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        bus.shutdown(true);
    }

    @Test
    @Ignore
    public void testKerberosOverTransportEndorsing() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = KerberosTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = KerberosTokenTest.class.getResource("DoubleItKerberos.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItKerberosTransportEndorsingPort");
        DoubleItPortType kerberosPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(kerberosPort, PORT2);
        int result = kerberosPort.doubleIt(25);
        KerberosTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        bus.shutdown(true);
    }

    @Test
    @Ignore
    public void testKerberosOverAsymmetricEndorsing() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = KerberosTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = KerberosTokenTest.class.getResource("DoubleItKerberos.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItKerberosAsymmetricEndorsingPort");
        DoubleItPortType kerberosPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(kerberosPort, PORT);
        int result = kerberosPort.doubleIt(25);
        KerberosTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        bus.shutdown(true);
    }

    @Test
    @Ignore
    public void testKerberosOverSymmetricProtection() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = KerberosTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = KerberosTokenTest.class.getResource("DoubleItKerberos.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItKerberosSymmetricProtectionPort");
        DoubleItPortType kerberosPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(kerberosPort, PORT);
        int result = kerberosPort.doubleIt(25);
        KerberosTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        bus.shutdown(true);
    }

    @Test
    @Ignore
    public void testKerberosOverSymmetricDerivedProtection() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = KerberosTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = KerberosTokenTest.class.getResource("DoubleItKerberos.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItKerberosSymmetricDerivedProtectionPort");
        DoubleItPortType kerberosPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(kerberosPort, PORT);
        int result = kerberosPort.doubleIt(25);
        KerberosTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        bus.shutdown(true);
    }

    @Test
    @Ignore
    public void testKerberosOverAsymmetricSignedEndorsing() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = KerberosTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = KerberosTokenTest.class.getResource("DoubleItKerberos.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItKerberosAsymmetricSignedEndorsingPort");
        DoubleItPortType kerberosPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(kerberosPort, PORT);
        int result = kerberosPort.doubleIt(25);
        KerberosTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        bus.shutdown(true);
    }

    @Test
    @Ignore
    public void testKerberosOverAsymmetricSignedEncrypted() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = KerberosTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = KerberosTokenTest.class.getResource("DoubleItKerberos.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItKerberosAsymmetricSignedEncryptedPort");
        DoubleItPortType kerberosPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(kerberosPort, PORT);
        int result = kerberosPort.doubleIt(25);
        KerberosTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        bus.shutdown(true);
    }

    @Test
    @Ignore
    public void testKerberosOverSymmetricEndorsingEncrypted() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = KerberosTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = KerberosTokenTest.class.getResource("DoubleItKerberos.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItKerberosSymmetricEndorsingEncryptedPort");
        DoubleItPortType kerberosPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(kerberosPort, PORT);
        int result = kerberosPort.doubleIt(25);
        KerberosTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        bus.shutdown(true);
    }

    @Test
    @Ignore
    public void testKerberosOverSymmetricSignedEndorsingEncrypted() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = KerberosTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = KerberosTokenTest.class.getResource("DoubleItKerberos.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItKerberosSymmetricSignedEndorsingEncryptedPort");
        DoubleItPortType kerberosPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(kerberosPort, PORT);
        int result = kerberosPort.doubleIt(25);
        KerberosTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        bus.shutdown(true);
    }

    private boolean checkUnrestrictedPoliciesInstalled() {
        try {
            byte[] data = new byte[]{0, 1, 2, 3, 4, 5, 6, 7};
            SecretKeySpec key192 = new SecretKeySpec(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23}, "AES");
            Cipher c = Cipher.getInstance("AES");
            c.init(1, key192);
            c.doFinal(data);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

