/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.policy;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.util.List;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.policy.server.JavaFirstPolicyServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaFirstPolicyServiceTest
extends AbstractBusClientServerTestBase {
    static final String PORT = JavaFirstPolicyServiceTest.allocatePort(JavaFirstPolicyServer.class);
    static final String PORT2 = JavaFirstPolicyServiceTest.allocatePort(JavaFirstPolicyServer.class, (int)2);
    private static final String WSDL_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/";

    @BeforeClass
    public static void startServers() throws Exception {
        JavaFirstPolicyServiceTest.assertTrue((String)"Server failed to launch", (boolean)JavaFirstPolicyServiceTest.launchServer(JavaFirstPolicyServer.class, (boolean)true));
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        JavaFirstPolicyServiceTest.stopAllServers();
    }

    @Test
    public void testJavaFirstWsdl() throws Exception {
        HttpURLConnection connection = this.getHttpConnection("http://localhost:" + PORT2 + "/JavaFirstPolicyService?wsdl");
        InputStream is = connection.getInputStream();
        String wsdlContents = IOUtils.toString((InputStream)is);
        Document doc = DOMUtils.readXml((Reader)new StringReader(wsdlContents));
        Element portType = DOMUtils.getFirstChildWithName((Element)doc.getDocumentElement(), (String)WSDL_NAMESPACE, (String)"portType");
        JavaFirstPolicyServiceTest.assertNotNull((Object)portType);
        List operationMessages = DOMUtils.getChildrenWithName((Element)portType, (String)WSDL_NAMESPACE, (String)"operation");
        JavaFirstPolicyServiceTest.assertEquals((long)5L, (long)operationMessages.size());
        Element operationOne = this.getOperationMessage("doOperationOne", operationMessages);
        JavaFirstPolicyServiceTest.assertEquals((Object)"#InternalTransportAndUsernamePolicy", (Object)this.getPolicyReferenceId(operationOne));
        Element operationTwo = this.getOperationMessage("doOperationTwo", operationMessages);
        JavaFirstPolicyServiceTest.assertEquals((Object)"#TransportAndUsernamePolicy", (Object)this.getPolicyReferenceId(operationTwo));
        Element operationThree = this.getOperationMessage("doOperationThree", operationMessages);
        JavaFirstPolicyServiceTest.assertEquals((Object)"#InternalTransportAndUsernamePolicy", (Object)this.getPolicyReferenceId(operationThree));
        Element operationFour = this.getOperationMessage("doOperationFour", operationMessages);
        JavaFirstPolicyServiceTest.assertEquals((Object)"#TransportAndUsernamePolicy", (Object)this.getPolicyReferenceId(operationFour));
        Element operationPing = this.getOperationMessage("doPing", operationMessages);
        JavaFirstPolicyServiceTest.assertNull((Object)this.getPolicyReferenceId(operationPing));
        List policyMessages = DOMUtils.getChildrenWithName((Element)doc.getDocumentElement(), (String)"http://www.w3.org/ns/ws-policy", (String)"Policy");
        JavaFirstPolicyServiceTest.assertEquals((long)2L, (long)policyMessages.size());
        JavaFirstPolicyServiceTest.assertEquals((Object)"TransportAndUsernamePolicy", (Object)this.getPolicyId((Element)policyMessages.get(0)));
        JavaFirstPolicyServiceTest.assertEquals((Object)"InternalTransportAndUsernamePolicy", (Object)this.getPolicyId((Element)policyMessages.get(1)));
    }

    private String getPolicyId(Element element) {
        return element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
    }

    private Element getOperationMessage(String operationName, List<Element> operationMessages) {
        Element operationElement = null;
        for (Element operation : operationMessages) {
            if (!operationName.equals(operation.getAttribute("name"))) continue;
            operationElement = operation;
            break;
        }
        JavaFirstPolicyServiceTest.assertNotNull(operationElement);
        return operationElement;
    }

    private String getPolicyReferenceId(Element operationMessage) {
        Element inputMessage = DOMUtils.getFirstChildWithName((Element)operationMessage, (String)WSDL_NAMESPACE, (String)"input");
        JavaFirstPolicyServiceTest.assertNotNull((Object)inputMessage);
        Element policyReference = DOMUtils.getFirstChildWithName((Element)inputMessage, (String)"http://www.w3.org/ns/ws-policy", (String)"PolicyReference");
        if (policyReference != null) {
            return policyReference.getAttribute("URI");
        }
        return null;
    }
}

