/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.security.handler;

import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.security.handler.HelloWorld;
import org.apache.cxf.systest.ws.security.handler.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class WSSecTest
extends AbstractBusClientServerTestBase {
    public static final String PORT = WSSecTest.allocatePort(Server.class);

    @BeforeClass
    public static void startServers() throws Exception {
        WSSecTest.assertTrue((String)"Server failed to launch", (boolean)WSSecTest.launchServer(Server.class));
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        WSSecTest.stopAllServers();
    }

    @Test
    public void testClientServer() throws Exception {
        Bus bus = new SpringBusFactory().createBus("org/apache/cxf/systest/ws/security/handler/client.xml");
        BusFactory.setDefaultBus((Bus)bus);
        BusFactory.setThreadDefaultBus((Bus)bus);
        Service service = Service.create((URL)new URL("http://localhost:" + PORT + "/wsse/HelloWorldWS?wsdl"), (QName)new QName("http://cxf.apache.org/wsse/handler/helloworld", "HelloWorldImplService"));
        QName portName = new QName("http://cxf.apache.org/wsse/handler/helloworld", "HelloWorldPort");
        HelloWorld port = (HelloWorld)service.getPort(portName, HelloWorld.class);
        this.updateAddressPort(port, PORT);
        WSSecTest.assertEquals((Object)"Hello CXF", (Object)port.sayHello("CXF"));
        bus.shutdown(true);
    }
}

