/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.ut;

import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.ut.SecurityHeaderCacheInterceptor;
import org.apache.cxf.systest.ws.ut.server.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.example.contract.doubleit.DoubleItPortType;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class UsernameTokenTest
extends AbstractBusClientServerTestBase {
    static final String PORT = UsernameTokenTest.allocatePort(Server.class);
    private static final String NAMESPACE = "http://www.example.org/contract/DoubleIt";
    private static final QName SERVICE_QNAME = new QName("http://www.example.org/contract/DoubleIt", "DoubleItService");

    @BeforeClass
    public static void startServers() throws Exception {
        UsernameTokenTest.assertTrue((String)"Server failed to launch", (boolean)UsernameTokenTest.launchServer(Server.class, (boolean)true));
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        UsernameTokenTest.stopAllServers();
    }

    @Test
    public void testPlaintext() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = UsernameTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = UsernameTokenTest.class.getResource("DoubleItUt.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItPlaintextPort");
        DoubleItPortType utPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(utPort, PORT);
        utPort.doubleIt(25);
        bus.shutdown(true);
    }

    @Test
    public void testPlaintextCreated() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = UsernameTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = UsernameTokenTest.class.getResource("DoubleItUt.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItPlaintextCreatedPort");
        DoubleItPortType utPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(utPort, PORT);
        utPort.doubleIt(25);
        bus.shutdown(true);
    }

    @Test
    public void testPasswordHashed() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = UsernameTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = UsernameTokenTest.class.getResource("DoubleItUt.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItHashedPort");
        DoubleItPortType utPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(utPort, PORT);
        utPort.doubleIt(25);
        bus.shutdown(true);
    }

    @Test
    public void testNoPassword() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = UsernameTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = UsernameTokenTest.class.getResource("DoubleItUt.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItNoPasswordPort");
        DoubleItPortType utPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(utPort, PORT);
        utPort.doubleIt(25);
        bus.shutdown(true);
    }

    @Test
    public void testSignedEndorsing() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = UsernameTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = UsernameTokenTest.class.getResource("DoubleItUt.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSignedEndorsingPort");
        DoubleItPortType utPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(utPort, PORT);
        utPort.doubleIt(25);
        bus.shutdown(true);
    }

    @Test
    public void testSignedEncrypted() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = UsernameTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = UsernameTokenTest.class.getResource("DoubleItUt.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSignedEncryptedPort");
        DoubleItPortType utPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(utPort, PORT);
        utPort.doubleIt(25);
        bus.shutdown(true);
    }

    @Test
    public void testEncrypted() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = UsernameTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = UsernameTokenTest.class.getResource("DoubleItUt.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItEncryptedPort");
        DoubleItPortType utPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(utPort, PORT);
        utPort.doubleIt(25);
        bus.shutdown(true);
    }

    @Test
    public void testNoUsernameToken() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = UsernameTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = UsernameTokenTest.class.getResource("DoubleItUt.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItInlinePolicyPort");
        DoubleItPortType utPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(utPort, PORT);
        try {
            utPort.doubleIt(25);
            UsernameTokenTest.fail((String)"Failure expected on no UsernameToken");
        }
        catch (SOAPFaultException ex) {
            String error = "The received token does not match the token inclusion requirement";
            UsernameTokenTest.assertTrue((boolean)ex.getMessage().contains(error));
        }
        bus.shutdown(true);
    }

    @Test
    public void testPasswordHashedReplay() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = UsernameTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = UsernameTokenTest.class.getResource("DoubleItUt.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItHashedPort");
        DoubleItPortType utPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(utPort, PORT);
        Client cxfClient = ClientProxy.getClient((Object)utPort);
        SecurityHeaderCacheInterceptor cacheInterceptor = new SecurityHeaderCacheInterceptor();
        cxfClient.getOutInterceptors().add(cacheInterceptor);
        utPort.doubleIt(25);
        try {
            utPort.doubleIt(25);
            UsernameTokenTest.fail((String)"Failure expected on a replayed UsernameToken");
        }
        catch (SOAPFaultException ex) {
            String error = "A replay attack has been detected";
            UsernameTokenTest.assertTrue((boolean)ex.getMessage().contains(error));
        }
        bus.shutdown(true);
    }
}

