/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.wssc;

import java.io.Closeable;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.wssc.server.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.xmlsoap.ping.Ping;
import wssec.wssc.IPingService;
import wssec.wssc.PingRequest;
import wssec.wssc.PingResponse;
import wssec.wssc.PingService;

public class WSSCTest
extends AbstractBusClientServerTestBase {
    static final String PORT = WSSCTest.allocatePort(Server.class);
    private static final String OUT = "CXF : ping";
    private static PingService svc;
    private static Bus bus;

    @BeforeClass
    public static void startServers() throws Exception {
        WSSCTest.assertTrue((String)"Server failed to launch", (boolean)WSSCTest.launchServer(Server.class, (boolean)true));
        bus = new SpringBusFactory().createBus("org/apache/cxf/systest/ws/wssc/client/client.xml");
        BusFactory.setDefaultBus((Bus)bus);
        BusFactory.setThreadDefaultBus((Bus)bus);
        svc = new PingService();
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        bus.shutdown(true);
        WSSCTest.stopAllServers();
    }

    @Test
    public void testSecureConversationMutualCertificate10SignEncryptIPingService() throws Exception {
        this.runTest("SecureConversation_MutualCertificate10SignEncrypt_IPingService");
    }

    @Test
    public void testACIPingService() throws Exception {
        this.runTest("AC_IPingService");
    }

    @Test
    public void testADCIPingService() throws Exception {
        this.runTest("ADC_IPingService");
    }

    @Test
    public void testADCESIPingService() throws Exception {
        this.runTest("ADC-ES_IPingService");
    }

    @Test
    public void testAIPingService() throws Exception {
        this.runTest("_A_IPingService");
    }

    @Test
    public void testADIPingService() throws Exception {
        this.runTest("_AD_IPingService");
    }

    @Test
    public void testADESIPingService() throws Exception {
        this.runTest("_AD-ES_IPingService");
    }

    @Test
    public void testUXCIPingService() throws Exception {
        this.runTest("UXC_IPingService");
    }

    @Test
    public void testUXDCIPingService() throws Exception {
        this.runTest("UXDC_IPingService");
    }

    @Test
    public void testUXDCSEESIPingService() throws Exception {
        this.runTest("UXDC-SEES_IPingService");
    }

    @Test
    public void testUXIPingService() throws Exception {
        this.runTest("_UX_IPingService");
    }

    @Test
    public void testUXDIPingService() throws Exception {
        this.runTest("_UXD_IPingService");
    }

    @Test
    public void testUXDSEESIPingService() throws Exception {
        this.runTest("_UXD-SEES_IPingService");
    }

    @Test
    public void testXCIPingService() throws Exception {
        this.runTest("XC_IPingService");
    }

    @Test
    public void testXDCIPingService() throws Exception {
        this.runTest("XDC_IPingService");
    }

    @Test
    public void testXDCIPingService1() throws Exception {
        this.runTest("XDC_IPingService1");
    }

    @Test
    public void testXDCESIPingService() throws Exception {
        this.runTest("XDC-ES_IPingService");
    }

    @Test
    public void testXDCSEESIPingService() throws Exception {
        this.runTest("XDC-SEES_IPingService");
    }

    @Test
    public void testXIPingService() throws Exception {
        this.runTest("_X_IPingService");
    }

    @Test
    public void testX10IPingService() throws Exception {
        this.runTest("_X10_IPingService");
    }

    @Test
    public void testXDIPingService() throws Exception {
        this.runTest("_XD_IPingService");
    }

    @Test
    public void testXDSEESIPingService() throws Exception {
        this.runTest("_XD-SEES_IPingService");
    }

    @Test
    public void testXDESIPingService() throws Exception {
        this.runTest("_XD-ES_IPingService");
    }

    private void runTest(String ... argv) throws Exception {
        for (String portPrefix : argv) {
            IPingService port = (IPingService)svc.getPort(new QName("http://WSSec/wssc", portPrefix), IPingService.class);
            ((BindingProvider)port).getRequestContext().put("javax.xml.ws.service.endpoint.address", "http://localhost:" + PORT + "/" + portPrefix);
            if (portPrefix.charAt(0) == '_') {
                ((BindingProvider)port).getRequestContext().put("ws-security.sts.token.do.cancel", Boolean.TRUE);
            }
            PingRequest params = new PingRequest();
            Ping ping = new Ping();
            ping.setOrigin("CXF");
            ping.setScenario("Scenario5");
            ping.setText("ping");
            params.setPing(ping);
            try {
                PingResponse output = port.ping(params);
                WSSCTest.assertEquals((Object)OUT, (Object)output.getPingResponse().getText());
            }
            catch (Exception ex) {
                throw new Exception("Error doing " + portPrefix, ex);
            }
            ((Closeable)port).close();
        }
    }
}

