/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.wssec10;

import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.wssec10.server.AuthorizedServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import wssec.wssec10.IPingService;
import wssec.wssec10.PingService;

public class WSSecurity10UsernameAuthorizationTest
extends AbstractBusClientServerTestBase {
    static final String SSL_PORT = WSSecurity10UsernameAuthorizationTest.allocatePort(AuthorizedServer.class, (int)1);
    static final String PORT = WSSecurity10UsernameAuthorizationTest.allocatePort(AuthorizedServer.class);
    private static final String INPUT = "foo";

    @BeforeClass
    public static void startServers() throws Exception {
        WSSecurity10UsernameAuthorizationTest.assertTrue((String)"Server failed to launch", (boolean)WSSecurity10UsernameAuthorizationTest.launchServer(AuthorizedServer.class, (boolean)true));
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        WSSecurity10UsernameAuthorizationTest.stopAllServers();
    }

    @Test
    public void testClientServerUTOnlyAuthorized() {
        String configName = "org/apache/cxf/systest/ws/wssec10/client/client_restricted.xml";
        Bus bus = new SpringBusFactory().createBus(configName);
        IPingService port = WSSecurity10UsernameAuthorizationTest.getUTOnlyPort(bus, false);
        String output = port.echo(INPUT);
        WSSecurity10UsernameAuthorizationTest.assertEquals((Object)INPUT, (Object)output);
        bus.shutdown(true);
    }

    @Test
    public void testClientServerUTOnlyUnauthorized() {
        String configName = "org/apache/cxf/systest/ws/wssec10/client/client_restricted_unauthorized.xml";
        Bus bus = new SpringBusFactory().createBus(configName);
        IPingService port = WSSecurity10UsernameAuthorizationTest.getUTOnlyPort(bus, true);
        try {
            port.echo(INPUT);
            WSSecurity10UsernameAuthorizationTest.fail((String)"Frank is unauthorized");
        }
        catch (Exception ex) {
            WSSecurity10UsernameAuthorizationTest.assertEquals((Object)"Unauthorized", (Object)ex.getMessage());
        }
        bus.shutdown(true);
    }

    @Test
    public void testClientServerComplexPolicyAuthorized() {
        String configName = "org/apache/cxf/systest/ws/wssec10/client/client_restricted.xml";
        Bus bus = new SpringBusFactory().createBus(configName);
        IPingService port = WSSecurity10UsernameAuthorizationTest.getComplexPolicyPort(bus);
        String output = port.echo(INPUT);
        WSSecurity10UsernameAuthorizationTest.assertEquals((Object)INPUT, (Object)output);
        bus.shutdown(true);
    }

    @Test
    public void testClientServerComplexPolicyUnauthorized() {
        String configName = "org/apache/cxf/systest/ws/wssec10/client/client_restricted_unauthorized.xml";
        Bus bus = new SpringBusFactory().createBus(configName);
        IPingService port = WSSecurity10UsernameAuthorizationTest.getComplexPolicyPort(bus);
        try {
            port.echo(INPUT);
            WSSecurity10UsernameAuthorizationTest.fail((String)"Frank is unauthorized");
        }
        catch (Exception ex) {
            WSSecurity10UsernameAuthorizationTest.assertEquals((Object)"Unauthorized", (Object)ex.getMessage());
        }
        bus.shutdown(true);
    }

    private static IPingService getComplexPolicyPort(Bus bus) {
        BusFactory.setDefaultBus((Bus)bus);
        BusFactory.setThreadDefaultBus((Bus)bus);
        PingService svc = new PingService(WSSecurity10UsernameAuthorizationTest.getWsdlLocation("UserNameOverTransport"));
        IPingService port = (IPingService)svc.getPort(new QName("http://WSSec/wssec10", "UserNameOverTransport_IPingService"), IPingService.class);
        return port;
    }

    private static IPingService getUTOnlyPort(Bus bus, boolean hashed) {
        BusFactory.setDefaultBus((Bus)bus);
        BusFactory.setThreadDefaultBus((Bus)bus);
        PingService svc = new PingService(WSSecurity10UsernameAuthorizationTest.getWsdlLocation(hashed));
        IPingService port = (IPingService)svc.getPort(new QName("http://WSSec/wssec10", hashed ? "UserName_IPingService_hashed" : "UserName_IPingService"), IPingService.class);
        return port;
    }

    private static URL getWsdlLocation(boolean hashed) {
        try {
            return new URL("http://localhost:" + PORT + "/" + (hashed ? "HashedUserName" : "UserName") + "?wsdl");
        }
        catch (MalformedURLException mue) {
            return null;
        }
    }

    private static URL getWsdlLocation(String portPrefix) {
        try {
            if ("UserNameOverTransport".equals(portPrefix)) {
                return new URL("https://localhost:" + SSL_PORT + "/" + portPrefix + "?wsdl");
            }
            if ("MutualCertificate10SignEncrypt".equals(portPrefix)) {
                return new URL("http://localhost:" + PORT + "/" + portPrefix + "?wsdl");
            }
            if ("MutualCertificate10SignEncryptRsa15TripleDes".equals(portPrefix)) {
                return new URL("http://localhost:" + PORT + "/" + portPrefix + "?wsdl");
            }
        }
        catch (MalformedURLException mue) {
            return null;
        }
        return null;
    }
}

