/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.wssec11;

import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.wssec11.WSSecurity11Common;
import org.apache.cxf.systest.ws.wssec11.server.Server12;
import org.apache.cxf.systest.ws.wssec11.server.Server12Restricted;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class WSSecurity112Test
extends WSSecurity11Common {
    private static boolean unrestrictedPoliciesInstalled = WSSecurity112Test.checkUnrestrictedPoliciesInstalled();

    @BeforeClass
    public static void startServers() throws Exception {
        if (unrestrictedPoliciesInstalled) {
            WSSecurity112Test.assertTrue((String)"Server failed to launch", (boolean)WSSecurity112Test.launchServer(Server12.class, (boolean)true));
        } else {
            if (WSSecurity11Common.isIBMJDK16()) {
                System.out.println("Not running as there is a problem with 1.6 jdk and restricted jars");
                return;
            }
            WSSecurity112Test.assertTrue((String)"Server failed to launch", (boolean)WSSecurity112Test.launchServer(Server12Restricted.class, (boolean)true));
        }
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        WSSecurity112Test.stopAllServers();
    }

    @Test
    public void testClientServer() {
        if (!unrestrictedPoliciesInstalled && WSSecurity11Common.isIBMJDK16()) {
            System.out.println("Not running as there is a problem with 1.6 jdk and restricted jars");
            return;
        }
        String[] argv = null;
        argv = unrestrictedPoliciesInstalled ? new String[]{"X", "X-NoTimestamp", "X-AES128", "X-AES256", "X-TripleDES", "XD", "XD-ES", "XD-SEES"} : new String[]{"X", "X-NoTimestamp", "XD", "XD-ES", "XD-SEES"};
        this.runClientServer(argv, unrestrictedPoliciesInstalled, true);
    }
}

