/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.wssec11;

import java.net.MalformedURLException;
import java.net.URL;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.systest.ws.wssec11.server.Server11;
import org.apache.cxf.systest.ws.wssec11.server.Server12;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import wssec.wssec11.IPingService;
import wssec.wssec11.PingService11;

public class WSSecurity11Common
extends AbstractBusClientServerTestBase {
    private static final String INPUT = "foo";

    public void runClientServer(String[] argv, boolean unrestrictedPoliciesInstalled, boolean wssecurity12) {
        Bus bus = null;
        bus = unrestrictedPoliciesInstalled ? new SpringBusFactory().createBus("org/apache/cxf/systest/ws/wssec11/client/client.xml") : new SpringBusFactory().createBus("org/apache/cxf/systest/ws/wssec11/client/client_restricted.xml");
        BusFactory.setDefaultBus((Bus)bus);
        BusFactory.setThreadDefaultBus((Bus)bus);
        String portNumber = null;
        portNumber = wssecurity12 ? Server12.PORT : Server11.PORT;
        URL wsdlLocation = null;
        for (String portPrefix : argv) {
            PingService11 svc = null;
            wsdlLocation = WSSecurity11Common.getWsdlLocation(portPrefix, portNumber);
            svc = new PingService11(wsdlLocation);
            IPingService port = (IPingService)svc.getPort(new QName("http://WSSec/wssec11", portPrefix + "_IPingService"), IPingService.class);
            String output = port.echo(INPUT);
            WSSecurity11Common.assertEquals((Object)INPUT, (Object)output);
        }
        bus.shutdown(true);
    }

    private static URL getWsdlLocation(String portPrefix, String portNumber) {
        try {
            return new URL("http://localhost:" + portNumber + "/" + portPrefix + "PingService?wsdl");
        }
        catch (MalformedURLException mue) {
            return null;
        }
    }

    public static boolean checkUnrestrictedPoliciesInstalled() {
        boolean unrestrictedPoliciesInstalled = false;
        try {
            byte[] data = new byte[]{0, 1, 2, 3, 4, 5, 6, 7};
            SecretKeySpec key192 = new SecretKeySpec(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23}, "AES");
            Cipher c = Cipher.getInstance("AES");
            c.init(1, key192);
            c.doFinal(data);
            unrestrictedPoliciesInstalled = true;
        }
        catch (Exception e) {
            return unrestrictedPoliciesInstalled;
        }
        return unrestrictedPoliciesInstalled;
    }

    public static boolean isIBMJDK16() {
        String fullVersion = System.getProperty("java.fullversion");
        if (fullVersion == null) {
            return false;
        }
        if (fullVersion.indexOf("IBM") == -1) {
            return false;
        }
        String javaVersion = System.getProperty("java.version");
        double javaVersionNum = 0.0;
        javaVersionNum = javaVersion.length() > 3 ? new Double(javaVersion.substring(0, 3)).doubleValue() : new Double(javaVersion).doubleValue();
        return !(javaVersionNum < 1.6);
    }
}

