/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.kerberos;

import java.io.Closeable;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.kerberos.server.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.example.contract.doubleit.DoubleItPortType;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class KerberosTokenTest
extends AbstractBusClientServerTestBase {
    static final String PORT = KerberosTokenTest.allocatePort(Server.class);
    static final String PORT2 = KerberosTokenTest.allocatePort(Server.class, (int)2);
    private static final String NAMESPACE = "http://www.example.org/contract/DoubleIt";
    private static final QName SERVICE_QNAME = new QName("http://www.example.org/contract/DoubleIt", "DoubleItService");
    private static boolean unrestrictedPoliciesInstalled = SecurityTestUtil.checkUnrestrictedPoliciesInstalled();

    @BeforeClass
    public static void startServers() throws Exception {
        KerberosTokenTest.assertTrue((String)"Server failed to launch", (boolean)KerberosTokenTest.launchServer(Server.class, (boolean)true));
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        KerberosTokenTest.stopAllServers();
    }

    @Test
    public void testKerberosOverTransport() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = KerberosTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = KerberosTokenTest.class.getResource("DoubleItKerberos.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItKerberosTransportPort");
        DoubleItPortType kerberosPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(kerberosPort, PORT2);
        int result = kerberosPort.doubleIt(25);
        KerberosTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        ((Closeable)kerberosPort).close();
        bus.shutdown(true);
    }

    @Test
    public void testKerberosOverSymmetric() throws Exception {
        if (!unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = KerberosTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = KerberosTokenTest.class.getResource("DoubleItKerberos.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItKerberosSymmetricPort");
        DoubleItPortType kerberosPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(kerberosPort, PORT);
        int result = kerberosPort.doubleIt(25);
        KerberosTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        ((Closeable)kerberosPort).close();
        bus.shutdown(true);
    }

    @Test
    public void testKerberosOverSymmetricSupporting() throws Exception {
        if (!unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = KerberosTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = KerberosTokenTest.class.getResource("DoubleItKerberos.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItKerberosSymmetricSupportingPort");
        DoubleItPortType kerberosPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(kerberosPort, PORT);
        int result = kerberosPort.doubleIt(25);
        KerberosTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        ((Closeable)kerberosPort).close();
        bus.shutdown(true);
    }

    @Test
    public void testKerberosOverAsymmetric() throws Exception {
        if (!unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = KerberosTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = KerberosTokenTest.class.getResource("DoubleItKerberos.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItKerberosAsymmetricPort");
        DoubleItPortType kerberosPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(kerberosPort, PORT);
        int result = kerberosPort.doubleIt(25);
        KerberosTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        ((Closeable)kerberosPort).close();
        bus.shutdown(true);
    }

    @Test
    public void testKerberosOverTransportEndorsing() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = KerberosTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = KerberosTokenTest.class.getResource("DoubleItKerberos.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItKerberosTransportEndorsingPort");
        DoubleItPortType kerberosPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(kerberosPort, PORT2);
        int result = kerberosPort.doubleIt(25);
        KerberosTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        ((Closeable)kerberosPort).close();
        bus.shutdown(true);
    }

    @Test
    public void testKerberosOverAsymmetricEndorsing() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = KerberosTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = KerberosTokenTest.class.getResource("DoubleItKerberos.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItKerberosAsymmetricEndorsingPort");
        DoubleItPortType kerberosPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(kerberosPort, PORT);
        int result = kerberosPort.doubleIt(25);
        KerberosTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        ((Closeable)kerberosPort).close();
        bus.shutdown(true);
    }

    @Test
    public void testKerberosOverSymmetricProtection() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = KerberosTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = KerberosTokenTest.class.getResource("DoubleItKerberos.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItKerberosSymmetricProtectionPort");
        DoubleItPortType kerberosPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(kerberosPort, PORT);
        int result = kerberosPort.doubleIt(25);
        KerberosTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        ((Closeable)kerberosPort).close();
        bus.shutdown(true);
    }

    @Test
    public void testKerberosOverSymmetricDerivedProtection() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = KerberosTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = KerberosTokenTest.class.getResource("DoubleItKerberos.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItKerberosSymmetricDerivedProtectionPort");
        DoubleItPortType kerberosPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(kerberosPort, PORT);
        int result = kerberosPort.doubleIt(25);
        KerberosTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        ((Closeable)kerberosPort).close();
        bus.shutdown(true);
    }

    @Test
    public void testKerberosOverAsymmetricSignedEndorsing() throws Exception {
        if (!unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = KerberosTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = KerberosTokenTest.class.getResource("DoubleItKerberos.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItKerberosAsymmetricSignedEndorsingPort");
        DoubleItPortType kerberosPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(kerberosPort, PORT);
        int result = kerberosPort.doubleIt(25);
        KerberosTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        ((Closeable)kerberosPort).close();
        bus.shutdown(true);
    }

    @Test
    public void testKerberosOverAsymmetricSignedEncrypted() throws Exception {
        if (!unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = KerberosTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = KerberosTokenTest.class.getResource("DoubleItKerberos.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItKerberosAsymmetricSignedEncryptedPort");
        DoubleItPortType kerberosPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(kerberosPort, PORT);
        int result = kerberosPort.doubleIt(25);
        KerberosTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        ((Closeable)kerberosPort).close();
        bus.shutdown(true);
    }

    @Test
    public void testKerberosOverSymmetricEndorsingEncrypted() throws Exception {
        if (!unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = KerberosTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = KerberosTokenTest.class.getResource("DoubleItKerberos.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItKerberosSymmetricEndorsingEncryptedPort");
        DoubleItPortType kerberosPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(kerberosPort, PORT);
        int result = kerberosPort.doubleIt(25);
        KerberosTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        ((Closeable)kerberosPort).close();
        bus.shutdown(true);
    }

    @Test
    public void testKerberosOverSymmetricSignedEndorsingEncrypted() throws Exception {
        if (!unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = KerberosTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = KerberosTokenTest.class.getResource("DoubleItKerberos.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItKerberosSymmetricSignedEndorsingEncryptedPort");
        DoubleItPortType kerberosPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(kerberosPort, PORT);
        int result = kerberosPort.doubleIt(25);
        KerberosTokenTest.assertTrue((result == 50 ? 1 : 0) != 0);
        ((Closeable)kerberosPort).close();
        bus.shutdown(true);
    }
}

