/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.policy;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.policy.JavaFirstAttachmentPolicyService;
import org.apache.cxf.systest.ws.policy.SslUsernamePasswordAttachmentService;
import org.apache.cxf.systest.ws.policy.server.JavaFirstPolicyServer;
import org.apache.cxf.systest.ws.wssec11.client.UTPasswordCallback;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaFirstPolicyServiceTest
extends AbstractBusClientServerTestBase {
    static final String PORT = JavaFirstPolicyServiceTest.allocatePort(JavaFirstPolicyServer.class);
    static final String PORT2 = JavaFirstPolicyServiceTest.allocatePort(JavaFirstPolicyServer.class, (int)2);
    private static final String WSDL_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/";

    @BeforeClass
    public static void startServers() throws Exception {
        JavaFirstPolicyServiceTest.assertTrue((String)"Server failed to launch", (boolean)JavaFirstPolicyServiceTest.launchServer(JavaFirstPolicyServer.class, (boolean)true));
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        JavaFirstPolicyServiceTest.stopAllServers();
    }

    @Test
    public void testUsernameTokenInterceptorNoPasswordValidation() {
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext("org/apache/cxf/systest/ws/policy/client/javafirstclient.xml");
        JavaFirstAttachmentPolicyService svc = (JavaFirstAttachmentPolicyService)ctx.getBean("JavaFirstAttachmentPolicyServiceClient");
        Client client = ClientProxy.getClient((Object)svc);
        client.getEndpoint().getEndpointInfo().setAddress("http://localhost:" + PORT + "/JavaFirstAttachmentPolicyService");
        WSS4JOutInterceptor wssOut = new WSS4JOutInterceptor();
        client.getEndpoint().getOutInterceptors().add(wssOut);
        wssOut.setProperties(this.getPasswordProperties("alice", "password"));
        svc.doInputMessagePolicy();
        wssOut.setProperties(this.getPasswordProperties("alice", "passwordX"));
        try {
            svc.doInputMessagePolicy();
            JavaFirstPolicyServiceTest.fail((String)"Expected authentication failure");
        }
        catch (Exception e) {
            JavaFirstPolicyServiceTest.assertTrue((boolean)true);
        }
        wssOut.setProperties(this.getNoPasswordProperties("alice"));
        try {
            svc.doInputMessagePolicy();
            JavaFirstPolicyServiceTest.fail((String)"Expected authentication failure");
        }
        catch (Exception e) {
            JavaFirstPolicyServiceTest.assertTrue((boolean)true);
        }
    }

    @Test
    public void testUsernameTokenPolicyValidatorNoPasswordValidation() {
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext("org/apache/cxf/systest/ws/policy/client/javafirstclient.xml");
        SslUsernamePasswordAttachmentService svc = (SslUsernamePasswordAttachmentService)ctx.getBean("SslUsernamePasswordAttachmentServiceClient");
        Client client = ClientProxy.getClient((Object)svc);
        client.getEndpoint().getEndpointInfo().setAddress("https://localhost:" + PORT2 + "/SslUsernamePasswordAttachmentService");
        WSS4JOutInterceptor wssOut = new WSS4JOutInterceptor();
        client.getEndpoint().getOutInterceptors().add(wssOut);
        wssOut.setProperties(this.getPasswordProperties("alice", "password"));
        svc.doSslAndUsernamePasswordPolicy();
        wssOut.setProperties(this.getPasswordProperties("alice", "passwordX"));
        try {
            svc.doSslAndUsernamePasswordPolicy();
            JavaFirstPolicyServiceTest.fail((String)"Expected authentication failure");
        }
        catch (Exception e) {
            JavaFirstPolicyServiceTest.assertTrue((boolean)true);
        }
        wssOut.setProperties(this.getNoPasswordProperties("alice"));
        try {
            svc.doSslAndUsernamePasswordPolicy();
            JavaFirstPolicyServiceTest.fail((String)"Expected authentication failure");
        }
        catch (Exception e) {
            JavaFirstPolicyServiceTest.assertTrue((boolean)true);
        }
    }

    private Map<String, Object> getPasswordProperties(String username, String password) {
        UTPasswordCallback callback = new UTPasswordCallback();
        callback.setAliasPassword(username, password);
        HashMap<String, Object> outProps = new HashMap<String, Object>();
        outProps.put("action", "UsernameToken");
        outProps.put("passwordType", "PasswordText");
        outProps.put("passwordCallbackRef", callback);
        outProps.put("user", username);
        return outProps;
    }

    private Map<String, Object> getNoPasswordProperties(String username) {
        HashMap<String, Object> outProps = new HashMap<String, Object>();
        outProps.put("action", "UsernameToken");
        outProps.put("passwordType", "PasswordNone");
        outProps.put("user", username);
        return outProps;
    }

    @Test
    public void testJavaFirstWsdl() throws Exception {
        Document doc = this.loadWsdl("JavaFirstPolicyService");
        Element portType = DOMUtils.getFirstChildWithName((Element)doc.getDocumentElement(), (String)WSDL_NAMESPACE, (String)"portType");
        JavaFirstPolicyServiceTest.assertNotNull((Object)portType);
        List operationMessages = DOMUtils.getChildrenWithName((Element)portType, (String)WSDL_NAMESPACE, (String)"operation");
        JavaFirstPolicyServiceTest.assertEquals((long)5L, (long)operationMessages.size());
        Element operationOne = this.getOperationElement("doOperationOne", operationMessages);
        JavaFirstPolicyServiceTest.assertEquals((Object)"#InternalTransportAndUsernamePolicy", (Object)this.getMessagePolicyReferenceId(operationOne, MessageInfo.Type.INPUT, "http://www.w3.org/ns/ws-policy"));
        Element operationTwo = this.getOperationElement("doOperationTwo", operationMessages);
        JavaFirstPolicyServiceTest.assertEquals((Object)"#TransportAndUsernamePolicy", (Object)this.getMessagePolicyReferenceId(operationTwo, MessageInfo.Type.INPUT, "http://www.w3.org/ns/ws-policy"));
        Element operationThree = this.getOperationElement("doOperationThree", operationMessages);
        JavaFirstPolicyServiceTest.assertEquals((Object)"#InternalTransportAndUsernamePolicy", (Object)this.getMessagePolicyReferenceId(operationThree, MessageInfo.Type.INPUT, "http://www.w3.org/ns/ws-policy"));
        Element operationFour = this.getOperationElement("doOperationFour", operationMessages);
        JavaFirstPolicyServiceTest.assertEquals((Object)"#TransportAndUsernamePolicy", (Object)this.getMessagePolicyReferenceId(operationFour, MessageInfo.Type.INPUT, "http://www.w3.org/ns/ws-policy"));
        Element operationPing = this.getOperationElement("doPing", operationMessages);
        JavaFirstPolicyServiceTest.assertNull((Object)this.getMessagePolicyReferenceId(operationPing, MessageInfo.Type.INPUT, "http://www.w3.org/ns/ws-policy"));
        List policyMessages = DOMUtils.getChildrenWithName((Element)doc.getDocumentElement(), (String)"http://www.w3.org/ns/ws-policy", (String)"Policy");
        JavaFirstPolicyServiceTest.assertEquals((long)2L, (long)policyMessages.size());
        JavaFirstPolicyServiceTest.assertEquals((Object)"TransportAndUsernamePolicy", (Object)this.getPolicyId((Element)policyMessages.get(0)));
        JavaFirstPolicyServiceTest.assertEquals((Object)"InternalTransportAndUsernamePolicy", (Object)this.getPolicyId((Element)policyMessages.get(1)));
    }

    private Document loadWsdl(String serviceName) throws Exception {
        HttpURLConnection connection = this.getHttpConnection("http://localhost:" + PORT + "/" + serviceName + "?wsdl");
        InputStream is = connection.getInputStream();
        String wsdlContents = IOUtils.toString((InputStream)is);
        return DOMUtils.readXml((Reader)new StringReader(wsdlContents));
    }

    private String getPolicyId(Element element) {
        return element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
    }

    private Element getOperationElement(String operationName, List<Element> operationMessages) {
        Element operationElement = null;
        for (Element operation : operationMessages) {
            if (!operationName.equals(operation.getAttribute("name"))) continue;
            operationElement = operation;
            break;
        }
        JavaFirstPolicyServiceTest.assertNotNull(operationElement);
        return operationElement;
    }

    private String getMessagePolicyReferenceId(Element operationElement, MessageInfo.Type type, String policyNamespace) {
        Element messageElement = DOMUtils.getFirstChildWithName((Element)operationElement, (String)WSDL_NAMESPACE, (String)type.name().toLowerCase());
        JavaFirstPolicyServiceTest.assertNotNull((Object)messageElement);
        Element policyReference = DOMUtils.getFirstChildWithName((Element)messageElement, (String)policyNamespace, (String)"PolicyReference");
        if (policyReference != null) {
            return policyReference.getAttribute("URI");
        }
        return null;
    }
}

