/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.policy;

import java.io.Closeable;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.policy.server.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.example.contract.doubleit.DoubleItPortType;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class PolicyAlternativeTest
extends AbstractBusClientServerTestBase {
    static final String PORT = PolicyAlternativeTest.allocatePort(Server.class);
    static final String PORT2 = PolicyAlternativeTest.allocatePort(Server.class, (int)2);
    private static final String NAMESPACE = "http://www.example.org/contract/DoubleIt";
    private static final QName SERVICE_QNAME = new QName("http://www.example.org/contract/DoubleIt", "DoubleItService");

    @BeforeClass
    public static void startServers() throws Exception {
        PolicyAlternativeTest.assertTrue((String)"Server failed to launch", (boolean)PolicyAlternativeTest.launchServer(Server.class, (boolean)true));
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        PolicyAlternativeTest.stopAllServers();
    }

    @Test
    public void testAsymmetric() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = PolicyAlternativeTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = PolicyAlternativeTest.class.getResource("DoubleItPolicy.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItAsymmetricPort");
        DoubleItPortType utPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(utPort, PORT);
        utPort.doubleIt(25);
        ((Closeable)utPort).close();
        bus.shutdown(true);
    }

    @Test
    public void testNoSecurity() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = PolicyAlternativeTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = PolicyAlternativeTest.class.getResource("DoubleItPolicy.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItNoSecurityPort");
        DoubleItPortType utPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(utPort, PORT);
        try {
            utPort.doubleIt(25);
            PolicyAlternativeTest.fail((String)"Failure expected on no Security");
        }
        catch (SOAPFaultException ex) {
            // empty catch block
        }
        ((Closeable)utPort).close();
        bus.shutdown(true);
    }

    @Test
    public void testUsernameToken() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = PolicyAlternativeTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = PolicyAlternativeTest.class.getResource("DoubleItPolicy.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItUsernameTokenPort");
        DoubleItPortType utPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(utPort, PORT);
        utPort.doubleIt(25);
        ((Closeable)utPort).close();
        bus.shutdown(true);
    }

    @Test
    public void testTransportSupportingSigned() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = PolicyAlternativeTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = PolicyAlternativeTest.class.getResource("DoubleItPolicy.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItTransportSupportingSignedPort");
        DoubleItPortType transportPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(transportPort, PORT2);
        try {
            transportPort.doubleIt(25);
            PolicyAlternativeTest.fail((String)"Failure expected on not signing a wsa header");
        }
        catch (SOAPFaultException ex) {
            // empty catch block
        }
        ((Closeable)transportPort).close();
        bus.shutdown(true);
    }

    @Test
    public void testTransportUTSupportingSigned() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = PolicyAlternativeTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = PolicyAlternativeTest.class.getResource("DoubleItPolicy.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItTransportUTSupportingSignedPort");
        DoubleItPortType transportPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(transportPort, PORT2);
        try {
            transportPort.doubleIt(25);
            PolicyAlternativeTest.fail((String)"Failure expected on not signing a wsa header");
        }
        catch (SOAPFaultException ex) {
            // empty catch block
        }
        ((Closeable)transportPort).close();
        bus.shutdown(true);
    }
}

