/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.ssl;

import java.io.IOException;
import java.net.URL;
import java.security.SecureRandom;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.jsse.SSLUtils;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.ssl.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.junit.BeforeClass;
import org.junit.Test;

public class SSLTest
extends AbstractBusClientServerTestBase {
    static final String PORT = SSLTest.allocatePort(Server.class);
    static final String PORT2 = SSLTest.allocatePort(Server.class, (int)2);

    @BeforeClass
    public static void startServers() throws Exception {
        SSLTest.assertTrue((String)"Server failed to launch", (boolean)SSLTest.launchServer(Server.class, (boolean)true));
    }

    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        SSLTest.stopAllServers();
    }

    @Test
    public void testSSLv3NotAllowed() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SSLTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        System.setProperty("https.protocols", "SSLv3");
        URL service = new URL("https://localhost:" + PORT);
        HttpsURLConnection connection = (HttpsURLConnection)service.openConnection();
        connection.setHostnameVerifier(new DisableCNCheckVerifier());
        SSLContext sslContext = SSLContext.getInstance("SSL");
        URL keystore = SSLTest.class.getResource("../security/Truststore.jks");
        TrustManager[] trustManagers = SSLUtils.getTrustStoreManagers((boolean)false, (String)"jks", (String)keystore.getPath(), (String)"PKIX", (Logger)LogUtils.getL7dLogger(SSLTest.class));
        sslContext.init(null, trustManagers, new SecureRandom());
        connection.setSSLSocketFactory(sslContext.getSocketFactory());
        try {
            connection.connect();
            SSLTest.fail((String)"Failure expected on an SSLv3 connection attempt");
        }
        catch (IOException ex) {
            // empty catch block
        }
        System.clearProperty("https.protocols");
        bus.shutdown(true);
    }

    @Test
    public void testSSLv3Allowed() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SSLTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        System.setProperty("https.protocols", "SSLv3");
        URL service = new URL("https://localhost:" + PORT2);
        HttpsURLConnection connection = (HttpsURLConnection)service.openConnection();
        connection.setHostnameVerifier(new DisableCNCheckVerifier());
        SSLContext sslContext = SSLContext.getInstance("SSL");
        URL keystore = SSLTest.class.getResource("../security/Truststore.jks");
        TrustManager[] trustManagers = SSLUtils.getTrustStoreManagers((boolean)false, (String)"jks", (String)keystore.getPath(), (String)"PKIX", (Logger)LogUtils.getL7dLogger(SSLTest.class));
        sslContext.init(null, trustManagers, new SecureRandom());
        connection.setSSLSocketFactory(sslContext.getSocketFactory());
        connection.connect();
        connection.disconnect();
        System.clearProperty("https.protocols");
        bus.shutdown(true);
    }

    private static final class DisableCNCheckVerifier
    implements HostnameVerifier {
        private DisableCNCheckVerifier() {
        }

        public boolean verify(String arg0, SSLSession arg1) {
            return true;
        }
    }
}

