/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.wssec11;

import java.io.IOException;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.wssec11.WSSecurity11Common;
import org.apache.cxf.systest.ws.wssec11.server.Server11;
import org.apache.cxf.systest.ws.wssec11.server.Server11Restricted;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class WSSecurity111Test
extends WSSecurity11Common {
    private static boolean unrestrictedPoliciesInstalled = SecurityTestUtil.checkUnrestrictedPoliciesInstalled();

    @BeforeClass
    public static void startServers() throws Exception {
        if (unrestrictedPoliciesInstalled) {
            WSSecurity111Test.assertTrue((String)"Server failed to launch", (boolean)WSSecurity111Test.launchServer(Server11.class, (boolean)true));
        } else {
            if (WSSecurity11Common.isIBMJDK16()) {
                System.out.println("Not running as there is a problem with 1.6 jdk and restricted jars");
                return;
            }
            WSSecurity111Test.assertTrue((String)"Server failed to launch", (boolean)WSSecurity111Test.launchServer(Server11Restricted.class, (boolean)true));
        }
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        WSSecurity111Test.stopAllServers();
    }

    @Test
    public void testClientServer() throws IOException {
        if (!unrestrictedPoliciesInstalled && WSSecurity11Common.isIBMJDK16()) {
            System.out.println("Not running as there is a problem with 1.6 jdk and restricted jars");
            return;
        }
        String[] argv = new String[]{"A", "A-NoTimestamp", "AD", "A-ES", "AD-ES", "UX", "UX-NoTimestamp", "UXD", "UX-SEES", "UXD-SEES"};
        this.runClientServer(argv, unrestrictedPoliciesInstalled, false);
    }
}

