/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.action;

import java.io.Closeable;
import java.io.File;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.systest.ws.action.SignatureServer;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.example.contract.doubleit.DoubleItPortType;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class SignatureWhitespaceTest
extends AbstractBusClientServerTestBase {
    public static final String PORT = SignatureWhitespaceTest.allocatePort(SignatureServer.class);
    private static final String NAMESPACE = "http://www.example.org/contract/DoubleIt";
    private static final QName SERVICE_QNAME = new QName("http://www.example.org/contract/DoubleIt", "DoubleItService");

    @BeforeClass
    public static void startServers() throws Exception {
        SignatureWhitespaceTest.assertTrue((String)"Server failed to launch", (boolean)SignatureWhitespaceTest.launchServer(SignatureServer.class, (boolean)true));
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        SignatureWhitespaceTest.stopAllServers();
    }

    @Test
    public void testNormalSignedSOAPBody() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SignatureWhitespaceTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SignatureWhitespaceTest.class.getResource("DoubleItAction.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSignaturePort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        port.doubleIt(25);
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testTrailingWhitespaceInSOAPBody() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SignatureWhitespaceTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SignatureWhitespaceTest.class.getResource("DoubleItAction.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSignaturePort2");
        Dispatch dispatch = service.createDispatch(portQName, StreamSource.class, Service.Mode.MESSAGE);
        URL requestFile = SignatureWhitespaceTest.class.getResource("request-with-trailing-whitespace.xml");
        StreamSource request = new StreamSource(new File(requestFile.getPath()));
        this.updateAddressPort(dispatch, PORT);
        StreamSource response = (StreamSource)dispatch.invoke((Object)request);
        SignatureWhitespaceTest.assertNotNull((Object)response);
    }
}

