/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.bindings;

import java.io.Closeable;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.systest.ws.bindings.server.Server;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.example.contract.doubleit.DoubleItPortType;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class BindingPropertiesTest
extends AbstractBusClientServerTestBase {
    static final String PORT = BindingPropertiesTest.allocatePort(Server.class);
    private static final String NAMESPACE = "http://www.example.org/contract/DoubleIt";
    private static final QName SERVICE_QNAME = new QName("http://www.example.org/contract/DoubleIt", "DoubleItService");

    @BeforeClass
    public static void startServers() throws Exception {
        BindingPropertiesTest.assertTrue((String)"Server failed to launch", (boolean)BindingPropertiesTest.launchServer(Server.class, (boolean)true));
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        BindingPropertiesTest.stopAllServers();
    }

    @Test
    public void testOnlySignEntireHeadersAndBody() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = BindingPropertiesTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = BindingPropertiesTest.class.getResource("DoubleItBindings.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItNotOnlySignPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        port.doubleIt(25);
        portQName = new QName(NAMESPACE, "DoubleItOnlySignPort");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        try {
            port.doubleIt(25);
            BindingPropertiesTest.fail((String)"Failure expected on OnlySignEntireHeadersAndBody property");
        }
        catch (SOAPFaultException ex) {
            String error = "OnlySignEntireHeadersAndBody does not match the requirements";
            BindingPropertiesTest.assertTrue((boolean)ex.getMessage().contains(error));
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testEncryptSignature() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = BindingPropertiesTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = BindingPropertiesTest.class.getResource("DoubleItBindings.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItEncryptSignaturePort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        port.doubleIt(25);
        portQName = new QName(NAMESPACE, "DoubleItEncryptSignaturePort2");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        try {
            port.doubleIt(25);
            BindingPropertiesTest.fail((String)"Failure expected on not encrypting the signature property");
        }
        catch (SOAPFaultException ex) {
            String error = "The signature is not protected";
            BindingPropertiesTest.assertTrue((boolean)ex.getMessage().contains(error));
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testIncludeTimestamp() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = BindingPropertiesTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = BindingPropertiesTest.class.getResource("DoubleItBindings.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItIncludeTimestampPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        port.doubleIt(25);
        portQName = new QName(NAMESPACE, "DoubleItIncludeTimestampPort2");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        try {
            port.doubleIt(25);
            BindingPropertiesTest.fail((String)"Failure expected on not sending a Timestamp");
        }
        catch (SOAPFaultException ex) {
            String error = "Received Timestamp does not match the requirements";
            BindingPropertiesTest.assertTrue((boolean)ex.getMessage().contains(error));
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testEncryptBeforeSigning() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = BindingPropertiesTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = BindingPropertiesTest.class.getResource("DoubleItBindings.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItEncryptBeforeSigningPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        port.doubleIt(25);
        portQName = new QName(NAMESPACE, "DoubleItEncryptBeforeSigningPort2");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        try {
            port.doubleIt(25);
            BindingPropertiesTest.fail((String)"Failure expected on not encrypting before signing");
        }
        catch (SOAPFaultException ex) {
            String error = "Not encrypted before signed";
            BindingPropertiesTest.assertTrue((boolean)ex.getMessage().contains(error));
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSignBeforeEncrypting() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = BindingPropertiesTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = BindingPropertiesTest.class.getResource("DoubleItBindings.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSignBeforeEncryptingPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        port.doubleIt(25);
        portQName = new QName(NAMESPACE, "DoubleItSignBeforeEncryptingPort2");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        try {
            port.doubleIt(25);
            BindingPropertiesTest.fail((String)"Failure expected on not signing before encrypting");
        }
        catch (SOAPFaultException ex) {
            String error = "Not signed before encrypted";
            BindingPropertiesTest.assertTrue((boolean)ex.getMessage().contains(error));
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    @Ignore
    public void testTimestampFirst() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = BindingPropertiesTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = BindingPropertiesTest.class.getResource("DoubleItBindings.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItTimestampFirstPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        port.doubleIt(25);
        portQName = new QName(NAMESPACE, "DoubleItTimestampFirstPort2");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        try {
            port.doubleIt(25);
            BindingPropertiesTest.fail((String)"Failure expected on on sending the timestamp last");
        }
        catch (SOAPFaultException ex) {
            String error = "Layout does not match the requirements";
            BindingPropertiesTest.assertTrue((boolean)ex.getMessage().contains(error));
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testTimestampLast() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = BindingPropertiesTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = BindingPropertiesTest.class.getResource("DoubleItBindings.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItTimestampLastPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        port.doubleIt(25);
        portQName = new QName(NAMESPACE, "DoubleItTimestampLastPort2");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        try {
            port.doubleIt(25);
            BindingPropertiesTest.fail((String)"Failure expected on sending the timestamp first");
        }
        catch (SOAPFaultException ex) {
            String error = "Layout does not match the requirements";
            BindingPropertiesTest.assertTrue((boolean)ex.getMessage().contains(error));
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testStrict() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = BindingPropertiesTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = BindingPropertiesTest.class.getResource("DoubleItBindings.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItStrictPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        port.doubleIt(25);
        portQName = new QName(NAMESPACE, "DoubleItStrictPort2");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        try {
            port.doubleIt(25);
            BindingPropertiesTest.fail((String)"Failure expected on sending the timestamp last");
        }
        catch (SOAPFaultException ex) {
            String error = "Layout does not match the requirements";
            BindingPropertiesTest.assertTrue((boolean)ex.getMessage().contains(error));
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    @Ignore
    public void testTokenProtection() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = BindingPropertiesTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = BindingPropertiesTest.class.getResource("DoubleItBindings.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItTokenProtectionPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        port.doubleIt(25);
        portQName = new QName(NAMESPACE, "DoubleItTokenProtectionPort2");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        try {
            port.doubleIt(25);
            BindingPropertiesTest.fail((String)"Failure expected on not protecting the token");
        }
        catch (SOAPFaultException ex) {
            System.out.println("EX: " + ex.getMessage());
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSignatureConfirmation() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = BindingPropertiesTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = BindingPropertiesTest.class.getResource("DoubleItBindings.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSignatureConfirmationPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        port.doubleIt(25);
        portQName = new QName(NAMESPACE, "DoubleItSignatureConfirmationPort2");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        try {
            port.doubleIt(25);
            BindingPropertiesTest.fail((String)"Failure expected on not enabling SignatureConfirmation");
        }
        catch (SOAPFaultException ex) {
            // empty catch block
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }
}

