/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.https;

import java.io.Closeable;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.https.server.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.example.contract.doubleit.DoubleItPortType;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class HttpsTokenTest
extends AbstractBusClientServerTestBase {
    static final String PORT = HttpsTokenTest.allocatePort(Server.class);
    private static final String NAMESPACE = "http://www.example.org/contract/DoubleIt";
    private static final QName SERVICE_QNAME = new QName("http://www.example.org/contract/DoubleIt", "DoubleItService");

    @BeforeClass
    public static void startServers() throws Exception {
        HttpsTokenTest.assertTrue((String)"Server failed to launch", (boolean)HttpsTokenTest.launchServer(Server.class, (boolean)true));
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        HttpsTokenTest.stopAllServers();
    }

    @Test
    public void testRequireClientCert() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = HttpsTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = HttpsTokenTest.class.getResource("DoubleItHttps.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItRequireClientCertPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        port.doubleIt(25);
        portQName = new QName(NAMESPACE, "DoubleItRequireClientCertPort2");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        try {
            port.doubleIt(25);
            HttpsTokenTest.fail((String)"Failure expected on not using a client cert");
        }
        catch (SOAPFaultException ex) {
            String error = "HttpsToken";
            HttpsTokenTest.assertTrue((boolean)ex.getMessage().contains(error));
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testBasicAuth() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = HttpsTokenTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = HttpsTokenTest.class.getResource("DoubleItHttps.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItBasicAuthPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        port.doubleIt(25);
        portQName = new QName(NAMESPACE, "DoubleItBasicAuthPort2");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        try {
            port.doubleIt(25);
            HttpsTokenTest.fail((String)"Failure expected on not sending a UsernamePassword");
        }
        catch (SOAPFaultException ex) {
            String error = "HttpsToken";
            HttpsTokenTest.assertTrue((boolean)ex.getMessage().contains(error));
        }
    }
}

