/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.parts;

import java.io.Closeable;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.parts.server.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.example.contract.doubleit.DoubleItPortType;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class PartsTest
extends AbstractBusClientServerTestBase {
    static final String PORT = PartsTest.allocatePort(Server.class);
    private static final String NAMESPACE = "http://www.example.org/contract/DoubleIt";
    private static final QName SERVICE_QNAME = new QName("http://www.example.org/contract/DoubleIt", "DoubleItService");

    @BeforeClass
    public static void startServers() throws Exception {
        PartsTest.assertTrue((String)"Server failed to launch", (boolean)PartsTest.launchServer(Server.class, (boolean)true));
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        PartsTest.stopAllServers();
    }

    @Test
    public void testRequiredParts() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = PartsTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = PartsTest.class.getResource("DoubleItParts.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItRequiredPartsPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        port.doubleIt(25);
        portQName = new QName(NAMESPACE, "DoubleItRequiredPartsPort2");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        try {
            port.doubleIt(25);
            PartsTest.fail((String)"Failure expected on a required header which isn't present");
        }
        catch (SOAPFaultException ex) {
            String error = "RequiredParts: No header element";
            PartsTest.assertTrue((boolean)ex.getMessage().contains(error));
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testRequiredElements() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = PartsTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = PartsTest.class.getResource("DoubleItParts.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItRequiredElementsPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        port.doubleIt(25);
        portQName = new QName(NAMESPACE, "DoubleItRequiredElementsPort2");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        try {
            port.doubleIt(25);
            PartsTest.fail((String)"Failure expected on a required header which isn't present");
        }
        catch (SOAPFaultException ex) {
            String error = "RequiredElements: No header element";
            PartsTest.assertTrue((boolean)ex.getMessage().contains(error));
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSignedParts() throws Exception {
        String error;
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = PartsTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = PartsTest.class.getResource("DoubleItParts.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSignedPartsPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        port.doubleIt(25);
        portQName = new QName(NAMESPACE, "DoubleItSignedPartsPort2");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        try {
            port.doubleIt(25);
            PartsTest.fail((String)"Failure expected on a body which isn't signed");
        }
        catch (SOAPFaultException ex) {
            error = "SignedParts";
            PartsTest.assertTrue((boolean)ex.getMessage().contains(error));
        }
        portQName = new QName(NAMESPACE, "DoubleItSignedPartsPort3");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        try {
            port.doubleIt(25);
            PartsTest.fail((String)"Failure expected on a header which isn't signed");
        }
        catch (SOAPFaultException ex) {
            error = "SignedParts";
            PartsTest.assertTrue((boolean)ex.getMessage().contains(error));
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSignedElements() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = PartsTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = PartsTest.class.getResource("DoubleItParts.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSignedElementsPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        port.doubleIt(25);
        portQName = new QName(NAMESPACE, "DoubleItSignedElementsPort2");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        try {
            port.doubleIt(25);
            PartsTest.fail((String)"Failure expected on a header which isn't signed");
        }
        catch (SOAPFaultException ex) {
            String error = "SignedElements";
            PartsTest.assertTrue((boolean)ex.getMessage().contains(error));
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testEncryptedParts() throws Exception {
        String error;
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = PartsTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = PartsTest.class.getResource("DoubleItParts.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItEncryptedPartsPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        port.doubleIt(25);
        portQName = new QName(NAMESPACE, "DoubleItEncryptedPartsPort2");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        try {
            port.doubleIt(25);
            PartsTest.fail((String)"Failure expected on a body which isn't encrypted");
        }
        catch (SOAPFaultException ex) {
            error = "EncryptedParts";
            PartsTest.assertTrue((boolean)ex.getMessage().contains(error));
        }
        portQName = new QName(NAMESPACE, "DoubleItEncryptedPartsPort3");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        try {
            port.doubleIt(25);
            PartsTest.fail((String)"Failure expected on a header which isn't encrypted");
        }
        catch (SOAPFaultException ex) {
            error = "EncryptedParts";
            PartsTest.assertTrue((boolean)ex.getMessage().contains(error));
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testEncryptedElements() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = PartsTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = PartsTest.class.getResource("DoubleItParts.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItEncryptedElementsPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        port.doubleIt(25);
        portQName = new QName(NAMESPACE, "DoubleItEncryptedElementsPort2");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        try {
            port.doubleIt(25);
            PartsTest.fail((String)"Failure expected on a header which isn't encrypted");
        }
        catch (SOAPFaultException ex) {
            String error = "EncryptedElements";
            PartsTest.assertTrue((boolean)ex.getMessage().contains(error));
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testContentEncryptedElements() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = PartsTest.class.getResource("client/client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = PartsTest.class.getResource("DoubleItParts.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItContentEncryptedElementsPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        port.doubleIt(25);
        portQName = new QName(NAMESPACE, "DoubleItContentEncryptedElementsPort2");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        try {
            port.doubleIt(25);
            PartsTest.fail((String)"Failure expected on a header which isn't encrypted");
        }
        catch (SOAPFaultException ex) {
            String error = "EncryptedElements";
            PartsTest.assertTrue((boolean)ex.getMessage().contains(error));
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }
}

