/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.policy;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.policy.JavaFirstAttachmentPolicyService;
import org.apache.cxf.systest.ws.policy.SslUsernamePasswordAttachmentService;
import org.apache.cxf.systest.ws.policy.javafirst.BindingSimpleService;
import org.apache.cxf.systest.ws.policy.javafirst.NoAlternativesOperationSimpleService;
import org.apache.cxf.systest.ws.policy.javafirst.OperationSimpleService;
import org.apache.cxf.systest.ws.policy.server.JavaFirstPolicyServer;
import org.apache.cxf.systest.ws.wssec11.client.UTPasswordCallback;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JavaFirstPolicyServiceTest
extends AbstractBusClientServerTestBase {
    static final String PORT = JavaFirstPolicyServer.PORT;
    static final String PORT2 = JavaFirstPolicyServer.PORT2;
    static final String PORT3 = JavaFirstPolicyServer.PORT3;
    private static final String WSDL_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/";

    @BeforeClass
    public static void startServers() throws Exception {
        JavaFirstPolicyServiceTest.assertTrue((String)"Server failed to launch", (boolean)JavaFirstPolicyServiceTest.launchServer(JavaFirstPolicyServer.class, (boolean)true));
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        JavaFirstPolicyServiceTest.stopAllServers();
    }

    @Test
    public void testUsernameTokenInterceptorNoPasswordValidation() {
        System.setProperty("testutil.ports.JavaFirstPolicyServer", PORT);
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext("org/apache/cxf/systest/ws/policy/client/javafirstclient.xml");
        JavaFirstAttachmentPolicyService svc = (JavaFirstAttachmentPolicyService)ctx.getBean("JavaFirstAttachmentPolicyServiceClient", JavaFirstAttachmentPolicyService.class);
        WSS4JOutInterceptor wssOut = this.addToClient(svc);
        wssOut.setProperties(this.getPasswordProperties("alice", "password"));
        svc.doInputMessagePolicy();
        wssOut.setProperties(this.getPasswordProperties("alice", "passwordX"));
        try {
            svc.doInputMessagePolicy();
            JavaFirstPolicyServiceTest.fail((String)"Expected authentication failure");
        }
        catch (Exception e) {
            JavaFirstPolicyServiceTest.assertTrue((boolean)true);
        }
        wssOut.setProperties(this.getNoPasswordProperties("alice"));
        try {
            svc.doInputMessagePolicy();
            JavaFirstPolicyServiceTest.fail((String)"Expected authentication failure");
        }
        catch (Exception e) {
            JavaFirstPolicyServiceTest.assertTrue((boolean)true);
        }
    }

    @Test
    public void testUsernameTokenPolicyValidatorNoPasswordValidation() {
        System.setProperty("testutil.ports.JavaFirstPolicyServer.2", PORT2);
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext("org/apache/cxf/systest/ws/policy/client/javafirstclient.xml");
        SslUsernamePasswordAttachmentService svc = (SslUsernamePasswordAttachmentService)ctx.getBean("SslUsernamePasswordAttachmentServiceClient", SslUsernamePasswordAttachmentService.class);
        WSS4JOutInterceptor wssOut = this.addToClient(svc);
        wssOut.setProperties(this.getPasswordProperties("alice", "password"));
        svc.doSslAndUsernamePasswordPolicy();
        wssOut.setProperties(this.getPasswordProperties("alice", "passwordX"));
        try {
            svc.doSslAndUsernamePasswordPolicy();
            JavaFirstPolicyServiceTest.fail((String)"Expected authentication failure");
        }
        catch (Exception e) {
            JavaFirstPolicyServiceTest.assertTrue((boolean)true);
        }
        wssOut.setProperties(this.getNoPasswordProperties("alice"));
        try {
            svc.doSslAndUsernamePasswordPolicy();
            JavaFirstPolicyServiceTest.fail((String)"Expected authentication failure");
        }
        catch (Exception e) {
            JavaFirstPolicyServiceTest.assertTrue((boolean)true);
        }
    }

    @Test
    public void testBindingNoClientCertAlternativePolicy() {
        System.setProperty("testutil.ports.JavaFirstPolicyServer", PORT);
        ClassPathXmlApplicationContext clientContext = new ClassPathXmlApplicationContext(new String[]{"org/apache/cxf/systest/ws/policy/client/sslnocertclient.xml"});
        BindingSimpleService simpleService = (BindingSimpleService)clientContext.getBean("BindingSimpleServiceClient", BindingSimpleService.class);
        try {
            simpleService.doStuff();
            JavaFirstPolicyServiceTest.fail((String)"Expected exception as no credentials");
        }
        catch (SOAPFaultException e) {
            JavaFirstPolicyServiceTest.assertTrue((boolean)true);
        }
        WSS4JOutInterceptor wssOut = this.addToClient(simpleService);
        wssOut.setProperties(this.getNoPasswordProperties("alice"));
        try {
            simpleService.doStuff();
            JavaFirstPolicyServiceTest.fail((String)"Expected exception as no password and no client cert");
        }
        catch (SOAPFaultException e) {
            JavaFirstPolicyServiceTest.assertTrue((boolean)true);
        }
        wssOut.setProperties(this.getPasswordProperties("alice", "password"));
        simpleService.doStuff();
    }

    @Test
    public void testBindingClientCertAlternativePolicy() {
        System.setProperty("testutil.ports.JavaFirstPolicyServer.3", PORT3);
        ClassPathXmlApplicationContext clientContext = new ClassPathXmlApplicationContext(new String[]{"org/apache/cxf/systest/ws/policy/client/sslcertclient.xml"});
        BindingSimpleService simpleService = (BindingSimpleService)clientContext.getBean("BindingSimpleServiceClient", BindingSimpleService.class);
        try {
            simpleService.doStuff();
            JavaFirstPolicyServiceTest.fail((String)"Expected exception as no credentials");
        }
        catch (SOAPFaultException e) {
            JavaFirstPolicyServiceTest.assertTrue((boolean)true);
        }
        WSS4JOutInterceptor wssOut = this.addToClient(simpleService);
        wssOut.setProperties(this.getNoPasswordProperties("alice"));
        simpleService.doStuff();
        wssOut.setProperties(this.getPasswordProperties("alice", "password"));
        simpleService.doStuff();
    }

    @Test
    public void testNoAltOperationNoClientCertPolicy() {
        System.setProperty("testutil.ports.JavaFirstPolicyServer.3", PORT3);
        ClassPathXmlApplicationContext clientContext = new ClassPathXmlApplicationContext(new String[]{"org/apache/cxf/systest/ws/policy/client/sslnocertclient.xml"});
        NoAlternativesOperationSimpleService simpleService = (NoAlternativesOperationSimpleService)clientContext.getBean("NoAlternativesOperationSimpleServiceClient", NoAlternativesOperationSimpleService.class);
        try {
            simpleService.doStuff();
            JavaFirstPolicyServiceTest.fail((String)"Expected exception as no credentials");
        }
        catch (SOAPFaultException e) {
            JavaFirstPolicyServiceTest.assertTrue((boolean)true);
        }
        WSS4JOutInterceptor wssOut = this.addToClient(simpleService);
        wssOut.setProperties(this.getNoPasswordProperties("alice"));
        try {
            simpleService.doStuff();
            JavaFirstPolicyServiceTest.fail((String)"Expected exception as no password and no client cert");
        }
        catch (SOAPFaultException e) {
            JavaFirstPolicyServiceTest.assertTrue((boolean)true);
        }
        wssOut.setProperties(this.getPasswordProperties("alice", "password"));
        try {
            simpleService.doStuff();
            JavaFirstPolicyServiceTest.fail((String)"Expected exception as no client cert and password not allowed");
        }
        catch (SOAPFaultException e) {
            JavaFirstPolicyServiceTest.assertTrue((boolean)true);
        }
        wssOut.setProperties(this.getNoPasswordProperties("alice"));
        try {
            simpleService.ping();
            JavaFirstPolicyServiceTest.fail((String)"Expected exception as no password");
        }
        catch (SOAPFaultException e) {
            JavaFirstPolicyServiceTest.assertTrue((boolean)true);
        }
        wssOut.setProperties(this.getPasswordProperties("alice", "password"));
        simpleService.ping();
    }

    @Test
    public void testNoAltOperationClientCertPolicy() {
        System.setProperty("testutil.ports.JavaFirstPolicyServer.3", PORT3);
        ClassPathXmlApplicationContext clientContext = new ClassPathXmlApplicationContext(new String[]{"org/apache/cxf/systest/ws/policy/client/sslcertclient.xml"});
        NoAlternativesOperationSimpleService simpleService = (NoAlternativesOperationSimpleService)clientContext.getBean("NoAlternativesOperationSimpleServiceClient", NoAlternativesOperationSimpleService.class);
        try {
            simpleService.doStuff();
            JavaFirstPolicyServiceTest.fail((String)"Expected exception as no credentials");
        }
        catch (SOAPFaultException e) {
            JavaFirstPolicyServiceTest.assertTrue((boolean)true);
        }
        WSS4JOutInterceptor wssOut = this.addToClient(simpleService);
        wssOut.setProperties(this.getNoPasswordProperties("alice"));
        simpleService.doStuff();
        wssOut.setProperties(this.getPasswordProperties("alice", "password"));
        try {
            simpleService.doStuff();
            JavaFirstPolicyServiceTest.fail((String)"Expected exception as password not allowed");
        }
        catch (SOAPFaultException e) {
            JavaFirstPolicyServiceTest.assertTrue((boolean)true);
        }
        wssOut.setProperties(this.getNoPasswordProperties("alice"));
        try {
            simpleService.ping();
            JavaFirstPolicyServiceTest.fail((String)"Expected exception as no password");
        }
        catch (SOAPFaultException e) {
            JavaFirstPolicyServiceTest.assertTrue((boolean)true);
        }
        wssOut.setProperties(this.getPasswordProperties("alice", "password"));
        simpleService.ping();
    }

    @Test
    public void testOperationNoClientCertAlternativePolicy() {
        System.setProperty("testutil.ports.JavaFirstPolicyServer.3", PORT3);
        ClassPathXmlApplicationContext clientContext = new ClassPathXmlApplicationContext(new String[]{"org/apache/cxf/systest/ws/policy/client/sslnocertclient.xml"});
        OperationSimpleService simpleService = (OperationSimpleService)clientContext.getBean("OperationSimpleServiceClient", OperationSimpleService.class);
        simpleService.ping();
        try {
            simpleService.doStuff();
            JavaFirstPolicyServiceTest.fail((String)"Expected exception as no credentials");
        }
        catch (SOAPFaultException e) {
            JavaFirstPolicyServiceTest.assertTrue((boolean)true);
        }
        WSS4JOutInterceptor wssOut = this.addToClient(simpleService);
        wssOut.setProperties(this.getNoPasswordProperties("alice"));
        try {
            simpleService.doStuff();
            JavaFirstPolicyServiceTest.fail((String)"Expected exception as no password and no client cert");
        }
        catch (SOAPFaultException e) {
            JavaFirstPolicyServiceTest.assertTrue((boolean)true);
        }
        wssOut.setProperties(this.getPasswordProperties("alice", "password"));
        simpleService.doStuff();
    }

    @Test
    public void testOperationClientCertAlternativePolicy() {
        System.setProperty("testutil.ports.JavaFirstPolicyServer.3", PORT3);
        ClassPathXmlApplicationContext clientContext = new ClassPathXmlApplicationContext(new String[]{"org/apache/cxf/systest/ws/policy/client/sslcertclient.xml"});
        OperationSimpleService simpleService = (OperationSimpleService)clientContext.getBean("OperationSimpleServiceClient", OperationSimpleService.class);
        simpleService.ping();
        try {
            simpleService.doStuff();
            JavaFirstPolicyServiceTest.fail((String)"Expected exception as no credentials");
        }
        catch (SOAPFaultException e) {
            JavaFirstPolicyServiceTest.assertTrue((boolean)true);
        }
        WSS4JOutInterceptor wssOut = this.addToClient(simpleService);
        wssOut.setProperties(this.getNoPasswordProperties("alice"));
        simpleService.doStuff();
        wssOut.setProperties(this.getPasswordProperties("alice", "password"));
        simpleService.doStuff();
    }

    private WSS4JOutInterceptor addToClient(Object svc) {
        Client client = ClientProxy.getClient((Object)svc);
        WSS4JOutInterceptor wssOut = new WSS4JOutInterceptor();
        client.getEndpoint().getOutInterceptors().add(wssOut);
        client.getOutInterceptors().add(wssOut);
        return wssOut;
    }

    private Map<String, Object> getPasswordProperties(String username, String password) {
        UTPasswordCallback callback = new UTPasswordCallback();
        callback.setAliasPassword(username, password);
        HashMap<String, Object> outProps = new HashMap<String, Object>();
        outProps.put("action", "UsernameToken");
        outProps.put("passwordType", "PasswordText");
        outProps.put("passwordCallbackRef", callback);
        outProps.put("user", username);
        return outProps;
    }

    private Map<String, Object> getNoPasswordProperties(String username) {
        HashMap<String, Object> outProps = new HashMap<String, Object>();
        outProps.put("action", "UsernameToken");
        outProps.put("passwordType", "PasswordNone");
        outProps.put("user", username);
        return outProps;
    }

    @Test
    public void testJavaFirstAttachmentWsdl() throws Exception {
        Document doc = this.loadWsdl("JavaFirstAttachmentPolicyService");
        this.testJavaFirstAttachmentWsdl(doc);
        Document doc2 = this.loadWsdl("JavaFirstAttachmentPolicyService2");
        this.testJavaFirstAttachmentWsdl(doc2);
    }

    private void testJavaFirstAttachmentWsdl(Document doc) throws Exception {
        Element binding = DOMUtils.getFirstChildWithName((Element)doc.getDocumentElement(), (String)WSDL_NAMESPACE, (String)"binding");
        JavaFirstPolicyServiceTest.assertNotNull((Object)binding);
        List operationMessages = DOMUtils.getChildrenWithName((Element)binding, (String)WSDL_NAMESPACE, (String)"operation");
        JavaFirstPolicyServiceTest.assertEquals((long)4L, (long)operationMessages.size());
        Element doOperationLevelPolicy = this.getOperationElement("doOperationLevelPolicy", operationMessages);
        JavaFirstPolicyServiceTest.assertEquals((Object)"#UsernameToken", (Object)this.getOperationPolicyReferenceId(doOperationLevelPolicy, "http://schemas.xmlsoap.org/ws/2004/09/policy"));
        Element doInputMessagePolicy = this.getOperationElement("doInputMessagePolicy", operationMessages);
        JavaFirstPolicyServiceTest.assertEquals((Object)"#UsernameToken", (Object)this.getMessagePolicyReferenceId(doInputMessagePolicy, MessageInfo.Type.INPUT, "http://schemas.xmlsoap.org/ws/2004/09/policy"));
        JavaFirstPolicyServiceTest.assertNull((Object)this.getMessagePolicyReferenceId(doInputMessagePolicy, MessageInfo.Type.OUTPUT, "http://schemas.xmlsoap.org/ws/2004/09/policy"));
        Element doOutputMessagePolicy = this.getOperationElement("doOutputMessagePolicy", operationMessages);
        JavaFirstPolicyServiceTest.assertEquals((Object)"#UsernameToken", (Object)this.getMessagePolicyReferenceId(doOutputMessagePolicy, MessageInfo.Type.OUTPUT, "http://schemas.xmlsoap.org/ws/2004/09/policy"));
        JavaFirstPolicyServiceTest.assertNull((Object)this.getMessagePolicyReferenceId(doOutputMessagePolicy, MessageInfo.Type.INPUT, "http://schemas.xmlsoap.org/ws/2004/09/policy"));
        Element doNoPolicy = this.getOperationElement("doNoPolicy", operationMessages);
        JavaFirstPolicyServiceTest.assertNull((Object)this.getMessagePolicyReferenceId(doNoPolicy, MessageInfo.Type.INPUT, "http://schemas.xmlsoap.org/ws/2004/09/policy"));
        JavaFirstPolicyServiceTest.assertNull((Object)this.getMessagePolicyReferenceId(doNoPolicy, MessageInfo.Type.OUTPUT, "http://schemas.xmlsoap.org/ws/2004/09/policy"));
        List policyMessages = DOMUtils.getChildrenWithName((Element)doc.getDocumentElement(), (String)"http://schemas.xmlsoap.org/ws/2004/09/policy", (String)"Policy");
        JavaFirstPolicyServiceTest.assertEquals((long)1L, (long)policyMessages.size());
        JavaFirstPolicyServiceTest.assertEquals((Object)"UsernameToken", (Object)this.getPolicyId((Element)policyMessages.get(0)));
        Element exactlyOne = DOMUtils.getFirstChildWithName((Element)((Element)policyMessages.get(0)), (String)"", (String)"ExactlyOne");
        JavaFirstPolicyServiceTest.assertNull((Object)exactlyOne);
        exactlyOne = DOMUtils.getFirstChildWithName((Element)((Element)policyMessages.get(0)), (String)"http://schemas.xmlsoap.org/ws/2004/09/policy", (String)"ExactlyOne");
        JavaFirstPolicyServiceTest.assertNotNull((Object)exactlyOne);
    }

    @Test
    public void testJavaFirstWsdl() throws Exception {
        Document doc = this.loadWsdl("JavaFirstPolicyService");
        Element portType = DOMUtils.getFirstChildWithName((Element)doc.getDocumentElement(), (String)WSDL_NAMESPACE, (String)"portType");
        JavaFirstPolicyServiceTest.assertNotNull((Object)portType);
        List operationMessages = DOMUtils.getChildrenWithName((Element)portType, (String)WSDL_NAMESPACE, (String)"operation");
        JavaFirstPolicyServiceTest.assertEquals((long)5L, (long)operationMessages.size());
        Element operationOne = this.getOperationElement("doOperationOne", operationMessages);
        JavaFirstPolicyServiceTest.assertEquals((Object)"#InternalTransportAndUsernamePolicy", (Object)this.getMessagePolicyReferenceId(operationOne, MessageInfo.Type.INPUT, "http://www.w3.org/ns/ws-policy"));
        Element operationTwo = this.getOperationElement("doOperationTwo", operationMessages);
        JavaFirstPolicyServiceTest.assertEquals((Object)"#TransportAndUsernamePolicy", (Object)this.getMessagePolicyReferenceId(operationTwo, MessageInfo.Type.INPUT, "http://www.w3.org/ns/ws-policy"));
        Element operationThree = this.getOperationElement("doOperationThree", operationMessages);
        JavaFirstPolicyServiceTest.assertEquals((Object)"#InternalTransportAndUsernamePolicy", (Object)this.getMessagePolicyReferenceId(operationThree, MessageInfo.Type.INPUT, "http://www.w3.org/ns/ws-policy"));
        Element operationFour = this.getOperationElement("doOperationFour", operationMessages);
        JavaFirstPolicyServiceTest.assertEquals((Object)"#TransportAndUsernamePolicy", (Object)this.getMessagePolicyReferenceId(operationFour, MessageInfo.Type.INPUT, "http://www.w3.org/ns/ws-policy"));
        Element operationPing = this.getOperationElement("doPing", operationMessages);
        JavaFirstPolicyServiceTest.assertNull((Object)this.getMessagePolicyReferenceId(operationPing, MessageInfo.Type.INPUT, "http://www.w3.org/ns/ws-policy"));
        List policyMessages = DOMUtils.getChildrenWithName((Element)doc.getDocumentElement(), (String)"http://www.w3.org/ns/ws-policy", (String)"Policy");
        JavaFirstPolicyServiceTest.assertEquals((long)2L, (long)policyMessages.size());
        JavaFirstPolicyServiceTest.assertEquals((Object)"TransportAndUsernamePolicy", (Object)this.getPolicyId((Element)policyMessages.get(0)));
        JavaFirstPolicyServiceTest.assertEquals((Object)"InternalTransportAndUsernamePolicy", (Object)this.getPolicyId((Element)policyMessages.get(1)));
    }

    private Document loadWsdl(String serviceName) throws Exception {
        HttpURLConnection connection = this.getHttpConnection("http://localhost:" + PORT + "/" + serviceName + "?wsdl");
        InputStream is = connection.getInputStream();
        String wsdlContents = IOUtils.toString((InputStream)is);
        return StaxUtils.read((Reader)new StringReader(wsdlContents));
    }

    private String getPolicyId(Element element) {
        return element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
    }

    private Element getOperationElement(String operationName, List<Element> operationMessages) {
        Element operationElement = null;
        for (Element operation : operationMessages) {
            if (!operationName.equals(operation.getAttributeNS(null, "name"))) continue;
            operationElement = operation;
            break;
        }
        JavaFirstPolicyServiceTest.assertNotNull(operationElement);
        return operationElement;
    }

    private String getMessagePolicyReferenceId(Element operationElement, MessageInfo.Type type, String policyNamespace) {
        Element messageElement = DOMUtils.getFirstChildWithName((Element)operationElement, (String)WSDL_NAMESPACE, (String)type.name().toLowerCase());
        JavaFirstPolicyServiceTest.assertNotNull((Object)messageElement);
        Element policyReference = DOMUtils.getFirstChildWithName((Element)messageElement, (String)policyNamespace, (String)"PolicyReference");
        if (policyReference != null) {
            return policyReference.getAttributeNS(null, "URI");
        }
        return null;
    }

    private String getOperationPolicyReferenceId(Element operationElement, String policyNamespace) {
        Element policyReference = DOMUtils.getFirstChildWithName((Element)operationElement, (String)policyNamespace, (String)"PolicyReference");
        if (policyReference != null) {
            return policyReference.getAttributeNS(null, "URI");
        }
        return null;
    }
}

