/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.saml.client;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.systest.ws.saml.client.SamlCallbackHandler;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.saml.ext.SAMLCallback;
import org.apache.ws.security.saml.ext.SAMLParms;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SamlElementCallbackHandler
implements CallbackHandler {
    private boolean saml2 = true;

    public SamlElementCallbackHandler() {
    }

    public SamlElementCallbackHandler(boolean saml2) {
        this.saml2 = saml2;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            Element assertionElement;
            if (!(callbacks[i] instanceof SAMLCallback)) continue;
            SAMLCallback callback = (SAMLCallback)callbacks[i];
            try {
                Document doc = DOMUtils.createDocument();
                assertionElement = this.getSAMLAssertion(doc);
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
            callback.setAssertionElement(assertionElement);
        }
    }

    private Element getSAMLAssertion(Document doc) throws Exception {
        SAMLParms parms = new SAMLParms();
        SamlCallbackHandler callbackHandler = new SamlCallbackHandler(this.saml2);
        parms.setCallbackHandler((CallbackHandler)callbackHandler);
        AssertionWrapper assertionWrapper = new AssertionWrapper(parms);
        return assertionWrapper.toDOM(doc);
    }
}

