/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.saml.server;

import java.util.List;
import org.apache.cxf.message.Message;
import org.apache.cxf.rt.security.xacml.AbstractXACMLAuthorizingInterceptor;
import org.opensaml.Configuration;
import org.opensaml.xacml.XACMLObjectBuilder;
import org.opensaml.xacml.ctx.AttributeType;
import org.opensaml.xacml.ctx.AttributeValueType;
import org.opensaml.xacml.ctx.DecisionType;
import org.opensaml.xacml.ctx.RequestType;
import org.opensaml.xacml.ctx.ResponseType;
import org.opensaml.xacml.ctx.ResultType;
import org.opensaml.xacml.ctx.StatusCodeType;
import org.opensaml.xacml.ctx.StatusType;
import org.opensaml.xacml.ctx.SubjectType;
import org.opensaml.xml.XMLObjectBuilderFactory;

public class XACMLAuthorizingInterceptor
extends AbstractXACMLAuthorizingInterceptor {
    public ResponseType performRequest(RequestType request, Message message) throws Exception {
        XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
        XACMLObjectBuilder responseTypeBuilder = (XACMLObjectBuilder)builderFactory.getBuilder(ResponseType.DEFAULT_ELEMENT_NAME);
        XACMLObjectBuilder resultTypeBuilder = (XACMLObjectBuilder)builderFactory.getBuilder(ResultType.DEFAULT_ELEMENT_NAME);
        XACMLObjectBuilder decisionTypeBuilder = (XACMLObjectBuilder)builderFactory.getBuilder(DecisionType.DEFAULT_ELEMENT_NAME);
        XACMLObjectBuilder statusTypeBuilder = (XACMLObjectBuilder)builderFactory.getBuilder(StatusType.DEFAULT_ELEMENT_NAME);
        XACMLObjectBuilder statusCodeTypeBuilder = (XACMLObjectBuilder)builderFactory.getBuilder(StatusCodeType.DEFAULT_ELEMENT_NAME);
        DecisionType decisionType = (DecisionType)decisionTypeBuilder.buildObject();
        String role = this.getSubjectRole(request);
        if ("manager".equals(role)) {
            decisionType.setDecision(DecisionType.DECISION.Permit);
        } else {
            decisionType.setDecision(DecisionType.DECISION.Deny);
        }
        ResultType result = (ResultType)resultTypeBuilder.buildObject();
        result.setDecision(decisionType);
        StatusType status = (StatusType)statusTypeBuilder.buildObject();
        StatusCodeType statusCode = (StatusCodeType)statusCodeTypeBuilder.buildObject();
        statusCode.setValue("urn:oasis:names:tc:xacml:1.0:status:ok");
        status.setStatusCode(statusCode);
        result.setStatus(status);
        ResponseType response = (ResponseType)responseTypeBuilder.buildObject();
        response.setResult(result);
        return response;
    }

    private String getSubjectRole(RequestType request) {
        List subjects = request.getSubjects();
        if (subjects != null) {
            for (SubjectType subject : subjects) {
                List attributes = subject.getAttributes();
                if (attributes == null) continue;
                for (AttributeType attribute : attributes) {
                    if (!"urn:oasis:names:tc:xacml:2.0:subject:role".equals(attribute.getAttributeID())) continue;
                    return ((AttributeValueType)attribute.getAttributeValues().get(0)).getValue();
                }
            }
        }
        return null;
    }
}

