/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.saml.subjectconf;

import java.io.Closeable;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.saml.client.SamlCallbackHandler;
import org.apache.cxf.systest.ws.saml.subjectconf.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.example.contract.doubleit.DoubleItPortType;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class SamlSubjectConfTest
extends AbstractBusClientServerTestBase {
    static final String PORT = SamlSubjectConfTest.allocatePort(Server.class);
    private static final String NAMESPACE = "http://www.example.org/contract/DoubleIt";
    private static final QName SERVICE_QNAME = new QName("http://www.example.org/contract/DoubleIt", "DoubleItService");

    @BeforeClass
    public static void startServers() throws Exception {
        SamlSubjectConfTest.assertTrue((String)"Server failed to launch", (boolean)SamlSubjectConfTest.launchServer(Server.class, (boolean)true));
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        SamlSubjectConfTest.stopAllServers();
    }

    @Test
    public void testHOKClientAuthentication() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlSubjectConfTest.class.getResource("client-auth.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlSubjectConfTest.class.getResource("DoubleItSamlSubjectConf.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2TransportPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        SamlCallbackHandler callbackHandler = new SamlCallbackHandler(true);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        callbackHandler.setCryptoAlias("morpit");
        callbackHandler.setCryptoPropertiesFile("morpit.properties");
        ((BindingProvider)port).getRequestContext().put("ws-security.saml-callback-handler", callbackHandler);
        ((BindingProvider)port).getRequestContext().put("ws-security.self-sign-saml-assertion", "true");
        ((BindingProvider)port).getRequestContext().put("ws-security.callback-handler", "org.apache.cxf.systest.ws.wssec10.client.KeystorePasswordCallback");
        ((BindingProvider)port).getRequestContext().put("ws-security.signature.username", "morpit");
        ((BindingProvider)port).getRequestContext().put("ws-security.signature.properties", "morpit.properties");
        int result = port.doubleIt(25);
        SamlSubjectConfTest.assertTrue((result == 50 ? 1 : 0) != 0);
        ((BindingProvider)port).getRequestContext().put("ws-security.self-sign-saml-assertion", "false");
        try {
            port.doubleIt(25);
            SamlSubjectConfTest.fail((String)"Failure expected on a unsigned assertion");
        }
        catch (SOAPFaultException ex) {
            // empty catch block
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testHOKNonMatchingCert() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlSubjectConfTest.class.getResource("client-auth.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlSubjectConfTest.class.getResource("DoubleItSamlSubjectConf.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2TransportPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        SamlCallbackHandler callbackHandler = new SamlCallbackHandler(true);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        ((BindingProvider)port).getRequestContext().put("ws-security.saml-callback-handler", callbackHandler);
        ((BindingProvider)port).getRequestContext().put("ws-security.self-sign-saml-assertion", "true");
        ((BindingProvider)port).getRequestContext().put("ws-security.callback-handler", "org.apache.cxf.systest.ws.wssec10.client.KeystorePasswordCallback");
        ((BindingProvider)port).getRequestContext().put("ws-security.signature.username", "alice");
        ((BindingProvider)port).getRequestContext().put("ws-security.signature.properties", "alice.properties");
        try {
            port.doubleIt(25);
            SamlSubjectConfTest.fail((String)"Failure expected on a non matching cert (SAML -> TLS)");
        }
        catch (SOAPFaultException ex) {
            // empty catch block
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testHOKNoClientAuthentication() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlSubjectConfTest.class.getResource("client-noauth.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlSubjectConfTest.class.getResource("DoubleItSamlSubjectConf.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2TransportPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        SamlCallbackHandler callbackHandler = new SamlCallbackHandler(true);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        callbackHandler.setCryptoAlias("morpit");
        callbackHandler.setCryptoPropertiesFile("morpit.properties");
        ((BindingProvider)port).getRequestContext().put("ws-security.saml-callback-handler", callbackHandler);
        ((BindingProvider)port).getRequestContext().put("ws-security.self-sign-saml-assertion", "true");
        ((BindingProvider)port).getRequestContext().put("ws-security.callback-handler", "org.apache.cxf.systest.ws.wssec10.client.KeystorePasswordCallback");
        ((BindingProvider)port).getRequestContext().put("ws-security.signature.username", "morpit");
        ((BindingProvider)port).getRequestContext().put("ws-security.signature.properties", "morpit.properties");
        try {
            port.doubleIt(25);
            SamlSubjectConfTest.fail((String)"Failure expected on no client auth");
        }
        catch (SOAPFaultException ex) {
            // empty catch block
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSVClientAuthentication() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlSubjectConfTest.class.getResource("client-auth.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlSubjectConfTest.class.getResource("DoubleItSamlSubjectConf.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2TransportPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        SamlCallbackHandler callbackHandler = new SamlCallbackHandler(true);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:sender-vouches");
        ((BindingProvider)port).getRequestContext().put("ws-security.saml-callback-handler", callbackHandler);
        int result = port.doubleIt(25);
        SamlSubjectConfTest.assertTrue((result == 50 ? 1 : 0) != 0);
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSVNoClientAuthentication() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlSubjectConfTest.class.getResource("client-noauth.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlSubjectConfTest.class.getResource("DoubleItSamlSubjectConf.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2TransportPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        SamlCallbackHandler callbackHandler = new SamlCallbackHandler(true);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:sender-vouches");
        ((BindingProvider)port).getRequestContext().put("ws-security.saml-callback-handler", callbackHandler);
        try {
            port.doubleIt(25);
            SamlSubjectConfTest.fail((String)"Failure expected on no client auth");
        }
        catch (SOAPFaultException ex) {
            // empty catch block
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testBearer() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlSubjectConfTest.class.getResource("client-auth.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlSubjectConfTest.class.getResource("DoubleItSamlSubjectConf.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2TransportPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        SamlCallbackHandler callbackHandler = new SamlCallbackHandler(true);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        callbackHandler.setCryptoAlias("morpit");
        callbackHandler.setCryptoPropertiesFile("morpit.properties");
        ((BindingProvider)port).getRequestContext().put("ws-security.saml-callback-handler", callbackHandler);
        ((BindingProvider)port).getRequestContext().put("ws-security.self-sign-saml-assertion", "true");
        ((BindingProvider)port).getRequestContext().put("ws-security.callback-handler", "org.apache.cxf.systest.ws.wssec10.client.KeystorePasswordCallback");
        ((BindingProvider)port).getRequestContext().put("ws-security.signature.username", "morpit");
        ((BindingProvider)port).getRequestContext().put("ws-security.signature.properties", "morpit.properties");
        int result = port.doubleIt(25);
        SamlSubjectConfTest.assertTrue((result == 50 ? 1 : 0) != 0);
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testUnsignedBearer() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlSubjectConfTest.class.getResource("client-auth.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlSubjectConfTest.class.getResource("DoubleItSamlSubjectConf.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2TransportPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        SamlCallbackHandler callbackHandler = new SamlCallbackHandler(true);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        ((BindingProvider)port).getRequestContext().put("ws-security.saml-callback-handler", callbackHandler);
        try {
            port.doubleIt(25);
            SamlSubjectConfTest.fail((String)"Failure expected on an unsigned bearer token");
        }
        catch (SOAPFaultException ex) {
            // empty catch block
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testUnknownCustomMethod() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SamlSubjectConfTest.class.getResource("client-auth.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SamlSubjectConfTest.class.getResource("DoubleItSamlSubjectConf.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSaml2TransportPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        SamlCallbackHandler callbackHandler = new SamlCallbackHandler(true);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:custom");
        ((BindingProvider)port).getRequestContext().put("ws-security.saml-callback-handler", callbackHandler);
        try {
            port.doubleIt(25);
            SamlSubjectConfTest.fail((String)"Failure expected on an unknown custom subject confirmation method");
        }
        catch (SOAPFaultException ex) {
            // empty catch block
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }
}

