/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.security;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.AddressingFeature;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxws.DispatchImpl;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.security.Server;
import org.apache.cxf.systest.ws.security.TestOutHandler;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;
import org.apache.hello_world_soap_http.Greeter;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class WSSecurityClientTest
extends AbstractBusClientServerTestBase {
    public static final String PORT = WSSecurityClientTest.allocatePort(Server.class);
    public static final String DEC_PORT = WSSecurityClientTest.allocatePort(WSSecurityClientTest.class);
    private static final URL WSDL_LOC;
    private static final QName GREETER_SERVICE_QNAME;
    private static final QName TIMESTAMP_SIGN_ENCRYPT_PORT_QNAME;
    private static final QName USERNAME_TOKEN_PORT_QNAME;

    @BeforeClass
    public static void startServers() throws Exception {
        WSSecurityClientTest.assertTrue((String)"Server failed to launch", (boolean)WSSecurityClientTest.launchServer(Server.class, (boolean)true));
        WSSecurityClientTest.createStaticBus();
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        WSSecurityClientTest.stopAllServers();
    }

    @Test
    public void testUsernameToken() throws Exception {
        Service svc = Service.create((URL)WSDL_LOC, (QName)GREETER_SERVICE_QNAME);
        Greeter greeter = (Greeter)svc.getPort(USERNAME_TOKEN_PORT_QNAME, Greeter.class);
        this.updateAddressPort(greeter, PORT);
        Client client = ClientProxy.getClient((Object)greeter);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("action", "UsernameToken");
        props.put("user", "alice");
        props.put("passwordType", "PasswordText");
        WSS4JOutInterceptor wss4jOut = new WSS4JOutInterceptor(props);
        client.getOutInterceptors().add(wss4jOut);
        ((BindingProvider)greeter).getRequestContext().put("password", "password");
        try {
            greeter.greetMe("CXF");
            WSSecurityClientTest.fail((String)"should fail because of password text instead of digest");
        }
        catch (Exception ex) {
            // empty catch block
        }
        props.put("passwordType", "PasswordDigest");
        String s = greeter.greetMe("CXF");
        WSSecurityClientTest.assertEquals((Object)"Hello CXF", (Object)s);
        try {
            ((BindingProvider)greeter).getRequestContext().put("password", "foo");
            greeter.greetMe("CXF");
            WSSecurityClientTest.fail((String)"should fail");
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            props.put("passwordType", "PasswordText");
            ((BindingProvider)greeter).getRequestContext().put("password", "password");
            greeter.greetMe("CXF");
            WSSecurityClientTest.fail((String)"should fail");
        }
        catch (Exception ex) {
            // empty catch block
        }
        ((Closeable)greeter).close();
    }

    @Test
    public void testTimestampSignEncrypt() throws Exception {
        Bus b = new SpringBusFactory().createBus("org/apache/cxf/systest/ws/security/client.xml");
        BusFactory.setDefaultBus((Bus)b);
        Service svc = Service.create((URL)WSDL_LOC, (QName)GREETER_SERVICE_QNAME);
        Greeter greeter = (Greeter)svc.getPort(TIMESTAMP_SIGN_ENCRYPT_PORT_QNAME, Greeter.class);
        this.updateAddressPort(greeter, PORT);
        ArrayList<TestOutHandler> handlerChain = new ArrayList<TestOutHandler>();
        Binding binding = ((BindingProvider)greeter).getBinding();
        TestOutHandler handler = new TestOutHandler();
        handlerChain.add(handler);
        binding.setHandlerChain(handlerChain);
        greeter.sayHi();
        WSSecurityClientTest.assertTrue((String)"expected Handler.handleMessage() to be called", (boolean)handler.handleMessageCalledOutbound);
        WSSecurityClientTest.assertFalse((String)"expected Handler.handleFault() not to be called", (boolean)handler.handleFaultCalledOutbound);
        ((Closeable)greeter).close();
        b.shutdown(true);
        BusFactory.setDefaultBus((Bus)WSSecurityClientTest.getStaticBus());
    }

    @Test
    public void testMalformedSecurityHeaders() throws Exception {
        Dispatch<Source> dispatcher = null;
        InputStream is = null;
        String result = null;
        dispatcher = WSSecurityClientTest.createUsernameTokenDispatcher();
        result = WSSecurityClientTest.source2String((Source)dispatcher.invoke((Object)new StreamSource(is = ((Object)((Object)this)).getClass().getResourceAsStream("test-data/UsernameTokenRequest.xml"))));
        WSSecurityClientTest.assertTrue((result.indexOf("Fault") != -1 ? 1 : 0) != 0);
        dispatcher = WSSecurityClientTest.createUsernameTokenDispatcher();
        is = ((Object)((Object)this)).getClass().getResourceAsStream("test-data/NoHeadersRequest.xml");
        result = WSSecurityClientTest.source2String((Source)dispatcher.invoke((Object)new StreamSource(is)));
        WSSecurityClientTest.assertTrue((result.indexOf("Fault") != -1 ? 1 : 0) != 0);
        dispatcher = WSSecurityClientTest.createUsernameTokenDispatcher();
        is = ((Object)((Object)this)).getClass().getResourceAsStream("test-data/EmptyHeaderRequest.xml");
        result = WSSecurityClientTest.source2String((Source)dispatcher.invoke((Object)new StreamSource(is)));
        WSSecurityClientTest.assertTrue((result.indexOf("Fault") != -1 ? 1 : 0) != 0);
        dispatcher = WSSecurityClientTest.createUsernameTokenDispatcher();
        is = ((Object)((Object)this)).getClass().getResourceAsStream("test-data/EmptySecurityHeaderRequest.xml");
        result = WSSecurityClientTest.source2String((Source)dispatcher.invoke((Object)new StreamSource(is)));
        WSSecurityClientTest.assertTrue((result.indexOf("Fault") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testDecoupledFaultFromSecurity() throws Exception {
        Dispatch<Source> dispatcher = null;
        InputStream is = null;
        dispatcher = WSSecurityClientTest.createUsernameTokenDispatcher(true);
        is = ((Object)((Object)this)).getClass().getResourceAsStream("test-data/NoHeadersRequest.xml");
        try {
            dispatcher.invoke((Object)new StreamSource(is));
            WSSecurityClientTest.fail((String)"exception should have been generated");
        }
        catch (SOAPFaultException ex) {
            WSSecurityClientTest.assertTrue((boolean)ex.getMessage().contains("Security"));
        }
        dispatcher = WSSecurityClientTest.createUsernameTokenDispatcher(true);
        is = ((Object)((Object)this)).getClass().getResourceAsStream("test-data/EmptyHeaderRequest.xml");
        try {
            dispatcher.invoke((Object)new StreamSource(is));
            WSSecurityClientTest.fail((String)"exception should have been generated");
        }
        catch (SOAPFaultException ex) {
            WSSecurityClientTest.assertTrue((boolean)ex.getMessage().contains("Security"));
        }
        dispatcher = WSSecurityClientTest.createUsernameTokenDispatcher(true);
        is = ((Object)((Object)this)).getClass().getResourceAsStream("test-data/EmptySecurityHeaderRequest.xml");
        try {
            dispatcher.invoke((Object)new StreamSource(is));
            WSSecurityClientTest.fail((String)"exception should have been generated");
        }
        catch (SOAPFaultException ex) {
            WSSecurityClientTest.assertTrue((boolean)ex.getMessage().contains("Security"));
        }
    }

    private static Dispatch<Source> createUsernameTokenDispatcher() {
        return WSSecurityClientTest.createUsernameTokenDispatcher(false);
    }

    private static Dispatch<Source> createUsernameTokenDispatcher(boolean decoupled) {
        Service service = Service.create((QName)GREETER_SERVICE_QNAME);
        service.addPort(USERNAME_TOKEN_PORT_QNAME, decoupled ? "http://schemas.xmlsoap.org/wsdl/soap/http" : "http://www.w3.org/2004/08/wsdl/http", "http://localhost:" + PORT + "/GreeterService/UsernameTokenPort");
        Dispatch dispatcher = service.createDispatch(USERNAME_TOKEN_PORT_QNAME, Source.class, Service.Mode.MESSAGE, new WebServiceFeature[]{new AddressingFeature(decoupled, decoupled)});
        Map requestContext = dispatcher.getRequestContext();
        requestContext.put("javax.xml.ws.http.request.method", "POST");
        if (decoupled) {
            HTTPConduit cond = (HTTPConduit)((DispatchImpl)dispatcher).getClient().getConduit();
            cond.getClient().setDecoupledEndpoint("http://localhost:" + DEC_PORT + "/decoupled");
        }
        return dispatcher;
    }

    private static String source2String(Source source) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        StreamResult sr = new StreamResult(bos);
        Transformer trans = TransformerFactory.newInstance().newTransformer();
        Properties oprops = new Properties();
        oprops.put("omit-xml-declaration", "yes");
        trans.setOutputProperties(oprops);
        trans.transform(source, sr);
        return bos.toString();
    }

    static {
        URL tmp = null;
        try {
            tmp = WSSecurityClientTest.class.getClassLoader().getResource("org/apache/cxf/systest/ws/security/hello_world.wsdl");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        WSDL_LOC = tmp;
        GREETER_SERVICE_QNAME = new QName("http://apache.org/hello_world_soap_http", "GreeterService");
        TIMESTAMP_SIGN_ENCRYPT_PORT_QNAME = new QName("http://apache.org/hello_world_soap_http", "TimestampSignEncryptPort");
        USERNAME_TOKEN_PORT_QNAME = new QName("http://apache.org/hello_world_soap_http", "UsernameTokenPort");
    }
}

