/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.tokens;

import java.io.Closeable;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.tokens.server.EndorsingServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.example.contract.doubleit.DoubleItPortType;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class EndorsingSupportingTokenTest
extends AbstractBusClientServerTestBase {
    static final String PORT = EndorsingSupportingTokenTest.allocatePort(EndorsingServer.class);
    private static final String NAMESPACE = "http://www.example.org/contract/DoubleIt";
    private static final QName SERVICE_QNAME = new QName("http://www.example.org/contract/DoubleIt", "DoubleItService");

    @BeforeClass
    public static void startServers() throws Exception {
        EndorsingSupportingTokenTest.assertTrue((String)"Server failed to launch", (boolean)EndorsingSupportingTokenTest.launchServer(EndorsingServer.class, (boolean)true));
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        EndorsingSupportingTokenTest.stopAllServers();
    }

    @Test
    public void testEndorsingSupporting() throws Exception {
        String error;
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = EndorsingSupportingTokenTest.class.getResource("client/endorsing-client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = EndorsingSupportingTokenTest.class.getResource("DoubleItTokens.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItEndorsingSupportingPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        port.doubleIt(25);
        portQName = new QName(NAMESPACE, "DoubleItEndorsingSupportingPort2");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        try {
            port.doubleIt(25);
            EndorsingSupportingTokenTest.fail((String)"Failure expected on not endorsing the X.509 token");
        }
        catch (SOAPFaultException ex) {
            error = "The received token does not match the endorsing supporting token requirement";
            EndorsingSupportingTokenTest.assertTrue((boolean)ex.getMessage().contains(error));
        }
        portQName = new QName(NAMESPACE, "DoubleItEndorsingSupportingPort3");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        try {
            port.doubleIt(25);
            EndorsingSupportingTokenTest.fail((String)"Failure expected on not endorsing the X.509 token");
        }
        catch (SOAPFaultException ex) {
            error = "The received token does not match the endorsing supporting token requirement";
            EndorsingSupportingTokenTest.assertTrue((boolean)ex.getMessage().contains(error));
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSignedEndorsingSupporting() throws Exception {
        String error;
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = EndorsingSupportingTokenTest.class.getResource("client/endorsing-client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = EndorsingSupportingTokenTest.class.getResource("DoubleItTokens.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSignedEndorsingSupportingPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        port.doubleIt(25);
        portQName = new QName(NAMESPACE, "DoubleItSignedEndorsingSupportingPort2");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        try {
            port.doubleIt(25);
            EndorsingSupportingTokenTest.fail((String)"Failure expected on not endorsing the X.509 token");
        }
        catch (SOAPFaultException ex) {
            error = "The received token does not match the signed endorsing supporting token requirement";
            EndorsingSupportingTokenTest.assertTrue((boolean)ex.getMessage().contains(error));
        }
        portQName = new QName(NAMESPACE, "DoubleItSignedEndorsingSupportingPort3");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        try {
            port.doubleIt(25);
            EndorsingSupportingTokenTest.fail((String)"Failure expected on not signing the X.509 token");
        }
        catch (SOAPFaultException ex) {
            error = "The received token does not match the signed endorsing supporting token requirement";
            EndorsingSupportingTokenTest.assertTrue((boolean)ex.getMessage().contains(error));
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }
}

