/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.ut;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.saaj.SAAJUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptor;
import org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JOutInterceptor;

public class SecurityHeaderCacheInterceptor
implements PhaseInterceptor<SoapMessage> {
    private static final QName SEC_HEADER = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security", "wsse");
    private Set<String> afterInterceptors = new HashSet<String>();
    private SOAPHeaderElement cachedSecurityHeader;

    public SecurityHeaderCacheInterceptor() {
        this.getAfter().add(PolicyBasedWSS4JOutInterceptor.class.getName());
    }

    public void handleMessage(SoapMessage mc) throws Fault {
        SOAPMessage saaj = (SOAPMessage)mc.getContent(SOAPMessage.class);
        if (this.cachedSecurityHeader == null) {
            try {
                Iterator cachedHeadersIterator = SAAJUtils.getHeader((SOAPMessage)saaj).getChildElements(SEC_HEADER);
                if (cachedHeadersIterator.hasNext()) {
                    this.cachedSecurityHeader = (SOAPHeaderElement)cachedHeadersIterator.next();
                }
            }
            catch (SOAPException e) {}
        } else {
            try {
                saaj.getSOAPHeader().removeContents();
                SOAPHeaderElement secHeaderElement = SAAJUtils.getHeader((SOAPMessage)saaj).addHeaderElement(SEC_HEADER);
                Iterator cachedHeadersIterator = this.cachedSecurityHeader.getChildElements();
                while (cachedHeadersIterator.hasNext()) {
                    secHeaderElement.addChildElement((SOAPElement)cachedHeadersIterator.next());
                }
            }
            catch (SOAPException e) {
                e.printStackTrace();
            }
        }
    }

    public void clear() {
        this.cachedSecurityHeader = null;
    }

    public void handleFault(SoapMessage arg0) {
    }

    public Collection<PhaseInterceptor<? extends Message>> getAdditionalInterceptors() {
        return null;
    }

    public Set<String> getAfter() {
        return this.afterInterceptors;
    }

    public Set<String> getBefore() {
        return Collections.emptySet();
    }

    public String getId() {
        return SecurityHeaderCacheInterceptor.class.getName();
    }

    public String getPhase() {
        return "pre-protocol-ending";
    }
}

