/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.ut;

import java.io.Closeable;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.ut.server.PolicyServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.example.contract.doubleit.DoubleItPortType;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class UsernameTokenPolicyTest
extends AbstractBusClientServerTestBase {
    static final String PORT = UsernameTokenPolicyTest.allocatePort(PolicyServer.class);
    private static final String NAMESPACE = "http://www.example.org/contract/DoubleIt";
    private static final QName SERVICE_QNAME = new QName("http://www.example.org/contract/DoubleIt", "DoubleItService");

    @BeforeClass
    public static void startServers() throws Exception {
        UsernameTokenPolicyTest.assertTrue((String)"Server failed to launch", (boolean)UsernameTokenPolicyTest.launchServer(PolicyServer.class, (boolean)true));
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        UsernameTokenPolicyTest.stopAllServers();
    }

    @Test
    public void testSupportingToken() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = UsernameTokenPolicyTest.class.getResource("client/policy-client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = UsernameTokenPolicyTest.class.getResource("DoubleItUtPolicy.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSupportingTokenPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        port.doubleIt(25);
        portQName = new QName(NAMESPACE, "DoubleItSupportingTokenPort2");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        try {
            port.doubleIt(25);
            UsernameTokenPolicyTest.fail((String)"Failure expected on not sending a UsernameToken Supporting Token");
        }
        catch (SOAPFaultException ex) {
            String error = "These policy alternatives can not be satisfied";
            UsernameTokenPolicyTest.assertTrue((boolean)ex.getMessage().contains(error));
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testPlaintextPassword() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = UsernameTokenPolicyTest.class.getResource("client/policy-client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = UsernameTokenPolicyTest.class.getResource("DoubleItUtPolicy.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItPlaintextPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        port.doubleIt(25);
        portQName = new QName(NAMESPACE, "DoubleItPlaintextPort2");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        try {
            port.doubleIt(25);
            UsernameTokenPolicyTest.fail((String)"Failure expected on a hashed password");
        }
        catch (SOAPFaultException ex) {
            String error = "These policy alternatives can not be satisfied";
            UsernameTokenPolicyTest.assertTrue((boolean)ex.getMessage().contains(error));
        }
        portQName = new QName(NAMESPACE, "DoubleItPlaintextPort3");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        try {
            port.doubleIt(25);
            UsernameTokenPolicyTest.fail((String)"Failure expected on not sending a password");
        }
        catch (SOAPFaultException ex) {
            // empty catch block
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testHashPassword() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = UsernameTokenPolicyTest.class.getResource("client/policy-client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = UsernameTokenPolicyTest.class.getResource("DoubleItUtPolicy.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItHashPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        port.doubleIt(25);
        portQName = new QName(NAMESPACE, "DoubleItHashPort2");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        try {
            port.doubleIt(25);
            UsernameTokenPolicyTest.fail((String)"Failure expected on a plaintext password");
        }
        catch (SOAPFaultException ex) {
            String error = "These policy alternatives can not be satisfied";
            UsernameTokenPolicyTest.assertTrue((boolean)ex.getMessage().contains(error));
        }
        portQName = new QName(NAMESPACE, "DoubleItHashPort3");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        try {
            port.doubleIt(25);
            UsernameTokenPolicyTest.fail((String)"Failure expected on not sending a password");
        }
        catch (SOAPFaultException ex) {
            // empty catch block
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testCreated() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = UsernameTokenPolicyTest.class.getResource("client/policy-client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = UsernameTokenPolicyTest.class.getResource("DoubleItUtPolicy.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItCreatedPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        port.doubleIt(25);
        portQName = new QName(NAMESPACE, "DoubleItCreatedPort2");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        try {
            port.doubleIt(25);
            UsernameTokenPolicyTest.fail((String)"Failure expected on not sending a Created element");
        }
        catch (SOAPFaultException ex) {
            String error = "These policy alternatives can not be satisfied";
            UsernameTokenPolicyTest.assertTrue((boolean)ex.getMessage().contains(error));
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testNonce() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = UsernameTokenPolicyTest.class.getResource("client/policy-client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = UsernameTokenPolicyTest.class.getResource("DoubleItUtPolicy.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItNoncePort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        port.doubleIt(25);
        portQName = new QName(NAMESPACE, "DoubleItNoncePort2");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        try {
            port.doubleIt(25);
            UsernameTokenPolicyTest.fail((String)"Failure expected on not sending a Nonce element");
        }
        catch (SOAPFaultException ex) {
            String error = "These policy alternatives can not be satisfied";
            UsernameTokenPolicyTest.assertTrue((boolean)ex.getMessage().contains(error));
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }
}

