/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.wssec10;

import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.wssec10.server.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import wssec.wssec10.IPingService;
import wssec.wssec10.PingService;

public class WSSecurity10Test
extends AbstractBusClientServerTestBase {
    static final String PORT = WSSecurity10Test.allocatePort(Server.class);
    static final String SSL_PORT = WSSecurity10Test.allocatePort(Server.class, (int)1);
    private static final String INPUT = "foo";
    private static boolean unrestrictedPoliciesInstalled = SecurityTestUtil.checkUnrestrictedPoliciesInstalled();

    @BeforeClass
    public static void startServers() throws Exception {
        WSSecurity10Test.assertTrue((String)"Server failed to launch", (boolean)WSSecurity10Test.launchServer(Server.class, (boolean)true));
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        WSSecurity10Test.stopAllServers();
    }

    @Test
    public void testClientServer() {
        String[] argv = new String[]{"UserName", "UserNameOverTransport", "MutualCertificate10SignEncrypt", "MutualCertificate10SignEncryptRsa15TripleDes"};
        Bus bus = null;
        bus = unrestrictedPoliciesInstalled ? new SpringBusFactory().createBus("org/apache/cxf/systest/ws/wssec10/client/client.xml") : new SpringBusFactory().createBus("org/apache/cxf/systest/ws/wssec10/client/client_restricted.xml");
        BusFactory.setDefaultBus((Bus)bus);
        BusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdlLocation = null;
        for (String portPrefix : argv) {
            PingService svc = null;
            wsdlLocation = WSSecurity10Test.getWsdlLocation(portPrefix);
            svc = new PingService(wsdlLocation);
            IPingService port = (IPingService)svc.getPort(new QName("http://WSSec/wssec10", portPrefix + "_IPingService"), IPingService.class);
            Client cl = ClientProxy.getClient((Object)port);
            HTTPConduit http = (HTTPConduit)cl.getConduit();
            HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
            httpClientPolicy.setConnectionTimeout(0L);
            httpClientPolicy.setReceiveTimeout(0L);
            http.setClient(httpClientPolicy);
            String output = port.echo(INPUT);
            WSSecurity10Test.assertEquals((Object)INPUT, (Object)output);
            cl.destroy();
        }
        bus.shutdown(true);
    }

    private static URL getWsdlLocation(String portPrefix) {
        try {
            if ("UserNameOverTransport".equals(portPrefix)) {
                return new URL("https://localhost:" + SSL_PORT + "/" + portPrefix + "?wsdl");
            }
            if ("UserName".equals(portPrefix)) {
                return new URL("http://localhost:" + PORT + "/" + portPrefix + "?wsdl");
            }
            if ("MutualCertificate10SignEncrypt".equals(portPrefix)) {
                return new URL("http://localhost:" + PORT + "/" + portPrefix + "?wsdl");
            }
            if ("MutualCertificate10SignEncryptRsa15TripleDes".equals(portPrefix)) {
                return new URL("http://localhost:" + PORT + "/" + portPrefix + "?wsdl");
            }
        }
        catch (MalformedURLException mue) {
            return null;
        }
        return null;
    }
}

