/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.algsuite;

import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.systest.ws.algsuite.Server;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.example.contract.doubleit.DoubleItPortType;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class AlgorithmSuiteTest
extends AbstractBusClientServerTestBase {
    static final String PORT = AlgorithmSuiteTest.allocatePort(Server.class);
    private static final String NAMESPACE = "http://www.example.org/contract/DoubleIt";
    private static final QName SERVICE_QNAME = new QName("http://www.example.org/contract/DoubleIt", "DoubleItService");

    @BeforeClass
    public static void startServers() throws Exception {
        AlgorithmSuiteTest.assertTrue((String)"Server failed to launch", (boolean)AlgorithmSuiteTest.launchServer(Server.class, (boolean)true));
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        AlgorithmSuiteTest.stopAllServers();
    }

    @Test
    public void testSecurityPolicy() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = AlgorithmSuiteTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = AlgorithmSuiteTest.class.getResource("DoubleItAlgSuite.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSymmetric128Port");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        port.doubleIt(25);
        SecurityTestUtil.enableStreaming(port);
        port.doubleIt(25);
        portQName = new QName(NAMESPACE, "DoubleItSymmetric128Port2");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        try {
            port.doubleIt(25);
            AlgorithmSuiteTest.fail((String)"Failure expected on Rsa15 AlgorithmSuite");
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            SecurityTestUtil.enableStreaming(port);
            port.doubleIt(25);
            AlgorithmSuiteTest.fail((String)"Failure expected on Rsa15 AlgorithmSuite");
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (SecurityTestUtil.checkUnrestrictedPoliciesInstalled()) {
            portQName = new QName(NAMESPACE, "DoubleItSymmetric128Port3");
            port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
            this.updateAddressPort(port, PORT);
            try {
                port.doubleIt(25);
                AlgorithmSuiteTest.fail((String)"Failure expected on Basic256 AlgorithmSuite");
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                SecurityTestUtil.enableStreaming(port);
                port.doubleIt(25);
                AlgorithmSuiteTest.fail((String)"Failure expected on Basic256 AlgorithmSuite");
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        bus.shutdown(true);
    }

    @Test
    public void testCombinedPolicy() throws Exception {
        if (!SecurityTestUtil.checkUnrestrictedPoliciesInstalled()) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = AlgorithmSuiteTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = AlgorithmSuiteTest.class.getResource("DoubleItAlgSuite.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSymmetricCombinedPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        port.doubleIt(25);
        SecurityTestUtil.enableStreaming(port);
        port.doubleIt(25);
        bus.shutdown(true);
    }

    @Test
    public void testManualConfigurationEncryption() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = AlgorithmSuiteTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = AlgorithmSuiteTest.class.getResource("DoubleItAlgSuite.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItEncryptionOAEPPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        port.doubleIt(25);
        portQName = new QName(NAMESPACE, "DoubleItEncryptionOAEPPort2");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        try {
            port.doubleIt(25);
            AlgorithmSuiteTest.fail((String)"Failure expected on Rsa15");
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (SecurityTestUtil.checkUnrestrictedPoliciesInstalled()) {
            portQName = new QName(NAMESPACE, "DoubleItEncryptionOAEPPort3");
            port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
            this.updateAddressPort(port, PORT);
            try {
                port.doubleIt(25);
                AlgorithmSuiteTest.fail((String)"Failure expected on AES-256");
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        bus.shutdown(true);
    }

    @Test
    public void testManualConfigurationSignature() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = AlgorithmSuiteTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = AlgorithmSuiteTest.class.getResource("DoubleItAlgSuite.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSignaturePort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        port.doubleIt(25);
        if (SecurityTestUtil.checkUnrestrictedPoliciesInstalled()) {
            portQName = new QName(NAMESPACE, "DoubleItSignaturePort2");
            port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
            this.updateAddressPort(port, PORT);
            try {
                port.doubleIt(25);
                AlgorithmSuiteTest.fail((String)"Failure expected on SHA-256");
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        bus.shutdown(true);
    }
}

