/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.cache;

import java.io.Closeable;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.systest.ws.cache.Server;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.common.TestParam;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.example.contract.doubleit.DoubleItPortType;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CachingTest
extends AbstractBusClientServerTestBase {
    public static final String PORT = CachingTest.allocatePort(Server.class);
    private static final String NAMESPACE = "http://www.example.org/contract/DoubleIt";
    private static final QName SERVICE_QNAME = new QName("http://www.example.org/contract/DoubleIt", "DoubleItService");
    final TestParam test;

    public CachingTest(TestParam type) {
        this.test = type;
    }

    @BeforeClass
    public static void startServers() throws Exception {
        CachingTest.assertTrue((String)"Server failed to launch", (boolean)CachingTest.launchServer(Server.class, (boolean)true));
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<TestParam[]> data() {
        return Arrays.asList({new TestParam(PORT, false)}, {new TestParam(PORT, true)});
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        CachingTest.stopAllServers();
    }

    @Test
    public void testSymmetric() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = CachingTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = CachingTest.class.getResource("DoubleItCache.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItCacheSymmetricPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        port.doubleIt(25);
        Client client = ClientProxy.getClient((Object)port);
        TokenStore tokenStore = (TokenStore)client.getEndpoint().getEndpointInfo().getProperty("org.apache.cxf.ws.security.tokenstore.TokenStore");
        CachingTest.assertNotNull((Object)tokenStore);
        CachingTest.assertEquals((long)2L, (long)tokenStore.getTokenIdentifiers().size());
        DoubleItPortType port2 = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port2, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port2);
        }
        port2.doubleIt(35);
        client = ClientProxy.getClient((Object)port2);
        tokenStore = (TokenStore)client.getEndpoint().getEndpointInfo().getProperty("org.apache.cxf.ws.security.tokenstore.TokenStore");
        CachingTest.assertNotNull((Object)tokenStore);
        CachingTest.assertEquals((long)4L, (long)tokenStore.getTokenIdentifiers().size());
        ((Closeable)port).close();
        CachingTest.assertEquals((long)4L, (long)tokenStore.getTokenIdentifiers().size());
        ((Closeable)port2).close();
        CachingTest.assertNull((Object)tokenStore.getTokenIdentifiers());
        bus.shutdown(true);
    }

    @Test
    public void testCachePerProxySymmetric() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = CachingTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = CachingTest.class.getResource("DoubleItCache.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItCachePerProxySymmetricPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        ((BindingProvider)port).getRequestContext().put("ws-security.cache.identifier", "proxy1");
        ((BindingProvider)port).getRequestContext().put("ws-security.cache.config.file", "per-proxy-cache.xml");
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        port.doubleIt(25);
        Client client = ClientProxy.getClient((Object)port);
        TokenStore tokenStore = (TokenStore)client.getEndpoint().getEndpointInfo().getProperty("org.apache.cxf.ws.security.tokenstore.TokenStore");
        CachingTest.assertNotNull((Object)tokenStore);
        CachingTest.assertEquals((long)2L, (long)tokenStore.getTokenIdentifiers().size());
        DoubleItPortType port2 = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port2, this.test.getPort());
        ((BindingProvider)port2).getRequestContext().put("ws-security.cache.identifier", "proxy2");
        ((BindingProvider)port2).getRequestContext().put("ws-security.cache.config.file", "per-proxy-cache.xml");
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port2);
        }
        port2.doubleIt(35);
        client = ClientProxy.getClient((Object)port2);
        tokenStore = (TokenStore)client.getEndpoint().getEndpointInfo().getProperty("org.apache.cxf.ws.security.tokenstore.TokenStore");
        CachingTest.assertNotNull((Object)tokenStore);
        CachingTest.assertEquals((long)2L, (long)tokenStore.getTokenIdentifiers().size());
        ((Closeable)port).close();
        ((Closeable)port2).close();
        bus.shutdown(true);
    }
}

