/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.fault;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.saaj.SAAJUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptor;
import org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JOutInterceptor;
import org.w3c.dom.Element;

public abstract class AbstractModifyRequestInterceptor
implements PhaseInterceptor<SoapMessage> {
    private static final QName SEC_HEADER = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security", "wsse");
    private Set<String> afterInterceptors = new HashSet<String>();

    public AbstractModifyRequestInterceptor() {
        this.getAfter().add(PolicyBasedWSS4JOutInterceptor.class.getName());
    }

    public void handleMessage(SoapMessage mc) throws Fault {
        SOAPMessage saaj = (SOAPMessage)mc.getContent(SOAPMessage.class);
        try {
            Iterator secHeadersIterator = SAAJUtils.getHeader((SOAPMessage)saaj).getChildElements(SEC_HEADER);
            if (secHeadersIterator.hasNext()) {
                SOAPHeaderElement securityHeader = (SOAPHeaderElement)secHeadersIterator.next();
                this.modifySecurityHeader((Element)securityHeader);
            }
            this.modifySOAPBody((Element)SAAJUtils.getBody((SOAPMessage)saaj));
        }
        catch (SOAPException ex) {
            throw new Fault((Throwable)ex);
        }
    }

    public abstract void modifySecurityHeader(Element var1);

    public abstract void modifySOAPBody(Element var1);

    public void clear() {
    }

    public void handleFault(SoapMessage arg0) {
    }

    public Collection<PhaseInterceptor<? extends Message>> getAdditionalInterceptors() {
        return null;
    }

    public Set<String> getAfter() {
        return this.afterInterceptors;
    }

    public Set<String> getBefore() {
        return Collections.emptySet();
    }

    public String getId() {
        return AbstractModifyRequestInterceptor.class.getName();
    }

    public String getPhase() {
        return "pre-protocol-ending";
    }
}

