/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.fault;

import java.io.Closeable;
import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.jaxws.DispatchImpl;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.fault.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.example.contract.doubleit.DoubleItPortType;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FaultTest
extends AbstractBusClientServerTestBase {
    static final String PORT = FaultTest.allocatePort(Server.class);
    private static final String NAMESPACE = "http://www.example.org/contract/DoubleIt";
    private static final QName SERVICE_QNAME = new QName("http://www.example.org/contract/DoubleIt", "DoubleItService");

    @BeforeClass
    public static void startServers() throws Exception {
        FaultTest.assertTrue((String)"Server failed to launch", (boolean)FaultTest.launchServer(Server.class, (boolean)true));
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        FaultTest.stopAllServers();
    }

    @Test
    public void testSoap11() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = FaultTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = FaultTest.class.getResource("DoubleItFault.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSoap11Port");
        DoubleItPortType utPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(utPort, PORT);
        ((BindingProvider)utPort).getRequestContext().put("ws-security.username", "alice");
        utPort.doubleIt(25);
        ((BindingProvider)utPort).getRequestContext().put("ws-security.username", "bob");
        ((BindingProvider)utPort).getRequestContext().put("ws-security.password", "password");
        try {
            utPort.doubleIt(25);
            FaultTest.fail((String)"Expected failure on bob");
        }
        catch (Exception ex) {
            FaultTest.assertTrue((boolean)ex.getMessage().contains("This is a fault"));
        }
        ((Closeable)utPort).close();
        bus.shutdown(true);
    }

    @Test
    public void testSoap12() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = FaultTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = FaultTest.class.getResource("DoubleItFault.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSoap12Port");
        DoubleItPortType utPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(utPort, PORT);
        ((BindingProvider)utPort).getRequestContext().put("ws-security.username", "alice");
        utPort.doubleIt(25);
        ((BindingProvider)utPort).getRequestContext().put("ws-security.username", "bob");
        ((BindingProvider)utPort).getRequestContext().put("ws-security.password", "password");
        try {
            utPort.doubleIt(25);
            FaultTest.fail((String)"Expected failure on bob");
        }
        catch (Exception ex) {
            FaultTest.assertTrue((boolean)ex.getMessage().contains("This is a fault"));
        }
        ((Closeable)utPort).close();
        bus.shutdown(true);
    }

    @Test
    public void testSoap12Dispatch() throws Exception {
        this.createBus();
        BusFactory.setDefaultBus((Bus)this.getBus());
        URL wsdl = FaultTest.class.getResource("DoubleItFault.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSoap12DispatchPort");
        Dispatch dispatch = service.createDispatch(portQName, DOMSource.class, Service.Mode.PAYLOAD);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document requestDoc = db.newDocument();
        Element root = requestDoc.createElementNS("http://www.example.org/schema/DoubleIt", "ns2:DoubleIt");
        root.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ns2", "http://www.example.org/schema/DoubleIt");
        Element number = requestDoc.createElementNS(null, "numberToDouble");
        number.setTextContent("25");
        root.appendChild(number);
        requestDoc.appendChild(root);
        DOMSource request = new DOMSource(requestDoc);
        Client client = ((DispatchImpl)dispatch).getClient();
        client.getRequestContext().put("ws-security.callback-handler", "org.apache.cxf.systest.ws.common.KeystorePasswordCallback");
        client.getRequestContext().put("ws-security.encryption.properties", "bob.properties");
        client.getRequestContext().put("ws-security.encryption.username", "bob");
        this.updateAddressPort(dispatch, PORT);
        client.getRequestContext().put("ws-security.username", "alice");
        DOMSource response = (DOMSource)dispatch.invoke((Object)request);
        FaultTest.assertNotNull((Object)response);
        client.getRequestContext().put("ws-security.username", "bob");
        client.getRequestContext().put("ws-security.password", "password");
        try {
            dispatch.invoke((Object)request);
            FaultTest.fail((String)"Expected failure on bob");
        }
        catch (Exception ex) {
            FaultTest.assertTrue((boolean)ex.getMessage().contains("This is a fault"));
        }
        client.destroy();
    }
}

