/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.gcm;

import java.io.Closeable;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.common.TestParam;
import org.apache.cxf.systest.ws.gcm.Server;
import org.apache.cxf.systest.ws.gcm.StaxServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.example.contract.doubleit.DoubleItPortType;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class GCMTest
extends AbstractBusClientServerTestBase {
    static final String PORT = GCMTest.allocatePort(Server.class);
    static final String STAX_PORT = GCMTest.allocatePort(StaxServer.class);
    private static final String NAMESPACE = "http://www.example.org/contract/DoubleIt";
    private static final QName SERVICE_QNAME = new QName("http://www.example.org/contract/DoubleIt", "DoubleItService");
    private static boolean unrestrictedPoliciesInstalled = SecurityTestUtil.checkUnrestrictedPoliciesInstalled();
    final TestParam test;

    public GCMTest(TestParam type) {
        this.test = type;
    }

    @BeforeClass
    public static void startServers() throws Exception {
        GCMTest.assertTrue((String)"Server failed to launch", (boolean)GCMTest.launchServer(Server.class, (boolean)true));
        GCMTest.assertTrue((String)"Server failed to launch", (boolean)GCMTest.launchServer(StaxServer.class, (boolean)true));
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<TestParam[]> data() {
        return Arrays.asList({new TestParam(PORT, false)}, {new TestParam(PORT, true)}, {new TestParam(STAX_PORT, false)}, {new TestParam(STAX_PORT, true)});
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        GCMTest.stopAllServers();
    }

    @Test
    public void testAESGCM128() throws Exception {
        if ("IBM Corporation".equals(System.getProperty("java.vendor")) && System.getProperty("java.version") != null && System.getProperty("java.version").startsWith("1.7")) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = GCMTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = GCMTest.class.getResource("DoubleItGCM.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItGCM128Port");
        DoubleItPortType gcmPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(gcmPort, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(gcmPort);
        }
        gcmPort.doubleIt(25);
        ((Closeable)gcmPort).close();
        bus.shutdown(true);
    }

    @Test
    public void testAESGCM192() throws Exception {
        if (!unrestrictedPoliciesInstalled) {
            return;
        }
        if ("IBM Corporation".equals(System.getProperty("java.vendor")) && System.getProperty("java.version") != null && System.getProperty("java.version").startsWith("1.7")) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = GCMTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = GCMTest.class.getResource("DoubleItGCM.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItGCM192Port");
        DoubleItPortType gcmPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(gcmPort, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(gcmPort);
        }
        gcmPort.doubleIt(25);
        ((Closeable)gcmPort).close();
        bus.shutdown(true);
    }

    @Test
    public void testAESGCM256() throws Exception {
        if (!unrestrictedPoliciesInstalled) {
            return;
        }
        if ("IBM Corporation".equals(System.getProperty("java.vendor")) && System.getProperty("java.version") != null && System.getProperty("java.version").startsWith("1.7")) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = GCMTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = GCMTest.class.getResource("DoubleItGCM.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItGCM256Port");
        DoubleItPortType gcmPort = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(gcmPort, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(gcmPort);
        }
        gcmPort.doubleIt(25);
        ((Closeable)gcmPort).close();
        bus.shutdown(true);
    }
}

