/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.parts;

import java.io.Closeable;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.common.TestParam;
import org.apache.cxf.systest.ws.parts.Server;
import org.apache.cxf.systest.ws.parts.StaxServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.example.contract.doubleit.DoubleItPortType;
import org.example.contract.doubleit.DoubleItSwaPortType;
import org.example.schema.doubleit.DoubleIt3;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PartsTest
extends AbstractBusClientServerTestBase {
    static final String PORT = PartsTest.allocatePort(Server.class);
    static final String STAX_PORT = PartsTest.allocatePort(StaxServer.class);
    private static final String NAMESPACE = "http://www.example.org/contract/DoubleIt";
    private static final QName SERVICE_QNAME = new QName("http://www.example.org/contract/DoubleIt", "DoubleItService");
    final TestParam test;

    public PartsTest(TestParam type) {
        this.test = type;
    }

    @BeforeClass
    public static void startServers() throws Exception {
        PartsTest.assertTrue((String)"Server failed to launch", (boolean)PartsTest.launchServer(Server.class, (boolean)true));
        PartsTest.assertTrue((String)"Server failed to launch", (boolean)PartsTest.launchServer(StaxServer.class, (boolean)true));
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<TestParam[]> data() {
        return Arrays.asList({new TestParam(PORT, false)}, {new TestParam(PORT, true)}, {new TestParam(STAX_PORT, false)}, {new TestParam(STAX_PORT, true)});
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        PartsTest.stopAllServers();
    }

    @Test
    public void testSOAPFaultError() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = PartsTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = PartsTest.class.getResource("DoubleItParts.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItRequiredPartsPort2");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        try {
            port.doubleIt(25);
            PartsTest.fail((String)"Failure expected on a required header which isn't present");
        }
        catch (SOAPFaultException ex) {
            String error = "RequiredParts: No header element";
            PartsTest.assertTrue((ex.getMessage().contains(error) || ex.getMessage().contains("ToTo must be present") ? 1 : 0) != 0);
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testRequiredParts() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = PartsTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = PartsTest.class.getResource("DoubleItParts.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItRequiredPartsPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        port.doubleIt(25);
        portQName = new QName(NAMESPACE, "DoubleItRequiredPartsPort2");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        try {
            port.doubleIt(25);
            PartsTest.fail((String)"Failure expected on a required header which isn't present");
        }
        catch (SOAPFaultException ex) {
            String error = "RequiredParts: No header element";
            PartsTest.assertTrue((ex.getMessage().contains(error) || ex.getMessage().contains("ToTo") ? 1 : 0) != 0);
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testRequiredElements() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = PartsTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = PartsTest.class.getResource("DoubleItParts.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItRequiredElementsPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        port.doubleIt(25);
        portQName = new QName(NAMESPACE, "DoubleItRequiredElementsPort2");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        try {
            port.doubleIt(25);
            PartsTest.fail((String)"Failure expected on a required header which isn't present");
        }
        catch (SOAPFaultException ex) {
            String error = "RequiredElements: No header element";
            PartsTest.assertTrue((ex.getMessage().contains(error) || ex.getMessage().contains("ToTo must be present") ? 1 : 0) != 0);
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSignedParts() throws Exception {
        String error;
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = PartsTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = PartsTest.class.getResource("DoubleItParts.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSignedPartsPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        port.doubleIt(25);
        portQName = new QName(NAMESPACE, "DoubleItSignedPartsPort2");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        try {
            port.doubleIt(25);
            PartsTest.fail((String)"Failure expected on a body which isn't signed");
        }
        catch (SOAPFaultException ex) {
            error = "SignedParts";
            PartsTest.assertTrue((ex.getMessage().contains(error) || ex.getMessage().contains("Body must be signed") ? 1 : 0) != 0);
        }
        portQName = new QName(NAMESPACE, "DoubleItSignedPartsPort3");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        try {
            port.doubleIt(25);
            PartsTest.fail((String)"Failure expected on a header which isn't signed");
        }
        catch (SOAPFaultException ex) {
            error = "SignedParts";
            PartsTest.assertTrue((ex.getMessage().contains(error) || ex.getMessage().contains("To must be signed") ? 1 : 0) != 0);
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSignedElements() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = PartsTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = PartsTest.class.getResource("DoubleItParts.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSignedElementsPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        port.doubleIt(25);
        portQName = new QName(NAMESPACE, "DoubleItSignedElementsPort2");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        try {
            port.doubleIt(25);
            PartsTest.fail((String)"Failure expected on a header which isn't signed");
        }
        catch (SOAPFaultException ex) {
            String error = "SignedElements";
            PartsTest.assertTrue((ex.getMessage().contains(error) || ex.getMessage().contains("To must be signed") ? 1 : 0) != 0);
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testEncryptedParts() throws Exception {
        String error;
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = PartsTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = PartsTest.class.getResource("DoubleItParts.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItEncryptedPartsPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        port.doubleIt(25);
        portQName = new QName(NAMESPACE, "DoubleItEncryptedPartsPort2");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        try {
            port.doubleIt(25);
            PartsTest.fail((String)"Failure expected on a body which isn't encrypted");
        }
        catch (SOAPFaultException ex) {
            error = "EncryptedParts";
            PartsTest.assertTrue((ex.getMessage().contains(error) || ex.getMessage().contains("Body must be encrypted") ? 1 : 0) != 0);
        }
        portQName = new QName(NAMESPACE, "DoubleItEncryptedPartsPort3");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        try {
            port.doubleIt(25);
            PartsTest.fail((String)"Failure expected on a header which isn't encrypted");
        }
        catch (SOAPFaultException ex) {
            error = "EncryptedParts";
            PartsTest.assertTrue((ex.getMessage().contains(error) || ex.getMessage().contains("To must be encrypted") ? 1 : 0) != 0);
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testEncryptedElements() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = PartsTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = PartsTest.class.getResource("DoubleItParts.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItEncryptedElementsPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        port.doubleIt(25);
        portQName = new QName(NAMESPACE, "DoubleItEncryptedElementsPort2");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        try {
            port.doubleIt(25);
            PartsTest.fail((String)"Failure expected on a header which isn't encrypted");
        }
        catch (SOAPFaultException ex) {
            String error = "EncryptedElements";
            PartsTest.assertTrue((ex.getMessage().contains(error) || ex.getMessage().contains("To must be encrypted") ? 1 : 0) != 0);
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testMultipleEncryptedElements() throws Exception {
        if (this.test.isStreaming() || STAX_PORT.equals(this.test.getPort())) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = PartsTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = PartsTest.class.getResource("DoubleItParts.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItEncryptedElementsPort3");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        port.doubleIt(25);
        portQName = new QName(NAMESPACE, "DoubleItEncryptedElementsPort2");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        try {
            port.doubleIt(25);
            PartsTest.fail((String)"Failure expected on a header which isn't encrypted");
        }
        catch (SOAPFaultException ex) {
            String error = "EncryptedElements";
            PartsTest.assertTrue((ex.getMessage().contains(error) || ex.getMessage().contains("To must be encrypted") ? 1 : 0) != 0);
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testContentEncryptedElements() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = PartsTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = PartsTest.class.getResource("DoubleItParts.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItContentEncryptedElementsPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        port.doubleIt(25);
        portQName = new QName(NAMESPACE, "DoubleItContentEncryptedElementsPort2");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        try {
            port.doubleIt(25);
            PartsTest.fail((String)"Failure expected on a header which isn't encrypted");
        }
        catch (SOAPFaultException ex) {
            String error = "EncryptedElements";
            PartsTest.assertTrue((ex.getMessage().contains(error) || ex.getMessage().contains("To must be encrypted") ? 1 : 0) != 0);
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSignedAttachments() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = PartsTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = PartsTest.class.getResource("DoubleItParts.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSignedAttachmentsPort");
        DoubleItSwaPortType port = (DoubleItSwaPortType)service.getPort(portQName, DoubleItSwaPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            PartsTest.enableStreaming(port);
        }
        DoubleIt3 doubleIt = new DoubleIt3();
        doubleIt.setNumberToDouble(25);
        port.doubleIt3(doubleIt, "12345".getBytes());
        portQName = new QName(NAMESPACE, "DoubleItSignedAttachmentsPort2");
        port = (DoubleItSwaPortType)service.getPort(portQName, DoubleItSwaPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            PartsTest.enableStreaming(port);
        }
        try {
            doubleIt = new DoubleIt3();
            doubleIt.setNumberToDouble(25);
            port.doubleIt3(doubleIt, "12345".getBytes());
            PartsTest.fail((String)"Failure expected on an attachment which isn't signed");
        }
        catch (SOAPFaultException ex) {
            String error = "SignedParts";
            PartsTest.assertTrue((boolean)ex.getMessage().contains(error));
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testEncryptedAttachments() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = PartsTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = PartsTest.class.getResource("DoubleItParts.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItEncryptedAttachmentsPort");
        DoubleItSwaPortType port = (DoubleItSwaPortType)service.getPort(portQName, DoubleItSwaPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            PartsTest.enableStreaming(port);
        }
        DoubleIt3 doubleIt = new DoubleIt3();
        doubleIt.setNumberToDouble(25);
        port.doubleIt3(doubleIt, "12345".getBytes());
        portQName = new QName(NAMESPACE, "DoubleItEncryptedAttachmentsPort2");
        port = (DoubleItSwaPortType)service.getPort(portQName, DoubleItSwaPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            PartsTest.enableStreaming(port);
        }
        try {
            doubleIt = new DoubleIt3();
            doubleIt.setNumberToDouble(25);
            port.doubleIt3(doubleIt, "12345".getBytes());
            PartsTest.fail((String)"Failure expected on an attachment which isn't encrypted");
        }
        catch (SOAPFaultException ex) {
            String error = "EncryptedParts";
            PartsTest.assertTrue((boolean)ex.getMessage().contains(error));
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    static void enableStreaming(DoubleItSwaPortType port) {
        ((BindingProvider)port).getRequestContext().put("ws-security.enable.streaming", "true");
        ((BindingProvider)port).getResponseContext().put("ws-security.enable.streaming", "true");
    }
}

