/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.tokens;

import java.io.Closeable;
import java.net.URL;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.tokens.BSTServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.wss4j.dom.message.token.BinarySecurity;
import org.example.contract.doubleit.DoubleItPortType;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Document;

public class BinarySecurityTokenTest
extends AbstractBusClientServerTestBase {
    static final String PORT = BinarySecurityTokenTest.allocatePort(BSTServer.class);
    private static final String NAMESPACE = "http://www.example.org/contract/DoubleIt";
    private static final QName SERVICE_QNAME = new QName("http://www.example.org/contract/DoubleIt", "DoubleItService");

    @BeforeClass
    public static void startServers() throws Exception {
        BinarySecurityTokenTest.assertTrue((String)"Server failed to launch", (boolean)BinarySecurityTokenTest.launchServer(BSTServer.class, (boolean)true));
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        BinarySecurityTokenTest.stopAllServers();
    }

    @Test
    public void testBinarySecurityToken() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = BinarySecurityTokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = BinarySecurityTokenTest.class.getResource("DoubleItTokens.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItBinarySecurityTokenPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        SecurityToken securityToken = new SecurityToken();
        securityToken.setId("_" + UUID.randomUUID().toString());
        Document doc = DOMUtils.newDocument();
        BinarySecurity binarySecurity = new BinarySecurity(doc);
        binarySecurity.setValueType("http://custom-value-type");
        binarySecurity.setToken("This is a token".getBytes());
        securityToken.setToken(binarySecurity.getElement());
        ((BindingProvider)port).getRequestContext().put("ws-security.token", securityToken);
        port.doubleIt(25);
        ((Closeable)port).close();
        bus.shutdown(true);
    }
}

