/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.tokens;

import java.io.Closeable;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.common.TestParam;
import org.apache.cxf.systest.ws.tokens.Server;
import org.apache.cxf.systest.ws.tokens.StaxServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.example.contract.doubleit.DoubleItPortType;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SupportingTokenTest
extends AbstractBusClientServerTestBase {
    static final String PORT = SupportingTokenTest.allocatePort(Server.class);
    static final String STAX_PORT = SupportingTokenTest.allocatePort(StaxServer.class);
    private static final String NAMESPACE = "http://www.example.org/contract/DoubleIt";
    private static final QName SERVICE_QNAME = new QName("http://www.example.org/contract/DoubleIt", "DoubleItService");
    final TestParam test;

    public SupportingTokenTest(TestParam type) {
        this.test = type;
    }

    @BeforeClass
    public static void startServers() throws Exception {
        SupportingTokenTest.assertTrue((String)"Server failed to launch", (boolean)SupportingTokenTest.launchServer(Server.class, (boolean)true));
        SupportingTokenTest.assertTrue((String)"Server failed to launch", (boolean)SupportingTokenTest.launchServer(StaxServer.class, (boolean)true));
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<TestParam[]> data() {
        return Arrays.asList({new TestParam(PORT, false)}, {new TestParam(PORT, true)}, {new TestParam(STAX_PORT, false)}, {new TestParam(STAX_PORT, true)});
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        SupportingTokenTest.stopAllServers();
    }

    @Test
    public void testSignedSupporting() throws Exception {
        String error;
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SupportingTokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SupportingTokenTest.class.getResource("DoubleItTokens.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSignedSupportingPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        port.doubleIt(25);
        portQName = new QName(NAMESPACE, "DoubleItSignedSupportingPort2");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        try {
            port.doubleIt(25);
            SupportingTokenTest.fail((String)"Failure expected on not signing the UsernameToken");
        }
        catch (SOAPFaultException ex) {
            error = "The received token does not match the signed supporting token requirement";
            SupportingTokenTest.assertTrue((ex.getMessage().contains(error) || ex.getMessage().contains("UsernameToken not satisfied") ? 1 : 0) != 0);
        }
        portQName = new QName(NAMESPACE, "DoubleItSignedSupportingPort3");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        try {
            port.doubleIt(25);
            SupportingTokenTest.fail((String)"Failure expected on not signing the UsernameToken");
        }
        catch (SOAPFaultException ex) {
            error = "The received token does not match the signed supporting token requirement";
            SupportingTokenTest.assertTrue((ex.getMessage().contains(error) || ex.getMessage().contains("UsernameToken not satisfied") ? 1 : 0) != 0);
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testEncryptedSupporting() throws Exception {
        String error;
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SupportingTokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SupportingTokenTest.class.getResource("DoubleItTokens.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItEncryptedSupportingPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        port.doubleIt(25);
        portQName = new QName(NAMESPACE, "DoubleItEncryptedSupportingPort2");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        try {
            port.doubleIt(25);
            SupportingTokenTest.fail((String)"Failure expected on not encrypting the UsernameToken");
        }
        catch (SOAPFaultException ex) {
            error = "The received token does not match the encrypted supporting token requirement";
            SupportingTokenTest.assertTrue((ex.getMessage().contains(error) || ex.getMessage().contains("UsernameToken not satisfied") ? 1 : 0) != 0);
        }
        portQName = new QName(NAMESPACE, "DoubleItEncryptedSupportingPort3");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        try {
            port.doubleIt(25);
            SupportingTokenTest.fail((String)"Failure expected on not encrypting the UsernameToken");
        }
        catch (SOAPFaultException ex) {
            error = "The received token does not match the encrypted supporting token requirement";
            SupportingTokenTest.assertTrue((ex.getMessage().contains(error) || ex.getMessage().contains("UsernameToken not satisfied") ? 1 : 0) != 0);
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSignedEncryptedSupporting() throws Exception {
        String error;
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = SupportingTokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = SupportingTokenTest.class.getResource("DoubleItTokens.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSignedEncryptedSupportingPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        port.doubleIt(25);
        portQName = new QName(NAMESPACE, "DoubleItSignedEncryptedSupportingPort2");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        try {
            port.doubleIt(25);
            SupportingTokenTest.fail((String)"Failure expected on not encrypting the UsernameToken");
        }
        catch (SOAPFaultException ex) {
            error = "The received token does not match the signed encrypted supporting token requirement";
            SupportingTokenTest.assertTrue((ex.getMessage().contains(error) || ex.getMessage().contains("UsernameToken not satisfied") ? 1 : 0) != 0);
        }
        portQName = new QName(NAMESPACE, "DoubleItSignedEncryptedSupportingPort3");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        try {
            port.doubleIt(25);
            SupportingTokenTest.fail((String)"Failure expected on not encrypting the UsernameToken");
        }
        catch (SOAPFaultException ex) {
            error = "The received token does not match the signed encrypted supporting token requirement";
            SupportingTokenTest.assertTrue((ex.getMessage().contains(error) || ex.getMessage().contains("UsernameToken not satisfied") ? 1 : 0) != 0);
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }
}

