/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.wssc;

import java.io.Closeable;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.binding.soap.interceptor.SoapActionInInterceptor;
import org.apache.cxf.binding.soap.interceptor.SoapPreProtocolOutInterceptor;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.wssc.Server;
import org.apache.cxf.systest.ws.wssc.StaxServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.ws.security.trust.STSClient;
import org.apache.cxf.ws.security.trust.STSUtils;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.xmlsoap.ping.Ping;
import wssec.wssc.IPingService;
import wssec.wssc.PingRequest;
import wssec.wssc.PingResponse;
import wssec.wssc.PingService;

@RunWith(value=Parameterized.class)
public class WSSCTest
extends AbstractBusClientServerTestBase {
    static final String PORT = WSSCTest.allocatePort(Server.class);
    static final String PORT2 = WSSCTest.allocatePort(Server.class, (int)2);
    static final String STAX_PORT = WSSCTest.allocatePort(StaxServer.class);
    static final String STAX_PORT2 = WSSCTest.allocatePort(StaxServer.class, (int)2);
    private static final String OUT = "CXF : ping";
    private static PingService svc;
    private static Bus bus;
    final TestParam test;

    public WSSCTest(TestParam type) {
        this.test = type;
    }

    @BeforeClass
    public static void startServers() throws Exception {
        WSSCTest.assertTrue((String)"Server failed to launch", (boolean)WSSCTest.launchServer(Server.class, (boolean)true));
        WSSCTest.assertTrue((String)"Server failed to launch", (boolean)WSSCTest.launchServer(StaxServer.class, (boolean)true));
        bus = new SpringBusFactory().createBus("org/apache/cxf/systest/ws/wssc/client.xml");
        BusFactory.setDefaultBus((Bus)bus);
        BusFactory.setThreadDefaultBus((Bus)bus);
        svc = new PingService();
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<TestParam[]> data() {
        return Arrays.asList({new TestParam("SecureConversation_UserNameOverTransport_IPingService", PORT2, false)}, {new TestParam("SecureConversation_MutualCertificate10SignEncrypt_IPingService", PORT, false)}, {new TestParam("AC_IPingService", PORT, false)}, {new TestParam("ADC_IPingService", PORT, false)}, {new TestParam("ADC-ES_IPingService", PORT, false)}, {new TestParam("_A_IPingService", PORT, false)}, {new TestParam("_AD_IPingService", PORT, false)}, {new TestParam("_AD-ES_IPingService", PORT, false)}, {new TestParam("UXC_IPingService", PORT, false)}, {new TestParam("UXDC_IPingService", PORT, false)}, {new TestParam("UXDC-SEES_IPingService", PORT, false)}, {new TestParam("_UX_IPingService", PORT, false)}, {new TestParam("_UXD_IPingService", PORT, false)}, {new TestParam("_UXD-SEES_IPingService", PORT, false)}, {new TestParam("XC_IPingService", PORT, false)}, {new TestParam("XDC_IPingService", PORT, false)}, {new TestParam("XDC_IPingService1", PORT, false)}, {new TestParam("XDC-ES_IPingService", PORT, false)}, {new TestParam("XDC-SEES_IPingService", PORT, false)}, {new TestParam("_X_IPingService", PORT, false)}, {new TestParam("_X10_IPingService", PORT, false)}, {new TestParam("_XD_IPingService", PORT, false)}, {new TestParam("_XD-SEES_IPingService", PORT, false)}, {new TestParam("_XD-ES_IPingService", PORT, false)}, {new TestParam("SecureConversation_UserNameOverTransport_IPingService", PORT2, true)}, {new TestParam("AC_IPingService", PORT, true)}, {new TestParam("ADC_IPingService", PORT, true)}, {new TestParam("ADC-ES_IPingService", PORT, true)}, {new TestParam("_A_IPingService", PORT, true)}, {new TestParam("_AD_IPingService", PORT, true)}, {new TestParam("_AD-ES_IPingService", PORT, true)}, {new TestParam("UXC_IPingService", PORT, true)}, {new TestParam("UXDC_IPingService", PORT, true)}, {new TestParam("UXDC-SEES_IPingService", PORT, true)}, {new TestParam("_UX_IPingService", PORT, true)}, {new TestParam("_UXD_IPingService", PORT, true)}, {new TestParam("_UXD-SEES_IPingService", PORT, true)}, {new TestParam("_X10_IPingService", PORT, true)}, {new TestParam("SecureConversation_UserNameOverTransport_IPingService", STAX_PORT2, false)}, {new TestParam("AC_IPingService", STAX_PORT, false)}, {new TestParam("ADC_IPingService", STAX_PORT, false)}, {new TestParam("ADC-ES_IPingService", STAX_PORT, false)}, {new TestParam("_A_IPingService", STAX_PORT, false)}, {new TestParam("_AD_IPingService", STAX_PORT, false)}, {new TestParam("_AD-ES_IPingService", STAX_PORT, false)}, {new TestParam("UXC_IPingService", STAX_PORT, false)}, {new TestParam("UXDC_IPingService", STAX_PORT, false)}, {new TestParam("UXDC-SEES_IPingService", STAX_PORT, false)}, {new TestParam("_UX_IPingService", STAX_PORT, false)}, {new TestParam("_UXD_IPingService", STAX_PORT, false)}, {new TestParam("_UXD-SEES_IPingService", STAX_PORT, false)}, {new TestParam("XC_IPingService", STAX_PORT, false)}, {new TestParam("XDC_IPingService", STAX_PORT, false)}, {new TestParam("XDC_IPingService1", STAX_PORT, false)}, {new TestParam("XDC-ES_IPingService", STAX_PORT, false)}, {new TestParam("XDC-SEES_IPingService", STAX_PORT, false)}, {new TestParam("_X_IPingService", STAX_PORT, false)}, {new TestParam("_X10_IPingService", STAX_PORT, false)}, {new TestParam("_XD_IPingService", STAX_PORT, false)}, {new TestParam("_XD-SEES_IPingService", STAX_PORT, false)}, {new TestParam("_XD-ES_IPingService", STAX_PORT, false)}, {new TestParam("SecureConversation_UserNameOverTransport_IPingService", STAX_PORT2, true)}, {new TestParam("AC_IPingService", STAX_PORT, true)}, {new TestParam("ADC_IPingService", STAX_PORT, true)}, {new TestParam("ADC-ES_IPingService", STAX_PORT, true)}, {new TestParam("_A_IPingService", STAX_PORT, true)}, {new TestParam("_AD_IPingService", STAX_PORT, true)}, {new TestParam("_AD-ES_IPingService", STAX_PORT, true)}, {new TestParam("UXC_IPingService", STAX_PORT, true)}, {new TestParam("UXDC_IPingService", STAX_PORT, true)}, {new TestParam("UXDC-SEES_IPingService", STAX_PORT, true)}, {new TestParam("_UX_IPingService", STAX_PORT, true)}, {new TestParam("_UXD_IPingService", STAX_PORT, true)}, {new TestParam("_UXD-SEES_IPingService", STAX_PORT, true)}, {new TestParam("_X10_IPingService", STAX_PORT, true)}, {new TestParam("AC_IPingService", PORT, false, true)}, {new TestParam("AC_IPingService", PORT, true, true)}, {new TestParam("AC_IPingService", STAX_PORT, false, true)}, {new TestParam("AC_IPingService", STAX_PORT, true, true)});
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        bus.shutdown(true);
        WSSCTest.stopAllServers();
    }

    @Test
    public void testSecureConversation() throws Exception {
        IPingService port = (IPingService)svc.getPort(new QName("http://WSSec/wssc", this.test.prefix), IPingService.class);
        if (PORT2.equals(this.test.port) || STAX_PORT2.equals(this.test.port)) {
            ((BindingProvider)port).getRequestContext().put("javax.xml.ws.service.endpoint.address", "https://localhost:" + this.test.port + "/" + this.test.prefix);
        } else {
            ((BindingProvider)port).getRequestContext().put("javax.xml.ws.service.endpoint.address", "http://localhost:" + this.test.port + "/" + this.test.prefix);
        }
        if (this.test.prefix.charAt(0) == '_') {
            ((BindingProvider)port).getRequestContext().put("ws-security.sts.token.do.cancel", Boolean.TRUE);
        }
        if (this.test.streaming) {
            ((BindingProvider)port).getRequestContext().put("ws-security.enable.streaming", "true");
            ((BindingProvider)port).getResponseContext().put("ws-security.enable.streaming", "true");
        }
        if (this.test.clearAction) {
            AbstractPhaseInterceptor<Message> clearActionInterceptor = new AbstractPhaseInterceptor<Message>("post-logical"){

                public void handleMessage(Message message) throws Fault {
                    STSClient client = STSUtils.getClient((Message)message, (String)"sct");
                    client.getOutInterceptors().add(this);
                    message.put((Object)"ws-security.sts.client", (Object)client);
                    String s = (String)message.get((Object)"SOAPAction");
                    if (s == null) {
                        s = SoapActionInInterceptor.getSoapAction((Message)message);
                    }
                    if (s != null && s.contains("RST/SCT")) {
                        message.put((Object)"SOAPAction", (Object)"");
                    }
                }
            };
            clearActionInterceptor.addBefore(SoapPreProtocolOutInterceptor.class.getName());
            ((Client)port).getOutInterceptors().add(clearActionInterceptor);
        }
        PingRequest params = new PingRequest();
        Ping ping = new Ping();
        ping.setOrigin("CXF");
        ping.setScenario("Scenario5");
        ping.setText("ping");
        params.setPing(ping);
        try {
            PingResponse output = port.ping(params);
            WSSCTest.assertEquals((Object)OUT, (Object)output.getPingResponse().getText());
        }
        catch (Exception ex) {
            throw new Exception("Error doing " + this.test.prefix, ex);
        }
        ((Closeable)port).close();
    }

    static class TestParam {
        final String prefix;
        final boolean streaming;
        final String port;
        final boolean clearAction;

        public TestParam(String p, String port, boolean b) {
            this.prefix = p;
            this.port = port;
            this.streaming = b;
            this.clearAction = false;
        }

        public TestParam(String p, String port, boolean b, boolean a) {
            this.prefix = p;
            this.port = port;
            this.streaming = b;
            this.clearAction = a;
        }

        public String toString() {
            return this.prefix + ":" + this.port + ":" + (this.streaming ? "streaming" : "dom") + (this.clearAction ? "/no SOAPAction" : "");
        }
    }
}

