/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.wssec10;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.wssec10.server.Server;
import org.apache.cxf.systest.ws.wssec10.server.StaxServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import wssec.wssec10.IPingService;
import wssec.wssec10.PingService;

@RunWith(value=Parameterized.class)
public class WSSecurity10Test
extends AbstractBusClientServerTestBase {
    static final String PORT = WSSecurity10Test.allocatePort(Server.class);
    static final String STAX_PORT = WSSecurity10Test.allocatePort(StaxServer.class);
    static final String SSL_PORT = WSSecurity10Test.allocatePort(Server.class, (int)1);
    static final String STAX_SSL_PORT = WSSecurity10Test.allocatePort(StaxServer.class, (int)1);
    private static final String INPUT = "foo";
    private static boolean unrestrictedPoliciesInstalled = SecurityTestUtil.checkUnrestrictedPoliciesInstalled();
    final TestParam test;

    public WSSecurity10Test(TestParam type) {
        this.test = type;
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<TestParam[]> data() {
        return Arrays.asList({new TestParam("UserName", PORT, false)}, {new TestParam("UserNameOverTransport", SSL_PORT, false)}, {new TestParam("MutualCertificate10SignEncrypt", PORT, false)}, {new TestParam("MutualCertificate10SignEncryptRsa15TripleDes", PORT, false)}, {new TestParam("UserName", PORT, true)}, {new TestParam("UserNameOverTransport", SSL_PORT, true)}, {new TestParam("MutualCertificate10SignEncrypt", PORT, true)}, {new TestParam("MutualCertificate10SignEncryptRsa15TripleDes", PORT, true)}, {new TestParam("UserName", STAX_PORT, false)}, {new TestParam("UserNameOverTransport", STAX_SSL_PORT, false)}, {new TestParam("MutualCertificate10SignEncrypt", STAX_PORT, false)}, {new TestParam("MutualCertificate10SignEncryptRsa15TripleDes", STAX_PORT, false)}, {new TestParam("UserName", STAX_PORT, true)}, {new TestParam("UserNameOverTransport", STAX_SSL_PORT, true)}, {new TestParam("MutualCertificate10SignEncrypt", STAX_PORT, true)}, {new TestParam("MutualCertificate10SignEncryptRsa15TripleDes", STAX_PORT, true)});
    }

    @BeforeClass
    public static void startServers() throws Exception {
        WSSecurity10Test.assertTrue((String)"Server failed to launch", (boolean)WSSecurity10Test.launchServer(Server.class, (boolean)true));
        WSSecurity10Test.assertTrue((String)"Server failed to launch", (boolean)WSSecurity10Test.launchServer(StaxServer.class, (boolean)true));
        if (unrestrictedPoliciesInstalled) {
            WSSecurity10Test.createStaticBus((String)"org/apache/cxf/systest/ws/wssec10/client.xml");
        } else {
            WSSecurity10Test.createStaticBus((String)"org/apache/cxf/systest/ws/wssec10/client_restricted.xml");
        }
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        WSSecurity10Test.stopAllServers();
    }

    @Test
    public void testClientServer() {
        BusFactory.setDefaultBus((Bus)WSSecurity10Test.getStaticBus());
        BusFactory.setThreadDefaultBus((Bus)WSSecurity10Test.getStaticBus());
        URL wsdlLocation = null;
        PingService svc = null;
        wsdlLocation = WSSecurity10Test.getWsdlLocation(this.test.prefix, this.test.port);
        svc = new PingService(wsdlLocation);
        IPingService port = (IPingService)svc.getPort(new QName("http://WSSec/wssec10", this.test.prefix + "_IPingService"), IPingService.class);
        Client cl = ClientProxy.getClient((Object)port);
        if (this.test.streaming) {
            ((BindingProvider)port).getRequestContext().put("ws-security.enable.streaming", "true");
            ((BindingProvider)port).getResponseContext().put("ws-security.enable.streaming", "true");
        }
        HTTPConduit http = (HTTPConduit)cl.getConduit();
        HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
        httpClientPolicy.setConnectionTimeout(0L);
        httpClientPolicy.setReceiveTimeout(0L);
        http.setClient(httpClientPolicy);
        String output = port.echo(INPUT);
        WSSecurity10Test.assertEquals((Object)INPUT, (Object)output);
        cl.destroy();
    }

    private static URL getWsdlLocation(String portPrefix, String port) {
        try {
            if ("UserNameOverTransport".equals(portPrefix)) {
                return new URL("https://localhost:" + port + "/" + portPrefix + "?wsdl");
            }
            return new URL("http://localhost:" + port + "/" + portPrefix + "?wsdl");
        }
        catch (MalformedURLException mue) {
            return null;
        }
    }

    static class TestParam {
        final String prefix;
        final boolean streaming;
        final String port;

        public TestParam(String p, String port, boolean b) {
            this.prefix = p;
            this.port = port;
            this.streaming = b;
        }

        public String toString() {
            return this.prefix + ":" + this.port + ":" + (this.streaming ? "streaming" : "dom");
        }
    }
}

