/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.wssec11;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.wssec11.WSSecurity11Common;
import org.apache.cxf.systest.ws.wssec11.server.Server11;
import org.apache.cxf.systest.ws.wssec11.server.Server11Restricted;
import org.apache.cxf.systest.ws.wssec11.server.StaxServer11;
import org.apache.cxf.systest.ws.wssec11.server.StaxServer11Restricted;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class WSSecurity111Test
extends WSSecurity11Common {
    private static boolean unrestrictedPoliciesInstalled = SecurityTestUtil.checkUnrestrictedPoliciesInstalled();
    final TestParam test;

    public WSSecurity111Test(TestParam type) {
        this.test = type;
    }

    @BeforeClass
    public static void startServers() throws Exception {
        if (unrestrictedPoliciesInstalled) {
            WSSecurity111Test.assertTrue((String)"Server failed to launch", (boolean)WSSecurity111Test.launchServer(Server11.class, (boolean)true));
            WSSecurity111Test.assertTrue((String)"Server failed to launch", (boolean)WSSecurity111Test.launchServer(StaxServer11.class, (boolean)true));
        } else {
            if (WSSecurity11Common.isIBMJDK16()) {
                System.out.println("Not running as there is a problem with 1.6 jdk and restricted jars");
                return;
            }
            WSSecurity111Test.assertTrue((String)"Server failed to launch", (boolean)WSSecurity111Test.launchServer(Server11Restricted.class, (boolean)true));
            WSSecurity111Test.assertTrue((String)"Server failed to launch", (boolean)WSSecurity111Test.launchServer(StaxServer11Restricted.class, (boolean)true));
        }
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<TestParam[]> data() {
        String domPort = null;
        domPort = unrestrictedPoliciesInstalled ? Server11.PORT : Server11Restricted.PORT;
        String staxPort = null;
        staxPort = unrestrictedPoliciesInstalled ? StaxServer11.PORT : StaxServer11Restricted.PORT;
        return Arrays.asList({new TestParam("A", domPort, false)}, {new TestParam("A-NoTimestamp", domPort, false)}, {new TestParam("AD", domPort, false)}, {new TestParam("A-ES", domPort, false)}, {new TestParam("AD-ES", domPort, false)}, {new TestParam("UX", domPort, false)}, {new TestParam("UX-NoTimestamp", domPort, false)}, {new TestParam("UXD", domPort, false)}, {new TestParam("UX-SEES", domPort, false)}, {new TestParam("UXD-SEES", domPort, false)}, {new TestParam("A", domPort, true)}, {new TestParam("A-NoTimestamp", domPort, true)}, {new TestParam("AD", domPort, true)}, {new TestParam("A-ES", domPort, true)}, {new TestParam("AD-ES", domPort, true)}, {new TestParam("UX", domPort, true)}, {new TestParam("UX-NoTimestamp", domPort, true)}, {new TestParam("UXD", domPort, true)}, {new TestParam("UX-SEES", domPort, true)}, {new TestParam("UXD-SEES", domPort, true)}, {new TestParam("A", staxPort, false)}, {new TestParam("A-NoTimestamp", staxPort, false)}, {new TestParam("AD", staxPort, false)}, {new TestParam("A-ES", staxPort, false)}, {new TestParam("AD-ES", staxPort, false)}, {new TestParam("UX", staxPort, false)}, {new TestParam("UX-NoTimestamp", staxPort, false)}, {new TestParam("UXD", staxPort, false)}, {new TestParam("UX-SEES", staxPort, false)}, {new TestParam("UXD-SEES", staxPort, false)}, {new TestParam("A", staxPort, true)}, {new TestParam("A-NoTimestamp", staxPort, true)}, {new TestParam("AD", staxPort, true)}, {new TestParam("A-ES", staxPort, true)}, {new TestParam("AD-ES", staxPort, true)}, {new TestParam("UX", staxPort, true)}, {new TestParam("UX-NoTimestamp", staxPort, true)}, {new TestParam("UXD", staxPort, true)}, {new TestParam("UX-SEES", staxPort, true)}, {new TestParam("UXD-SEES", staxPort, true)});
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        WSSecurity111Test.stopAllServers();
    }

    @Test
    public void testClientServer() throws IOException {
        if (!unrestrictedPoliciesInstalled && WSSecurity11Common.isIBMJDK16()) {
            System.out.println("Not running as there is a problem with 1.6 jdk and restricted jars");
            return;
        }
        this.runClientServer(this.test.prefix, this.test.port, unrestrictedPoliciesInstalled, this.test.streaming);
    }

    static class TestParam {
        final String prefix;
        final boolean streaming;
        final String port;

        public TestParam(String p, String port, boolean b) {
            this.prefix = p;
            this.port = port;
            this.streaming = b;
        }

        public String toString() {
            return this.prefix + ":" + this.port + ":" + (this.streaming ? "streaming" : "dom");
        }
    }
}

