/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.x509;

import java.io.Closeable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.headers.Header;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.common.TestParam;
import org.apache.cxf.systest.ws.ut.SecurityHeaderCacheInterceptor;
import org.apache.cxf.systest.ws.x509.Intermediary;
import org.apache.cxf.systest.ws.x509.Server;
import org.apache.cxf.systest.ws.x509.StaxServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.example.contract.doubleit.DoubleItPortType;
import org.example.contract.doubleit.DoubleItPortType2;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class X509TokenTest
extends AbstractBusClientServerTestBase {
    public static final String PORT = X509TokenTest.allocatePort(Server.class);
    public static final String STAX_PORT = X509TokenTest.allocatePort(StaxServer.class);
    public static final String INTERMEDIARY_PORT = X509TokenTest.allocatePort(Intermediary.class);
    static final String PORT2 = X509TokenTest.allocatePort(Server.class, (int)2);
    static final String STAX_PORT2 = X509TokenTest.allocatePort(StaxServer.class, (int)2);
    private static final String NAMESPACE = "http://www.example.org/contract/DoubleIt";
    private static final QName SERVICE_QNAME = new QName("http://www.example.org/contract/DoubleIt", "DoubleItService");
    private static boolean unrestrictedPoliciesInstalled = SecurityTestUtil.checkUnrestrictedPoliciesInstalled();
    final TestParam test;

    public X509TokenTest(TestParam type) {
        this.test = type;
    }

    @BeforeClass
    public static void startServers() throws Exception {
        X509TokenTest.assertTrue((String)"Server failed to launch", (boolean)X509TokenTest.launchServer(Server.class, (boolean)true));
        X509TokenTest.assertTrue((String)"Server failed to launch", (boolean)X509TokenTest.launchServer(StaxServer.class, (boolean)true));
        X509TokenTest.assertTrue((String)"Intermediary failed to launch", (boolean)X509TokenTest.launchServer(Intermediary.class, (boolean)true));
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<TestParam[]> data() {
        return Arrays.asList({new TestParam(PORT, false)}, {new TestParam(PORT, true)}, {new TestParam(STAX_PORT, false)}, {new TestParam(STAX_PORT, true)});
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        X509TokenTest.stopAllServers();
    }

    @Test
    public void testSymmetricErrorMessage() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSymmetricErrorMessagePort");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(x509Port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(x509Port);
        }
        try {
            x509Port.doubleIt(25);
            X509TokenTest.fail((String)"Failure expected on an incorrect key");
        }
        catch (SOAPFaultException ex) {
            String error = "No certificates were found for decryption";
            if (STAX_PORT.equals(this.test.getPort())) {
                error = "Referenced security token could not be retrieved";
            }
            X509TokenTest.assertTrue((boolean)ex.getMessage().contains(error));
        }
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testKeyIdentifier() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItKeyIdentifierPort");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(x509Port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(x509Port);
        }
        x509Port.doubleIt(25);
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testKeyIdentifierDerived() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItKeyIdentifierDerivedPort");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(x509Port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(x509Port);
        }
        x509Port.doubleIt(25);
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testKeyIdentifierEncryptBeforeSigning() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItKeyIdentifierEncryptBeforeSigningPort");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(x509Port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(x509Port);
        }
        x509Port.doubleIt(25);
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testKeyIdentifierEncryptBeforeSigningDerived() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItKeyIdentifierEncryptBeforeSigningDerivedPort");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(x509Port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(x509Port);
        }
        x509Port.doubleIt(25);
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testKeyIdentifierJaxwsClient() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("jaxws-client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItKeyIdentifierPort");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(x509Port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(x509Port);
        }
        ((BindingProvider)x509Port).getRequestContext().put("ws-security.encryption.properties", "bob.properties");
        ((BindingProvider)x509Port).getRequestContext().put("ws-security.encryption.username", "bob");
        x509Port.doubleIt(25);
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testIntermediary() throws Exception {
        if (this.test.isStreaming() || STAX_PORT.equals(this.test.getPort())) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("intermediary-client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItIntermediary.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItPort");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(x509Port, INTERMEDIARY_PORT);
        x509Port.doubleIt(25);
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testIssuerSerial() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItIssuerSerialPort");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(x509Port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(x509Port);
        }
        x509Port.doubleIt(25);
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testThumbprint() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItThumbprintPort");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(x509Port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(x509Port);
        }
        x509Port.doubleIt(25);
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSymmetricThumbprintEndorsing() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSymmetricThumbprintEndorsingPort");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(x509Port, this.test.getPort());
        if (!this.test.isStreaming()) {
            x509Port.doubleIt(25);
        }
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSymmetricEndorsingEncrypted() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSymmetricEndorsingEncryptedPort");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(x509Port, this.test.getPort());
        if (!this.test.isStreaming()) {
            x509Port.doubleIt(25);
        }
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testContentEncryptedElements() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItContentEncryptedElementsPort");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(x509Port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(x509Port);
        }
        x509Port.doubleIt(25);
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testAsymmetricIssuerSerial() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItAsymmetricIssuerSerialPort");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(x509Port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(x509Port);
        }
        x509Port.doubleIt(25);
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testAsymmetricNoInitiatorTokenReference() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItAsymmetricNoInitiatorReferencePort");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(x509Port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(x509Port);
        }
        x509Port.doubleIt(25);
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testAsymmetricSP11() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItAsymmetricSP11Port");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(x509Port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(x509Port);
        }
        x509Port.doubleIt(25);
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testAsymmetricEncryptedPassword() throws Exception {
        if (!unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItAsymmetricEncryptedPasswordPort");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(x509Port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(x509Port);
        }
        x509Port.doubleIt(25);
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testAsymmetricSHA256() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItAsymmetricSHA256Port");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(x509Port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(x509Port);
        }
        x509Port.doubleIt(25);
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testAsymmetricThumbprint() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItAsymmetricThumbprintPort");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(x509Port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(x509Port);
        }
        x509Port.doubleIt(25);
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testAsymmetricPKIPath() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItAsymmetricPKIPathPort");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(x509Port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(x509Port);
        }
        x509Port.doubleIt(25);
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testAsymmetricEncryptBeforeSigning() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItAsymmetricEncryptBeforeSigningPort");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(x509Port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(x509Port);
        }
        x509Port.doubleIt(25);
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testAsymmetricEncryptBeforeSigningNoEnc() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItAsymmetricEncryptBeforeSigningNoEncPort");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(x509Port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(x509Port);
        }
        x509Port.doubleIt(25);
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testAsymmetricEncryptSignature() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItAsymmetricEncryptSignaturePort");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(x509Port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(x509Port);
        }
        x509Port.doubleIt(25);
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testAsymmetricProtectTokens() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItAsymmetricProtectTokensPort");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(x509Port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(x509Port);
        }
        x509Port.doubleIt(25);
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testAsymmetricUsernameToken() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItAsymmetricUsernameTokenPort");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(x509Port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(x509Port);
        }
        x509Port.doubleIt(25);
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testAsymmetricEndorsing() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItAsymmetricEndorsingPort");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(x509Port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(x509Port);
        }
        if (!this.test.isStreaming() && !STAX_PORT.equals(this.test.getPort())) {
            x509Port.doubleIt(25);
        }
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSymmetricUsernameToken() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSymmetricUsernameTokenPort");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(x509Port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(x509Port);
        }
        x509Port.doubleIt(25);
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSymmetricProtectTokens() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSymmetricProtectTokensPort");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(x509Port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(x509Port);
        }
        if (!this.test.isStreaming()) {
            x509Port.doubleIt(25);
        }
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testTransportEndorsing() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItTransportEndorsingPort");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        String port = PORT2;
        if (STAX_PORT.equals(this.test.getPort())) {
            port = STAX_PORT2;
        }
        this.updateAddressPort(x509Port, port);
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(x509Port);
        }
        x509Port.doubleIt(25);
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testTransportEndorsingSP11() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItTransportEndorsingSP11Port");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        String port = PORT2;
        if (STAX_PORT.equals(this.test.getPort())) {
            port = STAX_PORT2;
        }
        this.updateAddressPort(x509Port, port);
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(x509Port);
        }
        x509Port.doubleIt(25);
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testTransportSignedEndorsing() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItTransportSignedEndorsingPort");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        String port = PORT2;
        if (STAX_PORT.equals(this.test.getPort())) {
            port = STAX_PORT2;
        }
        this.updateAddressPort(x509Port, port);
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(x509Port);
        }
        x509Port.doubleIt(25);
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testTransportEndorsingEncrypted() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItTransportEndorsingEncryptedPort");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        String port = PORT2;
        if (STAX_PORT.equals(this.test.getPort())) {
            port = STAX_PORT2;
        }
        this.updateAddressPort(x509Port, port);
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(x509Port);
        }
        x509Port.doubleIt(25);
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testTransportSignedEndorsingEncrypted() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItTransportSignedEndorsingEncryptedPort");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        String port = PORT2;
        if (STAX_PORT.equals(this.test.getPort())) {
            port = STAX_PORT2;
        }
        this.updateAddressPort(x509Port, port);
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(x509Port);
        }
        x509Port.doubleIt(25);
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testAsymmetricSignature() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509Signature.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItAsymmetricSignaturePort");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(x509Port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(x509Port);
        }
        x509Port.doubleIt(25);
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testAsymmetricSignatureSP11() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509Signature.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItAsymmetricSignatureSP11Port");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(x509Port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(x509Port);
        }
        x509Port.doubleIt(25);
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testAsymmetricEncryption() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509Signature.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItAsymmetricEncryptionPort");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(x509Port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(x509Port);
        }
        x509Port.doubleIt(25);
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testAsymmetricSignatureEncryption() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509Signature.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItAsymmetricSignatureEncryptionPort");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(x509Port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(x509Port);
        }
        x509Port.doubleIt(25);
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testAsymmetricSignatureReplay() throws Exception {
        if (this.test.isStreaming()) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509Signature.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItAsymmetricSignaturePort");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(x509Port, this.test.getPort());
        Client cxfClient = ClientProxy.getClient((Object)x509Port);
        SecurityHeaderCacheInterceptor cacheInterceptor = new SecurityHeaderCacheInterceptor();
        cxfClient.getOutInterceptors().add(cacheInterceptor);
        x509Port.doubleIt(25);
        try {
            x509Port.doubleIt(25);
            X509TokenTest.fail((String)"Failure expected on a replayed Timestamp");
        }
        catch (SOAPFaultException ex) {
            X509TokenTest.assertTrue((boolean)ex.getMessage().contains("A security error was encountered when verifying the message"));
        }
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testTransportSupportingSigned() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItTransportSupportingSignedPort");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        String port = PORT2;
        if (STAX_PORT.equals(this.test.getPort())) {
            port = STAX_PORT2;
        }
        this.updateAddressPort(x509Port, port);
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(x509Port);
        }
        x509Port.doubleIt(25);
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testTransportSupportingSignedCertConstraints() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItTransportSupportingSignedCertConstraintsPort");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        String port = PORT2;
        if (STAX_PORT.equals(this.test.getPort())) {
            port = STAX_PORT2;
        }
        this.updateAddressPort(x509Port, port);
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(x509Port);
        }
        ((BindingProvider)x509Port).getRequestContext().put("ws-security.signature.properties", "bob.properties");
        ((BindingProvider)x509Port).getRequestContext().put("ws-security.signature.username", "bob");
        try {
            x509Port.doubleIt(25);
            X509TokenTest.fail((String)"Failure expected on bob");
        }
        catch (Exception ex) {
            // empty catch block
        }
        x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(x509Port, port);
        ((BindingProvider)x509Port).getRequestContext().put("ws-security.signature.properties", "alice.properties");
        ((BindingProvider)x509Port).getRequestContext().put("ws-security.signature.username", "alice");
        x509Port.doubleIt(25);
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testTransportKVT() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItTransportKVTPort");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        String port = PORT2;
        if (STAX_PORT.equals(this.test.getPort())) {
            port = STAX_PORT2;
        }
        this.updateAddressPort(x509Port, port);
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(x509Port);
        }
        x509Port.doubleIt(25);
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testKeyIdentifier2() throws Exception {
        if (this.test.isStreaming()) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItOperations.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItKeyIdentifierPort2");
        DoubleItPortType2 x509Port = (DoubleItPortType2)service.getPort(portQName, DoubleItPortType2.class);
        this.updateAddressPort(x509Port, PORT);
        ArrayList<Header> headers = new ArrayList<Header>();
        Header dummyHeader = new Header(new QName("uri:org.apache.cxf", "dummy"), (Object)"dummy-header", (DataBinding)new JAXBDataBinding(new Class[]{String.class}));
        headers.add(dummyHeader);
        ((BindingProvider)x509Port).getRequestContext().put(Header.HEADER_LIST, headers);
        int response = x509Port.doubleIt(25);
        X509TokenTest.assertEquals((long)50L, (long)response);
        int response2 = x509Port.doubleIt2(15);
        X509TokenTest.assertEquals((long)30L, (long)response2);
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSupportingToken() throws Exception {
        String error;
        if (this.test.isStreaming()) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItTransportSupportingTokenPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT2);
        port.doubleIt(25);
        portQName = new QName(NAMESPACE, "DoubleItTransportSupportingTokenPort2");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT2);
        try {
            port.doubleIt(25);
            X509TokenTest.fail((String)"Failure expected on not sending an X.509 Supporting Token");
        }
        catch (SOAPFaultException ex) {
            error = "These policy alternatives can not be satisfied";
            X509TokenTest.assertTrue((boolean)ex.getMessage().contains(error));
        }
        portQName = new QName(NAMESPACE, "DoubleItTransportPKISupportingTokenPort");
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT2);
        try {
            port.doubleIt(25);
            X509TokenTest.fail((String)"Failure expected on not sending a PKI token");
        }
        catch (SOAPFaultException ex) {
            error = "These policy alternatives can not be satisfied";
            X509TokenTest.assertTrue((boolean)ex.getMessage().contains(error));
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testNegativeEndorsing() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItTransportNegativeEndorsingPort");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        String port = PORT2;
        if (STAX_PORT.equals(this.test.getPort())) {
            port = STAX_PORT2;
        }
        this.updateAddressPort(x509Port, port);
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(x509Port);
        }
        x509Port.doubleIt(25);
        portQName = new QName(NAMESPACE, "DoubleItTransportNegativeEndorsingPort2");
        x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(x509Port, port);
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(x509Port);
        }
        try {
            x509Port.doubleIt(25);
            X509TokenTest.fail((String)"Failure expected on not endorsing the token");
        }
        catch (SOAPFaultException ex) {
            String error = "These policy alternatives can not be satisfied";
            X509TokenTest.assertTrue((ex.getMessage().contains(error) || ex.getMessage().contains("X509Token not satisfied") ? 1 : 0) != 0);
        }
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSymmetricSignature() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509Signature.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSymmetricSignaturePort");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(x509Port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(x509Port);
        }
        x509Port.doubleIt(25);
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }

    @Test
    public void testAsymmetricProperties() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = X509TokenTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = X509TokenTest.class.getResource("DoubleItX509.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItAsymmetricPropertiesPort");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(x509Port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(x509Port);
        }
        x509Port.doubleIt(25);
        ((Closeable)x509Port).close();
        bus.shutdown(true);
    }
}

