/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.xkms;

import java.io.Closeable;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.common.TestParam;
import org.apache.cxf.systest.ws.xkms.Server;
import org.apache.cxf.systest.ws.xkms.StaxServer;
import org.apache.cxf.systest.ws.xkms.XKMSServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.example.contract.doubleit.DoubleItPortType;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class XKMSTest
extends AbstractBusClientServerTestBase {
    public static final String PORT = XKMSTest.allocatePort(Server.class);
    public static final String STAX_PORT = XKMSTest.allocatePort(StaxServer.class);
    static final String PORT2 = XKMSTest.allocatePort(XKMSServer.class);
    private static final String NAMESPACE = "http://www.example.org/contract/DoubleIt";
    private static final QName SERVICE_QNAME = new QName("http://www.example.org/contract/DoubleIt", "DoubleItService");
    final TestParam test;

    public XKMSTest(TestParam type) {
        this.test = type;
    }

    @BeforeClass
    public static void startServers() throws Exception {
        XKMSTest.assertTrue((String)"Server failed to launch", (boolean)XKMSTest.launchServer(Server.class, (boolean)true));
        XKMSTest.assertTrue((String)"Server failed to launch", (boolean)XKMSTest.launchServer(StaxServer.class, (boolean)true));
        XKMSTest.assertTrue((String)"Server failed to launch", (boolean)XKMSTest.launchServer(XKMSServer.class, (boolean)true));
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<TestParam[]> data() {
        return Arrays.asList({new TestParam(PORT, false)}, {new TestParam(PORT, true)}, {new TestParam(STAX_PORT, false)}, {new TestParam(STAX_PORT, true)});
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        XKMSTest.stopAllServers();
    }

    @Test
    public void testSymmetricBinding() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = XKMSTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = XKMSTest.class.getResource("DoubleItXKMS.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSymmetricPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        port.doubleIt(25);
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testAsymmetricBinding() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = XKMSTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = XKMSTest.class.getResource("DoubleItXKMS.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItAsymmetricPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        port.doubleIt(25);
        ((Closeable)port).close();
        bus.shutdown(true);
    }
}

