/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.coverage_checker;

import java.io.Closeable;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.common.TestParam;
import org.apache.cxf.systest.ws.coverage_checker.Server;
import org.apache.cxf.systest.ws.coverage_checker.StaxServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JStaxOutInterceptor;
import org.example.contract.doubleit.DoubleItPortType;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CryptoCoverageCheckerTest
extends AbstractBusClientServerTestBase {
    public static final String PORT = CryptoCoverageCheckerTest.allocatePort(Server.class);
    public static final String STAX_PORT = CryptoCoverageCheckerTest.allocatePort(StaxServer.class);
    private static final String NAMESPACE = "http://www.example.org/contract/DoubleIt";
    private static final QName SERVICE_QNAME = new QName("http://www.example.org/contract/DoubleIt", "DoubleItService");
    private static boolean unrestrictedPoliciesInstalled = SecurityTestUtil.checkUnrestrictedPoliciesInstalled();
    final TestParam test;

    public CryptoCoverageCheckerTest(TestParam type) {
        this.test = type;
    }

    @BeforeClass
    public static void startServers() throws Exception {
        CryptoCoverageCheckerTest.assertTrue((String)"Server failed to launch", (boolean)CryptoCoverageCheckerTest.launchServer(Server.class, (boolean)true));
        CryptoCoverageCheckerTest.assertTrue((String)"Server failed to launch", (boolean)CryptoCoverageCheckerTest.launchServer(StaxServer.class, (boolean)true));
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<TestParam[]> data() {
        return Arrays.asList({new TestParam(PORT, false)}, {new TestParam(PORT, true)}, {new TestParam(STAX_PORT, false)}, {new TestParam(STAX_PORT, true)});
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        CryptoCoverageCheckerTest.stopAllServers();
    }

    @Test
    public void testSignedBodyTimestamp() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = CryptoCoverageCheckerTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = CryptoCoverageCheckerTest.class.getResource("DoubleItCoverageChecker.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItBodyTimestampPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        HashMap<String, String> outProps = new HashMap<String, String>();
        outProps.put("action", "Timestamp Signature");
        outProps.put("signaturePropFile", "alice.properties");
        outProps.put("user", "alice");
        outProps.put("passwordCallbackClass", "org.apache.cxf.systest.ws.common.KeystorePasswordCallback");
        outProps.put("signatureParts", "{}{http://schemas.xmlsoap.org/soap/envelope/}Body;{}{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd}Timestamp;");
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        if (this.test.isStreaming()) {
            WSS4JStaxOutInterceptor staxOutInterceptor = new WSS4JStaxOutInterceptor(outProps);
            bus.getOutInterceptors().add(staxOutInterceptor);
        } else {
            WSS4JOutInterceptor outInterceptor = new WSS4JOutInterceptor(outProps);
            bus.getOutInterceptors().add(outInterceptor);
        }
        port.doubleIt(25);
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSignedBodyOnly() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = CryptoCoverageCheckerTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = CryptoCoverageCheckerTest.class.getResource("DoubleItCoverageChecker.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItBodyTimestampPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        HashMap<String, String> outProps = new HashMap<String, String>();
        outProps.put("action", "Timestamp Signature");
        outProps.put("signaturePropFile", "alice.properties");
        outProps.put("user", "alice");
        outProps.put("passwordCallbackClass", "org.apache.cxf.systest.ws.common.KeystorePasswordCallback");
        outProps.put("signatureParts", "{}{http://schemas.xmlsoap.org/soap/envelope/}Body;");
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        if (this.test.isStreaming()) {
            WSS4JStaxOutInterceptor staxOutInterceptor = new WSS4JStaxOutInterceptor(outProps);
            bus.getOutInterceptors().add(staxOutInterceptor);
        } else {
            WSS4JOutInterceptor outInterceptor = new WSS4JOutInterceptor(outProps);
            bus.getOutInterceptors().add(outInterceptor);
        }
        try {
            port.doubleIt(25);
            CryptoCoverageCheckerTest.fail((String)"Failure expected on not signing the Timestamp");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSignedTimestampOnly() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = CryptoCoverageCheckerTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = CryptoCoverageCheckerTest.class.getResource("DoubleItCoverageChecker.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItBodyTimestampPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        HashMap<String, String> outProps = new HashMap<String, String>();
        outProps.put("action", "Timestamp Signature");
        outProps.put("signaturePropFile", "alice.properties");
        outProps.put("user", "alice");
        outProps.put("passwordCallbackClass", "org.apache.cxf.systest.ws.common.KeystorePasswordCallback");
        outProps.put("signatureParts", "{}{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd}Timestamp;");
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        if (this.test.isStreaming()) {
            WSS4JStaxOutInterceptor staxOutInterceptor = new WSS4JStaxOutInterceptor(outProps);
            bus.getOutInterceptors().add(staxOutInterceptor);
        } else {
            WSS4JOutInterceptor outInterceptor = new WSS4JOutInterceptor(outProps);
            bus.getOutInterceptors().add(outInterceptor);
        }
        try {
            port.doubleIt(25);
            CryptoCoverageCheckerTest.fail((String)"Failure expected on not signing the Timestamp");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSignedBodyTimestampSoap12() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = CryptoCoverageCheckerTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = CryptoCoverageCheckerTest.class.getResource("DoubleItCoverageChecker.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItBodyTimestampSoap12Port");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        HashMap<String, String> outProps = new HashMap<String, String>();
        outProps.put("action", "Timestamp Signature");
        outProps.put("signaturePropFile", "alice.properties");
        outProps.put("user", "alice");
        outProps.put("passwordCallbackClass", "org.apache.cxf.systest.ws.common.KeystorePasswordCallback");
        outProps.put("signatureParts", "{}{http://www.w3.org/2003/05/soap-envelope}Body;{}{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd}Timestamp;");
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        if (this.test.isStreaming()) {
            WSS4JStaxOutInterceptor staxOutInterceptor = new WSS4JStaxOutInterceptor(outProps);
            bus.getOutInterceptors().add(staxOutInterceptor);
        } else {
            WSS4JOutInterceptor outInterceptor = new WSS4JOutInterceptor(outProps);
            bus.getOutInterceptors().add(outInterceptor);
        }
        port.doubleIt(25);
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSignedBodyOnlySoap12() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = CryptoCoverageCheckerTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = CryptoCoverageCheckerTest.class.getResource("DoubleItCoverageChecker.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItBodyTimestampSoap12Port");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        HashMap<String, String> outProps = new HashMap<String, String>();
        outProps.put("action", "Timestamp Signature");
        outProps.put("signaturePropFile", "alice.properties");
        outProps.put("user", "alice");
        outProps.put("passwordCallbackClass", "org.apache.cxf.systest.ws.common.KeystorePasswordCallback");
        outProps.put("signatureParts", "{}{http://www.w3.org/2003/05/soap-envelope}Body;");
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        if (this.test.isStreaming()) {
            WSS4JStaxOutInterceptor staxOutInterceptor = new WSS4JStaxOutInterceptor(outProps);
            bus.getOutInterceptors().add(staxOutInterceptor);
        } else {
            WSS4JOutInterceptor outInterceptor = new WSS4JOutInterceptor(outProps);
            bus.getOutInterceptors().add(outInterceptor);
        }
        try {
            port.doubleIt(25);
            CryptoCoverageCheckerTest.fail((String)"Failure expected on not signing the Timestamp");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSignedTimestampOnlySoap12() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = CryptoCoverageCheckerTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = CryptoCoverageCheckerTest.class.getResource("DoubleItCoverageChecker.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItBodyTimestampSoap12Port");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        HashMap<String, String> outProps = new HashMap<String, String>();
        outProps.put("action", "Timestamp Signature");
        outProps.put("signaturePropFile", "alice.properties");
        outProps.put("user", "alice");
        outProps.put("passwordCallbackClass", "org.apache.cxf.systest.ws.common.KeystorePasswordCallback");
        outProps.put("signatureParts", "{}{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd}Timestamp;");
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        if (this.test.isStreaming()) {
            WSS4JStaxOutInterceptor staxOutInterceptor = new WSS4JStaxOutInterceptor(outProps);
            bus.getOutInterceptors().add(staxOutInterceptor);
        } else {
            WSS4JOutInterceptor outInterceptor = new WSS4JOutInterceptor(outProps);
            bus.getOutInterceptors().add(outInterceptor);
        }
        try {
            port.doubleIt(25);
            CryptoCoverageCheckerTest.fail((String)"Failure expected on not signing the Timestamp");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSignedEncryptedBody() throws Exception {
        if (!unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = CryptoCoverageCheckerTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = CryptoCoverageCheckerTest.class.getResource("DoubleItCoverageChecker.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSignedEncryptedBodyPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        HashMap<String, String> outProps = new HashMap<String, String>();
        outProps.put("action", "Timestamp Signature Encrypt");
        outProps.put("signaturePropFile", "alice.properties");
        outProps.put("encryptionPropFile", "bob.properties");
        outProps.put("user", "alice");
        outProps.put("encryptionUser", "bob");
        outProps.put("passwordCallbackClass", "org.apache.cxf.systest.ws.common.KeystorePasswordCallback");
        outProps.put("signatureParts", "{}{http://schemas.xmlsoap.org/soap/envelope/}Body;");
        outProps.put("encryptionParts", "{}{http://schemas.xmlsoap.org/soap/envelope/}Body;");
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        if (this.test.isStreaming()) {
            WSS4JStaxOutInterceptor staxOutInterceptor = new WSS4JStaxOutInterceptor(outProps);
            bus.getOutInterceptors().add(staxOutInterceptor);
        } else {
            WSS4JOutInterceptor outInterceptor = new WSS4JOutInterceptor(outProps);
            bus.getOutInterceptors().add(outInterceptor);
        }
        port.doubleIt(25);
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSignedNotEncryptedBody() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = CryptoCoverageCheckerTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = CryptoCoverageCheckerTest.class.getResource("DoubleItCoverageChecker.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSignedEncryptedBodyPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        HashMap<String, String> outProps = new HashMap<String, String>();
        outProps.put("action", "Timestamp Signature Encrypt");
        outProps.put("signaturePropFile", "alice.properties");
        outProps.put("encryptionPropFile", "bob.properties");
        outProps.put("user", "alice");
        outProps.put("encryptionUser", "bob");
        outProps.put("passwordCallbackClass", "org.apache.cxf.systest.ws.common.KeystorePasswordCallback");
        outProps.put("signatureParts", "{}{http://schemas.xmlsoap.org/soap/envelope/}Body;");
        outProps.put("encryptionParts", "{}{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd}Timestamp;");
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        if (this.test.isStreaming()) {
            WSS4JStaxOutInterceptor staxOutInterceptor = new WSS4JStaxOutInterceptor(outProps);
            bus.getOutInterceptors().add(staxOutInterceptor);
        } else {
            WSS4JOutInterceptor outInterceptor = new WSS4JOutInterceptor(outProps);
            bus.getOutInterceptors().add(outInterceptor);
        }
        try {
            port.doubleIt(25);
            CryptoCoverageCheckerTest.fail((String)"Failure expected on not encrypting the SOAP Body");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testWSAddressing() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = CryptoCoverageCheckerTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = CryptoCoverageCheckerTest.class.getResource("DoubleItCoverageChecker.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItWSAPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        HashMap<String, String> outProps = new HashMap<String, String>();
        outProps.put("action", "Timestamp Signature");
        outProps.put("signaturePropFile", "alice.properties");
        outProps.put("user", "alice");
        outProps.put("passwordCallbackClass", "org.apache.cxf.systest.ws.common.KeystorePasswordCallback");
        outProps.put("signatureParts", "{}{http://schemas.xmlsoap.org/soap/envelope/}Body;{}{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd}Timestamp;");
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        WSS4JStaxOutInterceptor staxOutInterceptor = null;
        WSS4JOutInterceptor outInterceptor = null;
        if (this.test.isStreaming()) {
            staxOutInterceptor = new WSS4JStaxOutInterceptor(outProps);
            bus.getOutInterceptors().add(staxOutInterceptor);
        } else {
            outInterceptor = new WSS4JOutInterceptor(outProps);
            bus.getOutInterceptors().add(outInterceptor);
        }
        try {
            port.doubleIt(25);
            CryptoCoverageCheckerTest.fail((String)"Failure expected on not signing the WS-Addressing headers");
        }
        catch (Exception exception) {
            // empty catch block
        }
        outProps.put("signatureParts", "{}{http://schemas.xmlsoap.org/soap/envelope/}Body;{}{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd}Timestamp;{}{http://www.w3.org/2005/08/addressing}ReplyTo;");
        if (this.test.isStreaming()) {
            bus.getOutInterceptors().remove(staxOutInterceptor);
            SecurityTestUtil.enableStreaming(port);
        } else {
            bus.getOutInterceptors().remove(outInterceptor);
        }
        if (this.test.isStreaming()) {
            staxOutInterceptor = new WSS4JStaxOutInterceptor(outProps);
            bus.getOutInterceptors().add(staxOutInterceptor);
        } else {
            outInterceptor = new WSS4JOutInterceptor(outProps);
            bus.getOutInterceptors().add(outInterceptor);
        }
        port.doubleIt(25);
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testWSAddressingOptionalSignatureParts() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = CryptoCoverageCheckerTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = CryptoCoverageCheckerTest.class.getResource("DoubleItCoverageChecker.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItWSAPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        HashMap<String, String> outProps = new HashMap<String, String>();
        outProps.put("action", "Timestamp Signature");
        outProps.put("signaturePropFile", "alice.properties");
        outProps.put("user", "alice");
        outProps.put("passwordCallbackClass", "org.apache.cxf.systest.ws.common.KeystorePasswordCallback");
        outProps.put("optionalSignatureParts", "{}{http://schemas.xmlsoap.org/soap/envelope/}Body;{}{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd}Timestamp;{}{http://www.w3.org/2005/08/addressing}ReplyTo;");
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        WSS4JStaxOutInterceptor staxOutInterceptor = null;
        WSS4JOutInterceptor outInterceptor = null;
        if (this.test.isStreaming()) {
            staxOutInterceptor = new WSS4JStaxOutInterceptor(outProps);
            bus.getOutInterceptors().add(staxOutInterceptor);
        } else {
            outInterceptor = new WSS4JOutInterceptor(outProps);
            bus.getOutInterceptors().add(outInterceptor);
        }
        port.doubleIt(25);
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testClientChecker() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = CryptoCoverageCheckerTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = CryptoCoverageCheckerTest.class.getResource("DoubleItCoverageChecker.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItClientCheckerPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (PORT.equals(this.test.getPort()) && !this.test.isStreaming()) {
            int result = port.doubleIt(25);
            CryptoCoverageCheckerTest.assertEquals((long)50L, (long)result);
            try {
                port.doubleIt(0);
                CryptoCoverageCheckerTest.fail((String)"Failure expected on trying to double 0");
            }
            catch (Exception ex) {
                CryptoCoverageCheckerTest.assertTrue((boolean)ex.getMessage().contains("0 can't be doubled"));
            }
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testClientChecker2() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = CryptoCoverageCheckerTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = CryptoCoverageCheckerTest.class.getResource("DoubleItCoverageChecker.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItClientCheckerPort2");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        if (PORT.equals(this.test.getPort()) && !this.test.isStreaming()) {
            port.doubleIt(25);
            try {
                port.doubleIt(0);
                CryptoCoverageCheckerTest.fail((String)"Failure expected on trying to double 0");
            }
            catch (Exception ex) {
                CryptoCoverageCheckerTest.assertTrue((boolean)ex.getMessage().contains("0 can't be doubled"));
            }
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testEncryptedUsernameToken() throws Exception {
        if (!unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = CryptoCoverageCheckerTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = CryptoCoverageCheckerTest.class.getResource("DoubleItCoverageChecker.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItEncryptedUsernameTokenPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        HashMap<String, String> outProps = new HashMap<String, String>();
        outProps.put("action", "UsernameToken Encrypt");
        outProps.put("encryptionPropFile", "bob.properties");
        outProps.put("user", "alice");
        outProps.put("encryptionUser", "bob");
        outProps.put("passwordCallbackClass", "org.apache.cxf.systest.ws.common.KeystorePasswordCallback");
        outProps.put("encryptionParts", "{}{http://schemas.xmlsoap.org/soap/envelope/}Body;{Element}{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd}UsernameToken;");
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        if (this.test.isStreaming()) {
            WSS4JStaxOutInterceptor staxOutInterceptor = new WSS4JStaxOutInterceptor(outProps);
            bus.getOutInterceptors().add(staxOutInterceptor);
        } else {
            WSS4JOutInterceptor outInterceptor = new WSS4JOutInterceptor(outProps);
            bus.getOutInterceptors().add(outInterceptor);
        }
        port.doubleIt(25);
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testNotEncryptedUsernameToken() throws Exception {
        if (!unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = CryptoCoverageCheckerTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = CryptoCoverageCheckerTest.class.getResource("DoubleItCoverageChecker.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItEncryptedUsernameTokenPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, this.test.getPort());
        HashMap<String, String> outProps = new HashMap<String, String>();
        outProps.put("action", "UsernameToken Encrypt");
        outProps.put("encryptionPropFile", "bob.properties");
        outProps.put("user", "alice");
        outProps.put("encryptionUser", "bob");
        outProps.put("passwordCallbackClass", "org.apache.cxf.systest.ws.common.KeystorePasswordCallback");
        outProps.put("encryptionParts", "{}{http://schemas.xmlsoap.org/soap/envelope/}Body;");
        if (this.test.isStreaming()) {
            SecurityTestUtil.enableStreaming(port);
        }
        if (this.test.isStreaming()) {
            WSS4JStaxOutInterceptor staxOutInterceptor = new WSS4JStaxOutInterceptor(outProps);
            bus.getOutInterceptors().add(staxOutInterceptor);
        } else {
            WSS4JOutInterceptor outInterceptor = new WSS4JOutInterceptor(outProps);
            bus.getOutInterceptors().add(outInterceptor);
        }
        try {
            port.doubleIt(25);
            CryptoCoverageCheckerTest.fail((String)"Failure expected on not encrypting the UsernameToken");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((Closeable)port).close();
        bus.shutdown(true);
    }
}

