/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.fault;

import java.io.Closeable;
import java.net.URL;
import java.util.Date;
import java.util.Iterator;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPFault;
import javax.xml.ws.Service;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.fault.AbstractModifyRequestInterceptor;
import org.apache.cxf.systest.ws.fault.ModifiedRequestServer;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.wss4j.dom.util.XmlSchemaDateFormat;
import org.example.contract.doubleit.DoubleItFault;
import org.example.contract.doubleit.DoubleItPortType;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ModifiedRequestTest
extends AbstractBusClientServerTestBase {
    static final String PORT = ModifiedRequestTest.allocatePort(ModifiedRequestServer.class);
    static final String STAX_PORT = ModifiedRequestTest.allocatePort(ModifiedRequestServer.class, (int)2);
    private static final String NAMESPACE = "http://www.example.org/contract/DoubleIt";
    private static final QName SERVICE_QNAME = new QName("http://www.example.org/contract/DoubleIt", "DoubleItService");
    private static boolean unrestrictedPoliciesInstalled = SecurityTestUtil.checkUnrestrictedPoliciesInstalled();

    @BeforeClass
    public static void startServers() throws Exception {
        ModifiedRequestTest.assertTrue((String)"Server failed to launch", (boolean)ModifiedRequestTest.launchServer(ModifiedRequestServer.class, (boolean)true));
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        ModifiedRequestTest.stopAllServers();
    }

    @Test
    public void testModifiedSignedTimestamp() throws Exception {
        if (!unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = ModifiedRequestTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = ModifiedRequestTest.class.getResource("DoubleItFault.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItAsymmetricPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        Client cxfClient = ClientProxy.getClient((Object)port);
        ModifiedTimestampInterceptor modifyInterceptor = new ModifiedTimestampInterceptor();
        cxfClient.getOutInterceptors().add(modifyInterceptor);
        this.makeInvocation(port, false);
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, STAX_PORT);
        cxfClient = ClientProxy.getClient((Object)port);
        modifyInterceptor = new ModifiedTimestampInterceptor();
        cxfClient.getOutInterceptors().add(modifyInterceptor);
        this.makeInvocation(port, true);
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testModifiedSignature() throws Exception {
        if (!unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = ModifiedRequestTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = ModifiedRequestTest.class.getResource("DoubleItFault.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItAsymmetricPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        Client cxfClient = ClientProxy.getClient((Object)port);
        ModifiedSignatureInterceptor modifyInterceptor = new ModifiedSignatureInterceptor();
        cxfClient.getOutInterceptors().add(modifyInterceptor);
        this.makeInvocation(port, false);
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, STAX_PORT);
        cxfClient = ClientProxy.getClient((Object)port);
        modifyInterceptor = new ModifiedSignatureInterceptor();
        cxfClient.getOutInterceptors().add(modifyInterceptor);
        this.makeInvocation(port, true);
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testUntrustedSignature() throws Exception {
        if (!unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = ModifiedRequestTest.class.getResource("client-untrusted.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = ModifiedRequestTest.class.getResource("DoubleItFault.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItAsymmetricPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        this.makeInvocation(port, false);
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, STAX_PORT);
        this.makeInvocation(port, true);
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testModifiedEncryptedKey() throws Exception {
        if (!unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = ModifiedRequestTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = ModifiedRequestTest.class.getResource("DoubleItFault.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItAsymmetricPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        Client cxfClient = ClientProxy.getClient((Object)port);
        ModifiedEncryptedKeyInterceptor modifyInterceptor = new ModifiedEncryptedKeyInterceptor();
        cxfClient.getOutInterceptors().add(modifyInterceptor);
        this.makeInvocation(port, false);
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, STAX_PORT);
        cxfClient = ClientProxy.getClient((Object)port);
        modifyInterceptor = new ModifiedEncryptedKeyInterceptor();
        cxfClient.getOutInterceptors().add(modifyInterceptor);
        this.makeInvocation(port, true);
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testModifiedEncryptedSOAPBody() throws Exception {
        if (!unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = ModifiedRequestTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = ModifiedRequestTest.class.getResource("DoubleItFault.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItAsymmetricPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        Client cxfClient = ClientProxy.getClient((Object)port);
        ModifiedEncryptedSOAPBody modifyInterceptor = new ModifiedEncryptedSOAPBody();
        cxfClient.getOutInterceptors().add(modifyInterceptor);
        this.makeInvocation(port, false);
        port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, STAX_PORT);
        cxfClient = ClientProxy.getClient((Object)port);
        modifyInterceptor = new ModifiedEncryptedSOAPBody();
        cxfClient.getOutInterceptors().add(modifyInterceptor);
        this.makeInvocation(port, true);
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    private void makeInvocation(DoubleItPortType port, boolean streaming) throws DoubleItFault {
        try {
            port.doubleIt(25);
            ModifiedRequestTest.fail((String)"Expected failure on a modified request");
        }
        catch (SOAPFaultException ex) {
            SOAPFault fault = ex.getFault();
            if (streaming) {
                ModifiedRequestTest.assertTrue(("soap:Sender".equals(fault.getFaultCode()) || "soap:Receiver".equals(fault.getFaultCode()) ? 1 : 0) != 0);
                ModifiedRequestTest.assertTrue((boolean)fault.getFaultString().contains("A security error was encountered when verifying the message"));
                Iterator subcodeIterator = fault.getFaultSubcodes();
                ModifiedRequestTest.assertFalse((boolean)subcodeIterator.hasNext());
            }
            ModifiedRequestTest.assertTrue((boolean)fault.getFaultCode().endsWith("Sender"));
            ModifiedRequestTest.assertEquals((Object)fault.getFaultString(), (Object)"A security error was encountered when verifying the message");
            Iterator subcodeIterator = fault.getFaultSubcodes();
            ModifiedRequestTest.assertTrue((boolean)subcodeIterator.hasNext());
            Object subcode = subcodeIterator.next();
            ModifiedRequestTest.assertEquals((Object)WSSecurityException.SECURITY_ERROR, subcode);
            ModifiedRequestTest.assertFalse((boolean)subcodeIterator.hasNext());
        }
    }

    private static class ModifiedEncryptedSOAPBody
    extends AbstractModifyRequestInterceptor {
        private ModifiedEncryptedSOAPBody() {
        }

        @Override
        public void modifySecurityHeader(Element securityHeader) {
        }

        @Override
        public void modifySOAPBody(Element soapBody) {
            if (soapBody != null) {
                int index;
                Element cipherValue = WSSecurityUtil.findElement((Node)soapBody, (String)"CipherValue", (String)"http://www.w3.org/2001/04/xmlenc#");
                String cipherText = cipherValue.getTextContent();
                StringBuilder stringBuilder = new StringBuilder(cipherText);
                char ch = stringBuilder.charAt(index = stringBuilder.length() / 2);
                ch = ch != 'A' ? (char)'A' : 'B';
                stringBuilder.setCharAt(index, ch);
                cipherValue.setTextContent(stringBuilder.toString());
            }
        }
    }

    private static class ModifiedEncryptedKeyInterceptor
    extends AbstractModifyRequestInterceptor {
        private ModifiedEncryptedKeyInterceptor() {
        }

        @Override
        public void modifySecurityHeader(Element securityHeader) {
            if (securityHeader != null) {
                int index;
                Element encryptedKey = WSSecurityUtil.findElement((Node)securityHeader, (String)"EncryptedKey", (String)"http://www.w3.org/2001/04/xmlenc#");
                Element cipherValue = WSSecurityUtil.findElement((Node)encryptedKey, (String)"CipherValue", (String)"http://www.w3.org/2001/04/xmlenc#");
                String cipherText = cipherValue.getTextContent();
                StringBuilder stringBuilder = new StringBuilder(cipherText);
                char ch = stringBuilder.charAt(index = stringBuilder.length() / 2);
                ch = ch != 'A' ? (char)'A' : 'B';
                stringBuilder.setCharAt(index, ch);
                cipherValue.setTextContent(stringBuilder.toString());
            }
        }

        @Override
        public void modifySOAPBody(Element soapBody) {
        }
    }

    private static class ModifiedSignatureInterceptor
    extends AbstractModifyRequestInterceptor {
        private ModifiedSignatureInterceptor() {
        }

        @Override
        public void modifySecurityHeader(Element securityHeader) {
            if (securityHeader != null) {
                Element signatureElement = WSSecurityUtil.findElement((Node)securityHeader, (String)"Signature", (String)"http://www.w3.org/2000/09/xmldsig#");
                Node firstChild = signatureElement.getFirstChild();
                while (!(firstChild instanceof Element) && firstChild != null) {
                    firstChild = signatureElement.getNextSibling();
                }
                ((Element)firstChild).setAttributeNS(null, "Id", "xyz");
            }
        }

        @Override
        public void modifySOAPBody(Element soapBody) {
        }
    }

    private static class ModifiedTimestampInterceptor
    extends AbstractModifyRequestInterceptor {
        private ModifiedTimestampInterceptor() {
        }

        @Override
        public void modifySecurityHeader(Element securityHeader) {
            if (securityHeader != null) {
                Element timestampElement = WSSecurityUtil.findElement((Node)securityHeader, (String)"Timestamp", (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
                Element createdValue = WSSecurityUtil.findElement((Node)timestampElement, (String)"Created", (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
                XmlSchemaDateFormat zulu = new XmlSchemaDateFormat();
                XMLGregorianCalendar createdCalendar = WSSConfig.datatypeFactory.newXMLGregorianCalendar(createdValue.getTextContent());
                Duration duration = WSSConfig.datatypeFactory.newDuration(5000L);
                createdCalendar.add(duration);
                Date createdDate = createdCalendar.toGregorianCalendar().getTime();
                createdValue.setTextContent(zulu.format(createdDate));
            }
        }

        @Override
        public void modifySOAPBody(Element soapBody) {
        }
    }
}

