/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.httpget;

import java.net.URL;
import java.util.HashMap;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.ext.xml.XMLSource;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.httpget.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;
import org.example.contract.doubleit.DoubleItPortType;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class HTTPGetTest
extends AbstractBusClientServerTestBase {
    public static final String PORT = HTTPGetTest.allocatePort(Server.class);
    private static final String NAMESPACE = "http://www.example.org/contract/DoubleIt";
    private static final QName SERVICE_QNAME = new QName("http://www.example.org/contract/DoubleIt", "DoubleItService");
    private boolean unrestrictedPoliciesInstalled = this.checkUnrestrictedPoliciesInstalled();

    @BeforeClass
    public static void startServers() throws Exception {
        HTTPGetTest.assertTrue((String)"Server failed to launch", (boolean)HTTPGetTest.launchServer(Server.class, (boolean)true));
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        HTTPGetTest.stopAllServers();
    }

    @Test
    public void testSOAPClientSecurityPolicy() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = HTTPGetTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = HTTPGetTest.class.getResource("DoubleItHTTPGet.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItKeyIdentifierPort");
        DoubleItPortType x509Port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(x509Port, PORT);
        int result = x509Port.doubleIt(25);
        HTTPGetTest.assertEquals((long)result, (long)50L);
        bus.shutdown(true);
    }

    @Test
    public void testHTTPGetClientSecurityPolicy() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = HTTPGetTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        String address = "http://localhost:" + PORT + "/DoubleItX509KeyIdentifier/DoubleIt";
        WebClient client = WebClient.create((String)address);
        client.query("numberToDouble", new Object[]{"20"});
        try {
            client.get(XMLSource.class);
            HTTPGetTest.fail((String)"Failure expected on security policy failure");
        }
        catch (Exception exception) {
            // empty catch block
        }
        bus.shutdown(true);
    }

    @Test
    public void testSignedBodyTimestamp() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = HTTPGetTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = HTTPGetTest.class.getResource("DoubleItHTTPGet.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSignBodyPort");
        DoubleItPortType port = (DoubleItPortType)service.getPort(portQName, DoubleItPortType.class);
        this.updateAddressPort(port, PORT);
        HashMap<String, String> outProps = new HashMap<String, String>();
        outProps.put("action", "Timestamp Signature");
        outProps.put("signaturePropFile", "alice.properties");
        outProps.put("user", "alice");
        outProps.put("passwordCallbackClass", "org.apache.cxf.systest.ws.common.KeystorePasswordCallback");
        outProps.put("signatureParts", "{}{http://schemas.xmlsoap.org/soap/envelope/}Body;{}{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd}Timestamp;");
        bus.getOutInterceptors().add(new WSS4JOutInterceptor(outProps));
        int result = port.doubleIt(25);
        HTTPGetTest.assertEquals((long)result, (long)50L);
        bus.shutdown(true);
    }

    @Test
    public void testHTTPGetSignedBody() throws Exception {
        if (!this.unrestrictedPoliciesInstalled) {
            return;
        }
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = HTTPGetTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        String address = "http://localhost:" + PORT + "/DoubleItSignBody/DoubleIt";
        WebClient client = WebClient.create((String)address);
        client.query("numberToDouble", new Object[]{"20"});
        try {
            client.get(XMLSource.class);
            HTTPGetTest.fail((String)"Failure expected on security policy failure");
        }
        catch (Exception exception) {
            // empty catch block
        }
        bus.shutdown(true);
    }

    private boolean checkUnrestrictedPoliciesInstalled() {
        try {
            byte[] data = new byte[]{0, 1, 2, 3, 4, 5, 6, 7};
            SecretKeySpec key192 = new SecretKeySpec(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23}, "AES");
            Cipher c = Cipher.getInstance("AES");
            c.init(1, key192);
            c.doFinal(data);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

