/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.systest.ws.mtom;

import java.io.Closeable;
import java.io.File;
import java.net.URL;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.systest.ws.common.SecurityTestUtil;
import org.apache.cxf.systest.ws.mtom.Server;
import org.apache.cxf.testutil.common.AbstractBusClientServerTestBase;
import org.example.contract.doubleit.DoubleItMtomPortType;
import org.example.schema.doubleit.DoubleIt4;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class MTOMSecurityTest
extends AbstractBusClientServerTestBase {
    public static final String PORT = MTOMSecurityTest.allocatePort(Server.class);
    private static final String NAMESPACE = "http://www.example.org/contract/DoubleIt";
    private static final QName SERVICE_QNAME = new QName("http://www.example.org/contract/DoubleIt", "DoubleItService");

    @BeforeClass
    public static void startServers() throws Exception {
        MTOMSecurityTest.assertTrue((String)"Server failed to launch", (boolean)MTOMSecurityTest.launchServer(Server.class, (boolean)true));
    }

    @AfterClass
    public static void cleanup() throws Exception {
        SecurityTestUtil.cleanup();
        MTOMSecurityTest.stopAllServers();
    }

    @Test
    public void testSignedMTOMInline() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = MTOMSecurityTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = MTOMSecurityTest.class.getResource("DoubleItMtom.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSignedMTOMInlinePort");
        DoubleItMtomPortType port = (DoubleItMtomPortType)service.getPort(portQName, DoubleItMtomPortType.class);
        this.updateAddressPort(port, PORT);
        FileDataSource source = new FileDataSource(new File("src/test/resources/java.jpg"));
        DoubleIt4 doubleIt = new DoubleIt4();
        doubleIt.setNumberToDouble(25);
        port.doubleIt4(25, new DataHandler((DataSource)source));
        ((Closeable)port).close();
        bus.shutdown(true);
    }

    @Test
    public void testSignedMTOMSwA() throws Exception {
        SpringBusFactory bf = new SpringBusFactory();
        URL busFile = MTOMSecurityTest.class.getResource("client.xml");
        Bus bus = bf.createBus(busFile.toString());
        SpringBusFactory.setDefaultBus((Bus)bus);
        SpringBusFactory.setThreadDefaultBus((Bus)bus);
        URL wsdl = MTOMSecurityTest.class.getResource("DoubleItMtom.wsdl");
        Service service = Service.create((URL)wsdl, (QName)SERVICE_QNAME);
        QName portQName = new QName(NAMESPACE, "DoubleItSignedMTOMSwAPort");
        DoubleItMtomPortType port = (DoubleItMtomPortType)service.getPort(portQName, DoubleItMtomPortType.class);
        this.updateAddressPort(port, PORT);
        FileDataSource source = new FileDataSource(new File("src/test/resources/java.jpg"));
        DoubleIt4 doubleIt = new DoubleIt4();
        doubleIt.setNumberToDouble(25);
        port.doubleIt4(25, new DataHandler((DataSource)source));
        ((Closeable)port).close();
        bus.shutdown(true);
    }
}

